<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Estado extends Elotech_Db_Table_Abstract {

    protected $_name = 'estado';
    protected $_primary = 'uf_codigo';

    /*-----------------------------------------------------------
    * AÇÃO SOCIAL
    *----------------------------------------------------------*/

    public function getCodigoPeloNome($estado=FALSE){
        $sql = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("est"=>"estado"),array("uf_codigo"))
                      ->where("retira_acentos(UPPER(uf_sigla)) = retira_acentos(UPPER('$estado'))")
                      ->order("uf_codigo DESC")
                      ->limit(1);
        return $this->fetchRow($sql);
    }

    public function buscaDados($term){
        $sql =  $this->select(FALSE)
                     ->setIntegrityCheck(FALSE)
                     ->from(array("est"=>"estado"),array("uf_codigo", "uf_nome"))
                     ->where("retira_acentos(uf_nome) ilike retira_acentos('%$term%')")
                     ->order("uf_nome");
        return $this->fetchAll($sql);
    }

    public function salvar(array $data) {
	    try{
        return parent::salvar($data);
      } catch (Exception $ex) {
        throw new Zend_Validate_Exception("Falha ao salvar estado: ".$ex->getMessage());
      }
    }

    /*-----------------------------------------------------------
    * FIM AÇÃO SOCIAL
    *----------------------------------------------------------*/

    public function listaEstadoPorPais($pais_codigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("est"=>"estado"),array("uf_codigo","uf_nome"))
                    ->where("pais_codigo =?",$pais_codigo);
        return $this->fetchAll($sql);
    }

    /**
     * Buscar os estados
     * usado para alimentar o plugin de busca (jquery)
     * @return json
     */
    public function buscar($term) {
      $sql = $this->select(FALSE)
        ->setIntegrityCheck(FALSE)
        ->from(array("est" => "estado"), array("uf_codigo", "uf_nome"))
        ->where("retira_acentos(uf_nome) ilike retira_acentos('%$term%')")
        ->order("uf_nome");
      $all = $this->fetchAll($sql);

      $out = array();
      foreach ($all as $uf) {
        $out [] = array(
          "id" => $uf->uf_codigo,
          "label" => trim($uf->uf_nome),
          "data" => $uf->toArray()
        );
      }

      if (!count($out)) {
        $out [] = array(
          "id" => 0,
          "label" => "Nenhum item encontrado",
          "data" => array()
        );
      }

      return $out;
    }

}
