<?php

/**
 * Helper para models
 */
class Application_Model_Funcoes {

	/**
	 * Informa o IP do cliente
	 * @return string IP do cliente
	 */
    
    
    public function ValidaData($dat){
            $data = explode("/","$dat"); // fatia a string $dat em pedados, usando / como referência
            $d = $data[0];
            $m = $data[1];
            $y = $data[2];

            // verifica se a data é válida!
            // 1 = true (válida)
            // 0 = false (inválida)
            return checkdate($m,$d,$y);
            
    }
	public function getIp() {
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {  
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {   
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$ip = $_SERVER['REMOTE_ADDR'];
		}
		return $ip;
	}
	
	/**
	 * Converte uma data de d/m/Y para Y-m-d e vice-versa
	 */
	public function invertData($data, $separadorEntrada="-",$separadorSaida="/"){
		list($a,$b,$c) = explode($separadorEntrada, $data);
		return $c.$separadorSaida.$b.$separadorSaida.$a;
	}
	/**
	 * Transforma um Zend_Db_Table_Rowset_Abstract em uma string, concatenando os procedimentos com virgula
	 * @param Zend_Db_Table_Rowset_Abstract $rowset
	 * @return string 
	 */
	public function rowsetToStr($rowset,$colName){
		$out = array();
		foreach ($rowset as $row) 
			$out []= trim($row->$colName);
		
		return implode(", ",$out);
	}

	/**
	 * Cria uma array com as datas entre $data_inicial e $data_final (inclusive)
	 * @param string $data_inicial
	 * @param string $data_final 
	 */
	public function datasToArray($data_inicial, $data_final){
		list($y1,$m1,$d1) = explode("-",$data_inicial);
		list($y2,$m2,$d2) = explode("-",$data_final);
		
		$mk_inicio = mktime(0, 0, 0, $m1, $d1, $y1);
		$mk_fim = mktime(0, 0, 0, $m2, $d2, $y2);
		
		$out = array();
		while($mk_inicio <= $mk_fim){
			$out []= date("Y-m-d",$mk_inicio);
			$mk_inicio = mktime(0, 0, 0, $m1, ++$d1, $y1);
		}
		return $out;		
	}
	
	/**
	 * Retorna o primeiro e o ultimo dia do mês informado
	 * @example "04/2012": 2012-04-01,2012-04-30
	 * @param string $mesAno m/Y
	 * @return array
	 */
	public function getPrimeiroEUltimoDia($mesAno){
		if(!$mesAno)
			return array_pad(array(), 4, FALSE);
		
		list($mes, $ano) = explode("/",$mesAno);
		$mk = mktime(0, 0, 0, $mes, 1, $ano);
		
		return array(
			"$ano-$mes-01",
			"$ano-$mes-".date("t",$mk),
			$mes,
			$ano
		);
	}
        
        public function diaSemana($data){  
                $ano =  substr($data,0,4);
                $mes =  substr($data,5,2);
                $dia =  substr($data,8,7);

                if(checkdate($mes,$dia,$ano)){
                        $diasemana = date("w", mktime(0,0,0,$mes,$dia,$ano) );
                        switch($diasemana){  
                                                case"0": $diasemana = "7";	   break;  //domingo
                                                case"1": $diasemana = "1"; break;     //segunda
                                                case"2": $diasemana = "2";   break;  //terça
                                                case"3": $diasemana = "3";  break;  //quarta
                                                case"4": $diasemana = "4";  break;  //quinta
                                                case"5": $diasemana = "5";   break;  //sexta
                                                case"6": $diasemana = "6";		break;  //sabado
                                         }
                        return $diasemana;
                }
        }
        
        public function calculaQuantidadePorIntervalo($horarios=FALSE,$coni_codigo=FALSE,$dia=FALSE){
            if(empty($horarios))
                return false;
            
            $minutosEntreConsultas = array();
           //echo "<pre>".print_r($horarios,1);die();
            foreach ($horarios as $horario){
                date_default_timezone_set('UTC');
                $hours_diff = strtotime($horario->hora_final)-strtotime("$horario->hora_inicial");
                
                $hi = explode(":",$horario->hora_inicial);
                $hf = explode(":",$horario->hora_final);
                //a funcao do php calculava errado horarios iguais Ex: 10:20 - 10:00 ele retornava sempre 12:20 de intervalo considertando um dos 10 como 22
                $h1 = explode(":", date('h:i', $hours_diff));
                if($hi[0] == $hf[0]){ 
                    $h1[0] = 00;
                }
                $hora_minutos = $h1[0] * 60;
                $hora_minutos += $h1[1];
                array_push($minutosEntreConsultas, $hora_minutos);
            }
            $quantidades = $this->calculaQuantidade($minutosEntreConsultas,$coni_codigo,$dia);
            //echo "<pre>".print_r($quantidades,1);die();die();
            return $quantidades;
            //return $minutosEntreConsultas;
        }
        
        public function calculaQuantidade($minutosEntreConsultas=FALSE,$coni_codigo,$dia=FALSE){
            
            $tbGrad = new Application_Model_GradeDia();
            $intervalo = $tbGrad->getIntervaloDia($coni_codigo, $dia);
            $quantidades = array();
            //die($intervalo);
            //echo "<pre>".print_r($minutosEntreConsultas,1);die();
            
            foreach($minutosEntreConsultas as $minutosEntreConsulta){
                $quantidade = ($minutosEntreConsulta / $intervalo);
                array_push($quantidades, $quantidade);
            }
            //echo "<pre>".print_r($quantidades,1);die();
            return $quantidades;
        }
        
        public function distribuicao($quantidades=FALSE,$horarios=FALSE,$coni_codigo=FALSE,$data_selecionada){
            $i = 0;
            $tbConi = new Application_Model_ConvenioItens();
            $tbAgen = new Application_Model_Agendamento();
            $tbGrad = new Application_Model_GradeDia();
            $intervalo = $tbGrad->getIntervaloDia($coni_codigo, $data_selecionada);
            $tbGrah = new Application_Model_GradeHorario();
            
            $tempos = array();
            foreach ($horarios as $horario){
                $horario->hora_inicial;
                $horario->hora_final;
               // echo $quantidades[$i]."<br/>";
                for($j=0;$j < (int) round($quantidades[$i]);$j++){
                    $hora = explode(":", $horario->hora_inicial);
                    $horario->hora_inicial = $hora[0].":".$hora[1]; // funcao para a primeira hora nao ficar como 00:00:00
                    $horario_bloqueado = $tbGrah->getHorarioCancelado($horario->hora_inicial,$coni_codigo,$data_selecionada);
                    $quantidade_agendada = $tbAgen->getAgendamentosPorHorario($horario->hora_inicial,$coni_codigo,$data_selecionada);
                    if($horario_bloqueado){
                        $tempos[$horario->hora_inicial] = $horario_bloqueado->quantidade."|BLOQUEADO:  ".($horario_bloqueado->grah_motivo == "" ? "Sem Motivo" : "$horario_bloqueado->grah_motivo");
                    }else{
                        $tempos[$horario->hora_inicial] = $quantidade_agendada->quantidade."|".$quantidade_agendada->age_paciente;
                    }
                    $novo_horario = mktime($hora[0], $hora[1] + $intervalo);
                    $horario->hora_inicial = date("H:i", $novo_horario);
                    $hora_minutos_inicial += $intervalo;
                }
                $i++;
            }
            return $tempos;
        }
}

