<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_GrupoAcessoPermissoes extends Elotech_Db_Table_Abstract {

    protected $_name = 'grupo_acesso_permissoes';
    protected $_primary = 'grap_codigo';

    public function salvar(array $data) {
		//throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }
    
    public function excluir($grap_codigo=FALSE) {
            $item = $this->fetchRow("grap_codigo=$grap_codigo");
            if ($item) {
                    $item->delete();
            }
    }

    public function verificaSeJaExiste($data=FALSE){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("grau"=>"grupo_acesso_permissoes"),"count(grap_codigo) as qtde")
                      ->where("grac_codigo=$data[grac_codigo]")
                      ->where("ace_codigo=$data[ace_codigo]");
        //die($where);
        return $this->fetchRow($where);
    }

    public function getPermissoesByGrupo($grac_codigo = FALSE, $term = FALSE){
        $where = $this->select()
                      ->setIntegrityCheck(FALSE)
                      ->from(["grap"=>"grupo_acesso_permissoes"],"grap_codigo")
                      ->join(["ace"=>"acesso"],"ace.ace_codigo = grap.ace_codigo",["ace_codigo","ace_descricao","ace_caminho"]);
        if ($grac_codigo){
            $where->where("grap.grac_codigo = $grac_codigo");
        }
        if ($term){
           $where->where("ace.ace_descricao ILIKE '%$term%'");
        }
        $where->order("ace.ace_descricao");

        return $this->fetchAll($where);

    }
}
