<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_GrupoAcessoUsuarios extends Elotech_Db_Table_Abstract {

    protected $_name = 'grupo_acesso_usuarios';
    protected $_primary = 'grau_codigo';

    public function salvar(array $data) {
		//throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }
    
    public function excluir($grau_codigo=FALSE) {
            $item = $this->fetchRow("grau_codigo=$grau_codigo");
            if ($item) {
                    $item->delete();
            }
    }
    
    public function getGridResource($page = 1, $limit = FALSE, $sidx = NULL, $sord = "ASC", $where = NULL) {
            $this->setFields(array("grau_codigo","usr_nome","usr_codigo"));

            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("grau"=>"grupo_acesso_usuarios"),array("grau_codigo","grac_codigo"))
                            ->join(array("usr"=>"usuarios"),"usr.usr_codigo=grau.usr_codigo",array("usr_codigo","usr_nome"))
                            ->where("grac_codigo=$where");

            return parent::getGridResource($page, $limit, $sidx, $sord, $where);
    }
    
    public function verificaSeJaExiste($data=FALSE){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("grau"=>"grupo_acesso_usuarios"),"count(grau_codigo) as qtde")
                      ->where("grac_codigo=$data[grac_codigo]")
                      ->where("usr_codigo=$data[usr_codigo]");
        return $this->fetchRow($where);
    }
    
    public function verificaAcessoCursoSuperior($usrCodigo=FALSE){
        $sql = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("grau"=>"grupo_acesso_usuarios"),"count(grau_codigo) as acesso")
                      ->join(array("grac"=>"grupo_acesso"),"grau.grac_codigo=grac.grac_codigo",array())
                      ->where("grac_num=?","1")
                      ->where("usr_codigo=?",$usrCodigo);
        return $this->fetchRow($sql);
    }

    public function getUsrsByGrupo($id){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("grau"=>"grupo_acesso_usuarios"),array("grau_codigo"))
            ->join(array("usr"=>"usuarios"),"usr.usr_codigo=grau.usr_codigo",array("usr_codigo","usr_nome"))
            ->where("grac_codigo=$id")
            ->order("usr.usr_nome");
        return $this->fetchAll($where);
    }

    public function getUsrByNameAndGrupo($id, $term){
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("grau"=>"grupo_acesso_usuarios"),array("grau_codigo","grac_codigo"))
            ->join(array("usr"=>"usuarios"),"usr.usr_codigo=grau.usr_codigo",array("usr_codigo","usr_nome"))
            ->where("grac_codigo=$id AND usr.usr_nome ILIKE '%$term%' ")
            ->order("usr.usr_nome");

        return $this->fetchAll($where);
    }
}
