<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Medico extends Elotech_Db_Table_Abstract {

	protected $_name = 'medico';
	protected $_primary = 'med_codigo';
	
	/**
	 * Prestador de serviço
	 */
	const LABORATORIO = "L";
	const MEDICO = "M";
	const HOSPITAL = "H";

	public function salvar(array $data) {

		return false; // não pode salvar medico;
	}

	/**
	 * Buscar os médicos externos
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE,$prestador=array('M')) {
		if ($term)
			$where = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("med" => "medico"), array("med_codigo", "med_nome"))
					->where("prestador_servico IN (?)", $prestador)
					->where("retira_acentos(med_nome) ilike retira_acentos('%$term%')", "S")
					->order(array("med_nome"))
					->limit(500);

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $usu) {
			$data = array();
			foreach ($usu as $key => $value) {			
				foreach($prestador as $prest)
					$data [$key."_".$prest] = $value;
			}

			$out [] = array(
				"id" => $usu->med_codigo,
				"label" => $usu->med_nome,
				"data" => $data
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("med_codigo" => "0", "med_nome" => "")
			);
		}

		return $out;
	}
        
        public function getInfoMedico($med_codigo=FALSE){
            if(!$med_codigo)
                return false;
                
            return $this->fetchRow ("med_codigo=$med_codigo");
        }

}
