<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_MedicoEspecialidade extends Elotech_Db_Table_Abstract {

	protected $_name = 'medico_especialidade';
	protected $_primary = 'mes_codigo';
	protected $_sequence = "seq_mes_codigo";


	public function getEspecialidadePorMedico($usr_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("usr_nome", "cnes_sigla_est"))
			->join(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo", array("mes_codigo", "uni_codigo"))
			->join(array("esp" => "especialidade"), "mes.esp_codigo=esp.esp_codigo", array("esp_nome", "esp_codigo"))
			->join(array("uni" => "unidade"), "uni.uni_codigo=mes.uni_codigo", "uni_desc")
			->where("usr.usr_codigo=?", $usr_codigo)
			->where("mes_ativo = 'A'");
		if ($uni_codigo) {
			$where->where("uni.uni_codigo = $uni_codigo");
		}
		$where->order("esp_nome");
//            die($where);
		return $this->fetchAll($where);
	}

	public function getEspecialidadePorConvenio($conv_codigo = FALSE, $usr_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("coni" => "convenio_itens"), array("coni_codigo"))
			->join(array("esp" => "especialidade"), "coni.esp_codigo=esp.esp_codigo", array("esp_nome", "esp_codigo"))
			->where("coni.conv_codigo=?", $conv_codigo)
			->where("coni.usr_codigo=?", $usr_codigo)
			->order("esp_nome");
		// die($where);
		return $this->fetchAll($where);
	}


	public function salvar($data) {
		try {
			if ($this->verificaSeJáExiste($data['med_codigo'], $data['esp_codigo'], $data['uni_codigo'])->qtd >= 1) {
				return false;
			} else {
				return parent::salvar($data);
			}
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao cadastrar a especialidade do Profissional: " . $exc->getMessage());
		}


	}

	public function excluir($mes_codigo = FALSE) {
		$item = $this->fetchRow("mes_codigo=$mes_codigo");
		if ($item) {

			$item->delete();
		}
	}

	public function verificaSeJáExiste($usr_codigo = FALSE, $esp_codigo = FALSE, $uni_codigo = FALSE) {
		$this->deleteInativos($usr_codigo, $esp_codigo, $uni_codigo);
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mes" => "medico_especialidade"), array("qtd" => "count(*)", "mes_codigo"))
			->where("med_codigo = $usr_codigo")
			->where("esp_codigo = $esp_codigo")
			->where("uni_codigo = $uni_codigo")
			->where("mes_ativo != 'I'")
			->group("mes_codigo");

		return $this->fetchRow($where);
	}

	public function deleteInativos($usr_codigo, $esp_codigo, $uni_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("medico_especialidade")
			->where("med_codigo = $usr_codigo")
			->where("esp_codigo = $esp_codigo")
			->where("uni_codigo = $uni_codigo")
			->where("mes_ativo = 'I'");
		$item = $this->fetchAll($sql);
		if ($item) {
			foreach ($item as $i)
				$i->delete();
			return true;
		}

	}

}
