<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_MicroArea extends Elotech_Db_Table_Abstract {

    protected $_name = 'microarea';
    protected $_primary = 'mic_codigo';
    protected $_sequence = 'seq_mic_codigo';

    public function salvar(array $data) {
		//throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }
    
    public function getMicroAreas(){
        $where = $this->select()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("mic"=>"microarea"))
                      ->join("area", "area.area_codigo=mic.area_codigo","area_desc")
                      ->joinLeft(array("usr"=>"usuarios"), "usr.usr_codigo=mic.mic_responsavel","usr_nome")
                      ->order("mic_codigo DESC");
        //die($where);
        return $this->fetchAll($where);
    }
    
    public function getMicroArea($mic_codigo){
        $where = $this->select()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("mic"=>"microarea"))
                      ->joinLeft(array("usr"=>"usuarios"), "usr.usr_codigo=mic.mic_responsavel",array("usr_nome","usr_codigo"))
                      ->join("area","area.area_codigo=mic.area_codigo")
                      ->where("mic_codigo=$mic_codigo");
        //die($where);
        return $this->fetchRow($where);
    }
    
    
    
    public function pesquisar($dados=NULL){
        $where = $this->select()
                      ->setIntegrityCheck(FALSE)
                      ->from(array("mic"=>"microarea"))
                      ->join("area","area.area_codigo=mic.area_codigo")
                      ->joinLeft(array("usr"=>"usuarios"), "usr.usr_codigo=mic.mic_responsavel","usr_nome");
        
        if (is_string($dados)){
            $where->where("area_desc ilike '%$dados%' or usr_nome ilike '%$dados%' or mic_descricao ilike '%$dados%' ");
        }else if (is_int($dados)){
            $where->where("");
        }

        if ($limit) {
                $where->limit(15);
        }
        //die($where);
        return $this->fetchAll($where);
    }
    
    public function excluir($area_codigo=FALSE) {
            $item = $this->fetchRow("area_codigo=$area_codigo");
            if ($item) {
                    $item->delete();
            }
    }
}
