<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_MotivoAtendimento extends Elotech_Db_Table_Abstract
{
    protected $_name = 'as_atendimento_basicocras_motivo';
    protected $_primary = 'asabm_codigo';

    public function salvar($data)
    {
        try {
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception(
                "Falha ao salvar Motivo: " . $ex->getMessage());
        }
    }

    public function excluirMotivosAtendimento($asabCodigo = FALSE)
    {
        $itens = $this->fetchAll("asab_codigo=$asabCodigo");
        if ($itens) {
            foreach ($itens as $item) {
                $item->delete();
            }
        }
        return true;
    }

    public function getMotivoPorAsab($asabCodigo = false)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("asabm" => "as_atendimento_basicocras_motivo"), "asam_codigo")
            ->join(array("asam" => "as_atendimento_motivo"), "asam.asam_codigo=asabm.asam_codigo", "asam_nome")
            ->where("asab_codigo=?", $asabCodigo);
        return $this->fetchAll($where);
    }
}