<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Movimento extends Elotech_Db_Table_Abstract {

    protected $_name = 'movimento';
	protected $_primary = 'mov_codigo';
    protected $_sequence = 'seq_mov_codigo';
	
	/**
	 * mov_tipo
	 */
	const ENTRADA = "E";
	const SAIDA = "S";
	const TRANSFERENCIA = "T"; 
	
	/**
	 * mov_entrada
	 */
	const NORMAL = "E";
	const AJUSTE = "A";
	const EMPRESTIMO = "M";
	const INVENTARIO = "I";
	const DOACAO = "D";
	const PERMUTA = "P";
	const OUTRAS = "O";
  //const TRANSFERENCIA = "T"; 
	const DEVOLUCAO = "V";
	
	/**
	 * mov_saida
	 */
	const CONSUMO = "S";
	const DISPENSACAO = "D";
  //const EMPRESTIMO = "M";
  //const PERMUTA = "P";
  //const INVENTARIO = "I";
  //const AJUSTE = "A";
	const PERDAS = "R";
  //const OUTRAS = "O";
  //const TRANSFERENCIA = "T"; 
	
    public function salvar(array $data) {
		
		$this->valoresPadrao($data);
		
		// validação:
		if(!in_array($data['mov_tipo'], array(self::ENTRADA,self::SAIDA,self::TRANSFERENCIA))){
			throw new Zend_Validate_Exception("\"mov_tipo\" precisa ser: ENTRADA, SAIDA ou TRANSFERENCIA");
		}
		
		$this->peloMenosUm(array("mov_entrada","mov_saida"), $data);
		$this->peloMenosUm(array("set_entrada","set_saida"), $data);
		
        return parent::salvar($data);
    }
	
	private function valoresPadrao(&$data){
		$tbUsr = new Application_Model_Usuarios;
		$usu = $tbUsr->getUsrAtual();
		
		if(empty($data['mov_data'])){
			$data['mov_data'] = date("Y-m-d");
		}		
		
		if(empty($data['usr_codigo'])){
			$data['usr_codigo'] = $usu->usr_codigo;
		}	
		
		if(empty($data['mov_ip'])){
			$fun = new Application_Model_Funcoes();
			$data['mov_ip'] = (string) $fun->getIp();
		}	
		
		if($data['mov_tipo'] == self::ENTRADA && empty ($data['set_entrada'])){
			$data['set_entrada'] = $usu->set_codigo;
		}
		
		if($data['mov_tipo'] == self::SAIDA && empty ($data['set_saida'])){
			$data['set_saida'] = $usu->set_codigo;
		}
	}
	
	public function getMedicamentosDispensados($usu_codigo, $data_inicial=FALSE, $data_final=FALSE){
		// produtos "inteiros"
		$where1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("m"=>"movimento"),array("unidade"=>"COALESCE('1','1')","mov_codigo","mov_data"))
				->join(array("i"=>"itens_movimento"),"i.mov_codigo=m.mov_codigo",array("ite_quantidade","ite_lote"))
				->join(array("p"=>"produto"),"p.pro_codigo=i.pro_codigo","pro_nome")
				->join(array("s"=>"setor"),"s.set_codigo=m.set_saida","")
				->join(array("u"=>"unidade"),"u.uni_codigo=s.uni_codigo","uni_desc")
				->join(array("usr"=>"usuarios"),"usr.usr_codigo=m.usr_codigo","usr_nome")
				->where("mov_tipo='S'")
				->where("usu_codigo=?",$usu_codigo);
		
		// produtos fracionados
		$where2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("vac"=>"vacina_usuario"),array("unidade"=>"COALESCE('0','0')", "vac_usu_codigo", "mov_data"=>"vac_data","ite_quantidade"=>"vac_qtde"))
				->join(array("cont"=>"controlefracionado"),"cont.cont_codigo=vac.cont_codigo","")
				->join(array("ite"=>"itens_movimento"),"ite.ite_codigo=cont.ite_codigo","ite_lote")
				->join(array("pro"=>"produto"),"pro.pro_codigo=ite.pro_codigo","pro_nome")
				->join(array("mov"=>"movimento"),"mov.mov_codigo=ite.mov_codigo","")
				->join(array("set"=>"setor"),"set.set_codigo=mov.set_saida","")
				->join(array("uni"=>"unidade"),"uni.uni_codigo=set.uni_codigo","uni_desc")
				->join(array("usr"=>"usuarios"),"usr.usr_codigo=mov.usr_codigo","usr_nome")
				->where("vac.usu_codigo=?",$usu_codigo);
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->union(array($where1,$where2), Zend_Db_Select::SQL_UNION_ALL)
				->order(array("mov_data DESC"));
		
                //die($where);
		return $this->fetchAll($where);
	}
        
        public function relDispensados($set_codigo, $data_inicial=FALSE, $data_final=FALSE){
		// produtos "inteiros"
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("m"=>"movimento"),array("mov_codigo","mov_data"))
				->join(array("i"=>"itens_movimento"),"i.mov_codigo=m.mov_codigo",array("ite_quantidade","ite_lote","pro_codigo"))
				->join(array("p"=>"produto"),"p.pro_codigo=i.pro_codigo","pro_nome")
				->join(array("s"=>"setor"),"s.set_codigo=m.set_saida","")
				->join(array("usu"=>"usuario"),"usu.usu_codigo=m.usu_codigo",array("usu_nome","usu_codigo"))
                                ->order(array("usu_nome","m.usu_codigo","mov_data","pro_nome"));
                
                if($data_inicial){
                    $where->where("mov_data >='$data_inicial'");
                }
                if($data_final){
                    $where->where("mov_data <=' $data_final'");
                }
                if($set_codigo){
                    $where->where("set_saida = $set_codigo");
                }
                
                return $this->fetchAll($where);
        }

}
