<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Pessoa extends Elotech_Db_Table_Abstract {
    
    protected $_name = 'pessoa';
    protected $_schema = 'aise';
    protected $_primary = 'pessoa';
    protected $_sequence = 'aise.s90pessoa';
    
    // Efetua a inserção de pessoa no banco do AISE
    public function salvar(array $data) {
        try {
            $pessoa = parent::salvar($data);
        } catch (Exception $exc) {
            //throw new Zend_Validate_Exception($exc->getMessage());
            throw new Zend_Validate_Exception("Falha ao cadastrar pessoa!"); 
        }
        return $pessoa;        
    }
    
    public function listaCadastroDuplicado($dadosPessoa){
        $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("pes" => "aise.pessoa"),array("pes.pessoa","pes.nome","pes.datanascimento"))
                        ->joinLeft(array("pep"=>"pessoa_paciente"),"pes.pessoa=pep.pessoa",array("pep_mae"))
                        ->where("pes.nome ILIKE '%".$dadosPessoa[0]."%'")
                        ->where("pes.datanascimento =?",$dadosPessoa[1])
                        ->where("pep.pep_mae ILIKE '%".$dadosPessoa[2]."%'");
        return $this->fetchAll($sql);
    }
    
    // Confere se a sequence do código de pessoa foi inserida ou não
    public function getQtdDeCadastroDuplicado($dadosPessoa){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("pes" => "aise.pessoa"),array("COUNT(pes.pessoa) AS qtdCadDup"))
                    ->joinLeft(array("pep"=>"pessoa_paciente"),"pes.pessoa=pep.pessoa",array(""))
                    ->where("pes.nome ILIKE '%".$dadosPessoa["nome"]."%'")
                    ->where("pes.datanascimento =?",$dadosPessoa["datanascimento"])
                    ->where("pep.pep_mae ILIKE '%".$dadosPessoa["pep_mae"]."%'");
        return $this->fetchRow($sql);
    }
    
    public function listaDadosPessoa($pessoa){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("pes"=>'aise.pessoa'))
                    ->join(array("pep"=>"pessoa_paciente"),"pes.pessoa=pep.pessoa")
                    ->joinLeft(array("dom"=>"domicilio"),"pep.dom_codigo=dom.dom_codigo")
                    ->joinLeft(array("rua"),"dom.rua_codigo=rua.rua_codigo")
                    ->where("pes.pessoa =?",$pessoa);
        return $this->fetchAll($sql);
    }
    
    // Confere se a sequence do código de pessoa foi inserida ou não
    public function confereInsPessoa($codPes){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from("aise.pessoa",array("COUNT(pessoa) AS numRegistro"))
                    ->where("pessoa =?",$codPes);
        return $this->fetchRow($sql);
    }
        /**
	 * Buscar os Pessoa
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE) {
		if ($term)
			$busca = "nome ilike retira_acentos('%$term%')";

		$all = $this->fetchAll($busca, "nome");

		$out = array();
		foreach ($all as $pessoa) {
			$out [] = array(
				"id" => $pessoa->pessoa,
				"label" => trim($pessoa->nome),
				"data" => array("pessoa" => $pessoa->pessoa,"nome" => $pessoa->nome)
			);
		}

		/*if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("pessoa" => "")
			);
		}
*/
		return $out;
	}


}
