<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_PessoaPaciente extends Elotech_Db_Table_Abstract {
    protected $_name = 'pessoa_paciente';
    protected $_primary = 'pep_codigo';
    
    public function salvar(array $data) {
        $this->notEmpty(array("pessoa"), $data);  
        try {
            $pessoa = parent::salvar($data);
        } catch (Exception $exc) {
            //throw new Zend_Validate_Exception($exc->getMessage());
            throw new Zend_Validate_Exception("Falha ao cadastrar o Paciente");
        }
        return $pessoa;        
    }
    
    public function confereInsPesPaciente($codPes){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("pep"=>"pessoa_paciente"),array("pep_codigo"))
                    ->where("pessoa =?",$codPes);
        return $this->fetchRow($sql);
    }
    
     /**
	 * Buscar os Pessoa
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE) {
		if ($term)
			$busca = "nome ilike retira_acentos('%$term%')";

		$all = $this->fetchAll($busca, "nome");

		$out = array();
		foreach ($all as $pessoa) {
			$out [] = array(
				"id" => $pessoa->pessoa,
				"label" => trim($pessoa->nome),
				"data" => array("pessoa" => $pessoa->pessoa,"nome" => $pessoa->nome)
			);
		}

		/*if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("pessoa" => "")
			);
		}
*/
		return $out;
	}
        public function sequencia(){
            return $this->getDefaultAdapter()->query("select nextval(aise.s90pessoa)");
        }
        
        public function listaDadosPessoa($pessoa){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("pep"=>'pessoa_paciente'))
                        ->join(array("pes"=>'aise.pessoa'),"pep.pessoa=pes.pessoa")
                        ->joinLeft(array("dom"=>"domicilio"),"pep.dom_codigo=dom.dom_codigo")
                        ->joinLeft(array("rua"),"dom.rua_codigo=rua.rua_codigo")
                        ->where("pep.pep_codigo =?",$pessoa);
            return $this->fetchAll($sql);
        }
 

}
