<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Produto extends Elotech_Db_Table_Abstract {

	protected $_name = 'produto';
	protected $_primary = 'pro_codigo';
	protected $_dependentTables = array('LeitoGradeItens');

	/**
	 * Motivos da perda (vacina)
	 */
	const QUEBRA_DE_FRASCO = 1;
	const FALTA_DE_ENERGIA = 2;
	const FALHA_NO_EQUIPAMENTO = 3;
	const VALIDADE_VENCIDA = 4;
	const PROCEDIMENTO_INADEQUADO = 5;
	const FALHA_NO_TRANSPORTE = 6;
	const OUTROS_MOTIVOS = 7;

	/**
	 * Busca medicamentos não-controlados
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscarMedicamentosPosto($term=FALSE) {
		return $this->buscarMedicamentos($term, FALSE);
	}

	/**
	 * Busca medicamentos controlados
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscarMedicamentosControlado($term=FALSE) {
		return $this->buscarMedicamentos($term, TRUE);
	}

	public function buscarMedicamentos($term=FALSE, $controlado=NULL, $limite=FALSE,$movimento=FALSE) {
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("pro" => "produto"))
				->where("pro_tipo='M'")
				->where("pro_situacao='A'")
				->order("pro_nome");
                

		if ($term)
			$where->where("pro_nome ilike '%$term%'");

		if ($controlado === FALSE) {
			$where->where("psico_codigo IS NULL");
		} elseif ($controlado === TRUE) {
			$where->where("psico_codigo IS NOT NULL");
		}

		if ($limite) {
			$where->limit($limite);
		}
                
                if($movimento)
                    $where->join (array("im"=>"itens_movimento"), "im.pro_codigo=p.pro_codigo");
		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $pro) {
			$out [] = array(
				"id" => $pro->pro_codigo,
				"label" => $pro->pro_nome,
				"data" => array("pro_codigo" => $pro->pro_codigo,"pro_nome" => $pro->pro_nome)
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array()
			);
		}
		return $out;
	}
        
        public function buscarMedicamentosComMovimentacoes(){
            $where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("pro" => "produto"),array("pro_codigo","pro_nome"))
                                ->distinct("DISTINCT")
                                ->join(array("im"=>"itens_movimento"), "im.pro_codigo=pro.pro_codigo","")
				->where("pro_tipo='M'")
				->where("pro_situacao='A'")
                                ->where("pro_horus is null")
				->order("pro_nome");
            //die($where);
            return $this->fetchAll($where);
            
        }
        
        
        public function buscarMedicamentosHorus($term=FALSE, $controlado=NULL, $limite=FALSE) {
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("pro" => "produto"))
				->where("pro_tipo='M'")
				->where("pro_situacao='A'")
                                ->where("gru_codigo=99482")
                                ->where("pro_horus is not null")
                                ->where("pro_codigo not in (select distinct pro_codigo from itens_movimento)")
				->order("pro_nome");
		if ($term)
			$where->where("pro_nome ilike '%$term%'");


		if ($limite) {
			$where->limit($limite);
		}

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $pro) {
			$out [] = array(
				"id" => $pro->pro_codigo,
				"label" => $pro->pro_nome,
				"data" => array("pro_codigo" => $pro->pro_codigo,"pro_nome" => $pro->pro_nome,
                                "horus" => $pro->pro_horus)
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array()
			);
		}
		return $out;
	}

	/**
	 * Seleciona os lotes necessários para atingir a quantidade selecionada.
	 */
	public function selecionaMelhorLote($produtos, $set_codigo) {
		$tbCont = new Application_Model_ControleFracionado();
		$tbSal = new Application_Model_Saldo();
		$saida = array();

		foreach ($produtos as $pro_codigo => $quantidade) {
			$dosesSelecionadas = 0;
			$desse = 0;

			// pega todos os lotes fracionados
			$fracoes = $tbCont->getLotesFracionados($pro_codigo, $set_codigo);
			foreach ($fracoes as $fracao) {
				if ($quantidade == $dosesSelecionadas)
					break; // sai do foreach;

				if ($quantidade >= $dosesSelecionadas + $fracao->cont_dose) {
					$pegar = $fracao->cont_dose;
				} else {
					$pegar = $quantidade - $dosesSelecionadas;
				}

				$dosesSelecionadas += $pegar;	
				$desse += $pegar;

				if (!isset($saida[$pro_codigo]))
					$saida[$pro_codigo] = array(
						"pro_nome" => $fracao->pro_nome,
						"solicitado" => $quantidade,
						"cont" => array()
					);				
				
				$saida[$pro_codigo]['cont'][$fracao->cont_codigo] = array(
					"pro_lote" => $fracao->ite_lote,
					"pro_validade" => $fracao->ite_validade,
					"total" => $desse
				);
			}

			// há doses suficientes?			
			if ($quantidade > $dosesSelecionadas) {
				$naoFrac = $tbSal->getLotes($pro_codigo, $set_codigo);

				// para cada lote/validade
				foreach ($naoFrac as $lote) {
					$desse = 0;
					for ($x = 1; $x <= $lote->sal_qtde; $x++) {
						if ($quantidade == $dosesSelecionadas)
							break;

						if ($quantidade >= $dosesSelecionadas + $lote->sal_dose_lote) {
							$pegar = $lote->sal_dose_lote;
						} else {
							$pegar = $quantidade - $dosesSelecionadas;
						}
						$dosesSelecionadas += $pegar;
						$desse += $pegar;

						if (!isset($saida[$pro_codigo]))
							$saida[$pro_codigo] = array(
								"pro_nome" => $lote->pro_nome,
								"solicitado" => $quantidade
							);			

						$saida[$pro_codigo]['saldo'][$lote->sal_codigo] = array(
							"pro_lote" => $lote->sal_lote,
							"pro_validade" => $lote->sal_validade,
							"total" => $desse
						);
					}
				}
			}

			// há doses suficientes?
			if ($quantidade > $dosesSelecionadas) {
				if($dosesSelecionadas == 0){
					$saida[$pro_codigo]['pro_nome'] = $this->fetchRow("pro_codigo=$pro_codigo")->pro_nome;
				}
				$saida[$pro_codigo]['solicitado'] = $quantidade;
				$saida[$pro_codigo]['faltou'] = $quantidade - $dosesSelecionadas;
			}
		}

		return $saida;
	}

	/**
	 * Seleciona qual o melhor lote/validade do produto em estoque (saldo)
	 * Obs.: não olha os produtos já fracionados
	 * @param array $pro_codigo 
	 */
	public function selecionaMelhorLoteNaoFracionado($pro_codigo, $set_codigo) {
		$pro_codigo = (array) $pro_codigo;

		$subSelect3 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal_3" => "saldo"), "MIN(sal_validade)")
				->where("sal_3.pro_codigo=sal_2.pro_codigo")
				->where("sal_3.set_codigo=sal_2.set_codigo")
				->where("sal_3.sal_qtde > 0")
				->where("sal_3.sal_validade >= CURRENT_DATE");


		$subSelect2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal_2" => "saldo"), "MIN(sal_2.sal_qtde)")
				->where("sal_2.pro_codigo=sal_1.pro_codigo")
				->where("sal_2.set_codigo=sal_1.set_codigo")
				->where("sal_2.sal_qtde > 0")
				->where("sal_2.sal_validade >= CURRENT_DATE")
				->where("sal_2.sal_validade = ?", $subSelect3);

		$subSelect1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal_1" => "saldo"), "MIN(sal_1.sal_codigo)")
				->where("sal_1.pro_codigo=sal.pro_codigo")
				->where("sal_1.set_codigo=sal.set_codigo")
				->where("sal_1.sal_qtde > 0")
				->where("sal_1.sal_validade >= CURRENT_DATE")
				->where("sal_1.sal_qtde = ?", $subSelect2);

		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("sal" => "saldo"), array("(pro_codigo)","sal_codigo", "sal_qtde", "sal_lote", "sal_validade", "sal_dose_lote"))
				->where("sal.set_codigo=?", $set_codigo)
				->where("sal.sal_qtde > 0")
				->where("sal.sal_validade >= CURRENT_DATE")
				->where("pro_codigo in (?)", $pro_codigo)
				->where("sal.sal_codigo = ?", $subSelect1)
				->group(array("pro_codigo", "sal_codigo", "sal_qtde", "sal_lote", "sal_validade", "sal_dose_lote"))
				->order(array("sal_validade", "sal_qtde"));

		return $this->fetchAll($where);
	}

	/**
	 * Soma os totais do produto no setor, que ainda não venceu
	 * @param int/array $pro_codigo
	 * @param int $set_codigo 
	 */
	public function totalValido($pro_codigo, $set_codigo) {
		$pro_codigo = (array) $pro_codigo;

		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal" => "saldo"), array("pro_codigo", "sal_qtde" => "sum(sal_qtde)"))
				->where("pro_codigo in (?)", $pro_codigo)
				->where("set_codigo=?", $set_codigo)
				->where("sal_qtde > 0")
				->where("sal_validade > CURRENT_DATE")
				->group("pro_codigo");

		return $this->fetchAll($where);
	}

	/**
	 * Busca qual o melhor lote (já fracionado) de cada produto do array
	 * @param array $pro_codigo
	 * @param int $set_codigo
	 * @return Zend_Db_Table_Rowset_Abstract 
	 */
	public function selecionaMelhorLoteFracionado($pro_codigo, $set_codigo) {
		$pro_codigo = (array) $pro_codigo;

		$subSelect3 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("cont_4" => "controlefracionado"), "")
				->join(array("ite_4" => "itens_movimento"), "ite_4.ite_codigo=cont_4.ite_codigo", "MIN(ite_4.ite_validade)")
				->where("cont_4.cont_dose > 0")
				->where("cont_4.set_codigo=cont_3.set_codigo")
				->where("ite_4.pro_codigo=ite_3.pro_codigo");

		$subSelect2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("cont_3" => "controlefracionado"), "MIN(cont_dose)")
				->join(array("ite_3" => "itens_movimento"), "ite_3.ite_codigo=cont_3.ite_codigo", "")
				->where("cont_3.cont_dose > 0")
				->where("cont_3.set_codigo=cont_2.set_codigo")
				->where("ite_3.pro_codigo=ite_2.pro_codigo")
				->where("ite_3.ite_validade in (?)", $subSelect3);

		$subSelect1 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("cont_2" => "controlefracionado"), "MIN(cont_codigo)")
				->join(array("ite_2" => "itens_movimento"), "ite_2.ite_codigo=cont_2.ite_codigo", "")
				->where("cont_2.cont_dose > 0")
				->where("cont_2.set_codigo=cont.set_codigo")
				->where("ite_2.pro_codigo=ite.pro_codigo")
				->where("cont_2.cont_dose in (?)", $subSelect2);


		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("cont" => "controlefracionado"), array("cont_codigo", "cont_dose", "ite_codigo"))
				->join(array("ite" => "itens_movimento"), "ite.ite_codigo=cont.ite_codigo", array("pro_codigo", "ite_lote", "ite_validade"))
				->where("cont_dose > 0")
				->where("set_codigo = ?", $set_codigo)
				->where("pro_codigo in (?)", $pro_codigo)
				->where("cont_codigo in (?)", $subSelect1);

		return $this->fetchAll($where);
	}

	public function selecionaMelhoresVacinas() {
		$tbUsr = new Application_Model_Usuarios();
		$set_codigo = $tbUsr->getUsrAtual()->set_codigo;

		$tbCar = new Application_Model_Carteirinha();
		$pro_codigo = $tbCar->getProdutosDaCarteirinha();

		return array(
			"fechado" => $this->totalValido($pro_codigo, $set_codigo)->toArray(),
			"aberto" => $this->selecionaMelhorLoteFracionado($pro_codigo, $set_codigo)->toArray()
		);
	}

	/**
	 * Faz um movimento de saida (baixando o saldo) e adiciona na tabela controlefracionado
	 * @param int $set_codigo
	 * @param int $sal_codigo
	 * @param int $quantidade
	 * @param int $fracoes se informado, $quantidade será a quantidade necessária para ter $fracaoes frações
	 * @return int cont_codigo 
	 */
	public function fracionarFromSaldo($set_codigo,$sal_codigo,$quantidade=1, $fracoes=FALSE){
		$tbMov = new Application_Model_Movimento();
		$tbIte = new Application_Model_MovimentoItens();
		$tbCont = new Application_Model_ControleFracionado();
		$tbSaldo = new Application_Model_Saldo();

		Zend_Registry::get("logger")->log("iniciar Trasaction", Zend_Log::INFO);
		$this->getAdapter()->beginTransaction();

		try {
			$saldo = $tbSaldo->fetchRow("sal_codigo=$sal_codigo");
			if($fracoes)
				$quantidade = ceil($fracoes/(int)$saldo->sal_dose_lote);
			
			Zend_Registry::get("logger")->log("selecionado melhor lote", Zend_Log::INFO);
				
			// Faz o movimento
			$dadosMovimento = array(
				"mov_tipo" => Application_Model_Movimento::SAIDA,
				"mov_saida" => Application_Model_Movimento::DISPENSACAO,
				"set_saida" => $set_codigo
			);
			$mov_codigo = $tbMov->salvar($dadosMovimento);
			Zend_Registry::get("logger")->log("adicionado movimento: $mov_codigo", Zend_Log::INFO);

			// Faz o item do movimento
			$dadosItensMovimento = array(
				"mov_codigo" => $mov_codigo,
				"pro_codigo" => $saldo->pro_codigo,
				"ite_lote" => $saldo->sal_lote,
				"ite_validade" => $saldo->sal_validade,
				"ite_dose" => (int) $saldo->sal_dose_lote,
				"ite_quantidade" => $quantidade // só pode fracionar um por vez
			);
			Zend_Registry::get("logger")->log($dadosItensMovimento, Zend_Log::INFO);
			$ite_codigo = $tbIte->salvar($dadosItensMovimento);
			Zend_Registry::get("logger")->log("adicionado itens_movimento: $ite_codigo", Zend_Log::INFO);

			// salva no controlefracionado
			$dadosControleFracionado = array(
				"cont_dose" => ($saldo->sal_dose_lote*$quantidade),
				"set_codigo" => $set_codigo,
				"ite_codigo" => $ite_codigo
			);
			
			$cont_codigo = $tbCont->salvar($dadosControleFracionado);
			
			Zend_Registry::get("logger")->log("adicionado controlefracionado", Zend_Log::INFO);
			$this->getAdapter()->commit();

			return $cont_codigo;
		} catch (Exception $e) {
			Zend_Registry::get("logger")->log("Exception: " . $e->getMessage(), Zend_Log::WARN);
			Zend_Registry::get("logger")->log($e->getTrace(), Zend_Log::INFO);
			echo "set: $set_codigo, sal: $sal_codigo, qtde: $quantidade, fracao: $fracoes\n";
			echo "exc: ".$e->getMessage();
			echo "\n: ".$e->getTraceAsString();
			$this->getAdapter()->rollBack();
		}
	}
	
	/**
	 * Fraciona um produto.
	 * @example vacinas => doses
	 * @example Febre Amarela (1 frasco) => 25x doses de F.A.
	 * @param int $pro_codigo
	 * @param int $set_codigo (Opcional)
	 */
	public function fracionar($pro_codigo, $set_codigo=FALSE, $sal_codigo=FALSE) {
		Zend_Registry::get("logger")->log("Fracionar: $pro_codigo", Zend_Log::INFO);
			
		if (!$set_codigo) {
			$tbUsr = new Application_Model_Usuarios();
			$set_codigo = $tbUsr->getUsrAtual()->set_codigo;
		}

		// verifica se já existe fracionado
		$fracionado = $this->selecionaMelhorLoteFracionado($pro_codigo, $set_codigo);
		if ($fracionado->count()) {
			Zend_Registry::get("logger")->log($fracionado->toArray(), Zend_Log::INFO);
			
			return false;
		}
		
		$saldo = $this->selecionaMelhorLoteNaoFracionado($pro_codigo, $set_codigo);
		return $this->fracionarFromSaldo($set_codigo, $saldo[0]['sal_codigo']);		
	}

	public function fracionarVarios($produtos,$set_codigo=FALSE){
		
		if (!$set_codigo) {
			$tbUsr = new Application_Model_Usuarios();
			$set_codigo = $tbUsr->getUsrAtual()->set_codigo;
		}
		
		$cont = array();
		foreach($produtos as $sal_codigo => $quantidade){
			$cont_codigo = $this->fracionarFromSaldo($set_codigo, $sal_codigo, false, $quantidade);
			
			echo "cont_codigo: $cont_codigo\n";
			$cont [$cont_codigo]= $quantidade;
		}
		
		return $cont;
	}
	
	/**
	 * Descarta um produto da tabela controlefracionado
	 * @param int $pro_codigo
	 * @param int $set_codigo 
	 */
	public function descartar($pro_codigo, $motivo=self::OUTROS_MOTIVOS, $set_codigo=FALSE) {
		if (!$set_codigo) {
			$tbUsr = new Application_Model_Usuarios();
			$set_codigo = $tbUsr->getUsrAtual()->set_codigo;
		}

		// verifica se existe fracionado
		$fracionado = $this->selecionaMelhorLoteFracionado($pro_codigo, $set_codigo);
		if (!$fracionado->count()) { // se não houver
			Zend_Registry::get("logger")->log("Produto $pro_codigo não possui frações/doses abertas", Zend_Log::INFO);
			return false;
		}

		$fracionado = $fracionado->current();
		$dados = array(
			"cont_codigo" => $fracionado->cont_codigo,
			"cont_dose" => 0,
			"cont_perda" => $fracionado->cont_dose,
			"cont_perda_motivo" => $motivo,
			"set_codigo" => $set_codigo,
			"ite_codigo" => $fracionado->ite_codigo
		);
		Zend_Registry::get("logger")->log($dados, Zend_Log::INFO);
		$tbCont = new Application_Model_ControleFracionado();
		$tbCont->salvar($dados);
	}

	/* RELATORIOS */

	public function relMedicamentosPorValidade(&$dados, $set_codigo, $data_inicial=FALSE, $data_final=FALSE) {
		$dados->title = "Produtos a vencer";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("pro_nome" => "Medicamento", "sal_lote" => "Lote", "sal_validade" => "Validade", "sal_qtde" => "Quant."),
			"formato" => array("sal_validade" => "data", "sal_qtde" => "num")
		);

		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal" => "saldo"), array("sal_lote", "sal_validade", "sal_qtde"))
				->join(array("pro" => "produto"), "pro.pro_codigo=sal.pro_codigo", "pro_nome")
				->where("sal.sal_qtde > 0")
				->where("sal.set_codigo=?", $set_codigo)
				->order("pro_nome");

		if ($data_inicial)
			$where->where("sal.sal_validade >= ?", $data_inicial);

		if ($data_final)
			$where->where("sal.sal_validade <= ?", $data_final);

		return $where;
	}
	public function relEntradaPsicotropicos(&$dados, $set_codigo, $data_inicial=FALSE, $data_final=FALSE) {
           // die("CHEGO");
		$dados->title = "Entrada Psicotrópicos";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("pro_nome" => "Medicamento", "for_nome" => "Fornecedor", "for_cnpj" => "CNPJ", "ite_quantidade" => "Quant. Adquirida"),
			"formato" => array("ite_quantidade" => "num")
		);

		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("pro" => "produto"), array("pro_nome"))
				->join(array("ite" => "itens_movimento"), "ite.pro_codigo=pro.pro_codigo", "SUM(ite_quantidade) AS ite_quantidade" )
				->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo","")
				->join(array("f"=>"fornecedor"),"f.for_codigo=mov.for_codigo",array("for_nome","for_cnpj"))
				->join(array("set"=>"setor"),"set.set_codigo=mov.set_entrada")
				->where("pro.psico_codigo is not null")
				->where("mov.mov_tipo = 'E'")
				->where("set.set_codigo=?",$set_codigo)
				->group(array("for_nome","pro_nome","for_cnpj","set.set_codigo"))
				->order("pro_nome");

		if ($data_inicial)
			$where->where("mov.mov_data>= ?", $data_inicial);

		if ($data_final)
			$where->where("mov.mov_data <= ?", $data_final);

		return $where;
	}
	public function relBalanco(&$dados, $set_codigo, $data_inicial=FALSE, $data_final=FALSE,$psi) {
		$dados->title = "Balanço Psicotrópicos";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("pro_nome" => "Medicamento", "entrada" => "Entrada", "saida" => "Saida", "saldo" => "Estoque","perda" => "Perdas"),
			"formato" => array("entrada" => "num","saida" => "num","saldo" => "num","perda" => "num")
		);
		if ($data_inicial){
			$datai = " AND mov_data >= '$data_inicial'";
			$dataiValidade = " AND sal_validade >= '$data_inicial'";
		}
		if ($data_final){
			$dataf = " AND mov_data <= '$data_final'";
			$datafValidade = " AND sal_validade <= '$data_final'";
		}else{
			$datafValidade = " AND sal_validade <= 'NOW()'";
		}
		if($psi=="s"){
			$psicotropicos = " AND psico_codigo is not null";
		}
                if($psi=="s"){
			$usuario = " AND u2.usu_codigo is not null";
		}
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("pro" => "produto"), array("pro_nome","(SELECT SUM(ite_quantidade)
																	  FROM produto p2
																	  JOIN itens_movimento i2
																		ON i2.pro_codigo = p2.pro_codigo
																	  JOIN movimento m2
																		ON m2.mov_codigo = i2.mov_codigo
																	 WHERE
																		1=1
																	   $psicotropicos
																	   $datai
																	   $dataf
																	   AND (mov_tipo = 'E' or mov_tipo = 'T') 
																	   AND set_entrada = $set_codigo
																	   AND pro.pro_codigo = p2.pro_codigo) as entrada",
																	"(SELECT SUM(ite_quantidade) 
                                                                                                                                            FROM movimento m2
                                                                                                                                            JOIN itens_movimento i2 
                                                                                                                                              ON m2.mov_codigo =i2.mov_codigo
                                                                                                                                            JOIN usuario u2
                                                                                                                                              ON u2.usu_codigo = m2.usu_codigo
                                                                                                                                            JOIN produto p2
                                                                                                                                              ON p2.pro_codigo = i2.pro_codigo 
																	   WHERE 
																		 1=1
                                                                                                                                            $psicotropicos
                                                                                                                                            $usuario
																	     $datai
																	     $dataf
																	     AND (mov_tipo = 'S')
																		 AND set_saida = $set_codigo
																	     AND pro.pro_codigo = p2.pro_codigo) as saida",
																	"(SELECT sum(sal_qtde) 
																		FROM saldo 
																	   WHERE pro_codigo = pro.pro_codigo 
																	     AND set_codigo = $set_codigo
																		 AND sal_validade > 'NOW()') as saldo",
																	"(SELECT sum(sal_qtde) 
																		FROM saldo 
																	   WHERE pro_codigo = pro.pro_codigo 
																	     AND set_codigo = $set_codigo
																		 $dataiValidade
																	     $datafValidade) as perda"))
				->joinLeft(array("ite" => "itens_movimento"), "ite.pro_codigo=pro.pro_codigo", "" )
				->joinLeft(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo","")
				->joinLeft(array("f"=>"fornecedor"),"f.for_codigo=mov.for_codigo","")
				->joinLeft(array("set"=>"setor"),"set.set_codigo=mov.set_entrada","")
			
				->where("mov.set_entrada= $set_codigo OR mov.set_saida = $set_codigo")				
				//->orWhere("mov.set_saida=?",$set_codigo)
				->group(array("for_nome","pro_nome","for_cnpj","set.set_codigo","pro.pro_codigo","mov_data"))
				->order("pro_nome");

		if($psi=="s"){
			$where->where("pro.psico_codigo is not null");
		}
		if ($data_inicial)
			$where->where("mov.mov_data>= ?", $data_inicial);
		
		if ($data_final)
			$where->where("mov.mov_data <= ?", $data_final);
            //  echo "<pre>".print_r($where,1); exit;
//	die($where->__toString());
		return $where;
		
	}

	public function relEstoquePsicotropico(&$dados, $set_codigo) {
		$dados->title = "Estoque de Psicotrópicos";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("pro_nome" => "Medicamento", "sal_lote" => "Lote", "sal_validade" => "Validade", "sal_qtde" => "Quant.", "psico_nome" => "Portaria"),
			"formato" => array("sal_validade" => "data", "sal_qtde" => "num")
		);
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal" => "saldo"), array("sal_lote", "sal_validade", "sal_qtde"))
				->join(array("pro" => "produto"), "pro.pro_codigo=sal.pro_codigo", "pro_nome")
				->join(array("psico" => "psicotropicos"), "psico.psico_codigo=pro.psico_codigo", "psico_nome")
				->where("sal.sal_qtde > 0")
				->where("sal.set_codigo=?", $set_codigo)
				->order("pro_nome");

		return $where;
	}
	public function relTransferencias(&$dados, $set_codigo, $data_inicial=FALSE, $data_final=FALSE) {
		$dados->title = "Tranferências por forncedores";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("set_nome" => "Setor de Destino","mov_data" => "Data","pro_nome" => "Produto", "ite_quantidade" => "Quantidade"),
			"formato" => array("ite_quantidade" => "num","mov_data" => "data")
		);

		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("mov" => "movimento"),"mov_data")				
				->join(array("ite" => "itens_movimento"), "ite.mov_codigo=mov.mov_codigo", "ite_quantidade" )
				->join(array("pro" => "produto"),"ite.pro_codigo=pro.pro_codigo", array("pro_nome"))				
				->join(array("set"=>"setor"),"set.set_codigo=mov.set_entrada","set_nome")
				->where("mov.mov_tipo = 'T'")
				->where("mov.set_saida=?",$set_codigo)
				->order(array("set_nome","mov_data","pro_nome"));

		if ($data_inicial)
			$where->where("mov.mov_data>= ?", $data_inicial);

		if ($data_final)
			$where->where("mov.mov_data <= ?", $data_final);
		//die($where);
		return $where;
	}
		public function relAnvisa(&$dados, $set_codigo, $data_inicial=FALSE, $data_final=FALSE,$pro_codigo=FALSE) {                
		$dados->title = "Relatório Anvisa";
		$dados->params = serialize($_POST);
                
                if ($data_inicial)
			$whereIni = " AND m2.mov_data >= '$data_inicial'";
		
		if ($data_final)
			$whereFim = " AND m2.mov_data <= '$data_final'";
		
		if ($set_codigo){
			$whereSet = " AND m2.set_saida = $set_codigo";
                }
                if($pro_codigo){
                    $wherePro = " AND p2.pro_codigo = $pro_codigo";
                }else{
                     $wherePro = " group by p2.pro_nome,m2.mov_data ORDER BY m2.mov_data,pro_nome";
                }
                
		$dados->config = array(
			"th" => array("mov_data" => "Data","usu_nome" => "Nome","pro_nome" => "Produto", "ite_quantidade" => "Quantidade","set_nome" => "Setor","usr_nome"=>"Médico","total"=>"Total"),
			"formato" => array("ite_quantidade" => "num","mov_data" => "data","total" => "num")
		);
$where = "SELECT  u.usu_nome,
				  p.pro_nome,
				  ite_quantidade,
				  m.mov_data,
				  set_nome,
				  CASE 
				   when 
					usr_nome is not null 
				   then
					usr_nome
				   when 
					med_nome is not null 
				   then
					med_nome
				   else 
					'Médico Desconhecido'        
				  END usr_nome ,
                                  (SELECT SUM(ite_quantidade) 
                                     FROM movimento m2
                                     JOIN itens_movimento i2 
                                       ON m2.mov_codigo =i2.mov_codigo
                                     JOIN usuario u2
                                       ON u2.usu_codigo = m2.usu_codigo
                                     JOIN produto p2
                                       ON p2.pro_codigo = i2.pro_codigo    
                                    WHERE mov_tipo = 'S' and 
                                            u2.usu_codigo is not null
                                            and p2.psico_codigo is not null
                                            $whereIni $whereFim $whereSet $wherePro) as total
		  from movimento m
		  join itens_movimento i
		   on i.mov_codigo = m.mov_codigo
		  join setor s
			on s.set_codigo = m.set_saida
		  join usuario u
			on u.usu_codigo = m.usu_codigo
		  join produto p
			on p.pro_codigo = i.pro_codigo
		  left join usuarios us
			on us.usr_codigo = m.med_codigo_interno
		  left join medico me
			on me.med_codigo = m.med_codigo_externo
			where mov_tipo = 'S' and 
		u.usu_codigo is not null
		and p.psico_codigo is not null";
		if ($data_inicial)
			$where .= " AND m.mov_data >= '$data_inicial'";
		
		if ($data_final)
			$where .= " AND m.mov_data <= '$data_final'";
		
		if ($set_codigo){
			$where .= " AND m.set_saida = $set_codigo";
                }
		if($pro_codigo){
                    $where .= " AND p.pro_codigo = $pro_codigo ORDER BY m.mov_data,pro_nome";
                }else{
                     $where .= " ORDER BY m.mov_data ,pro_nome";
                }
         //echo "<pre>".print_r($where,1); exit;
		return $where;
	}
	/**
	 * Atualiza todas as tabelas do sistema que estão vinculadas a um paciente duplicado para um único paciente
	 * depois remove-os.
	 * @param int $correto
	 * @param array $duplicados 
	 * @return array quantos registros foram atualizados e quantos foram removidos por tabela
	 */
	public function removerDuplicacoes($correto, $duplicados){
		Zend_Registry::get("logger")->log(array($correto,$duplicados), Zend_Log::INFO);
		
		$out = array();
		$tbCar = new Application_Model_Carteirinha();
		$tbCot = new Application_Model_CotaSetor();
		$tbEve = new Application_Model_EventoProduto();
		$tbInv = new Application_Model_InventarioProduto();
		$tbIte = new Application_Model_MovimentoItens();
		$tbiReq = new Application_Model_ItensRequisicao();
		$tbLei = new Application_Model_LeitoGradeItens();
		$tbSet = new Application_Model_ProdutoSetor();
		$tbPro = new Application_Model_ProgramaProduto();
		$tbReq = new Application_Model_RequisicaoCompraProduto();
		$tbSal = new Application_Model_Saldo();
		$tbVac = new Application_Model_VacinaUsuario();
	

		
		
		$this->getAdapter()->beginTransaction();
		
		try{
			$out['car'] = $tbCar->atualizarPro($duplicados, $correto);
			$out['cot'] = $tbCot->atualizarPro($duplicados, $correto);
			$out['eve'] = $tbEve->atualizarPro($duplicados, $correto);
			$out['inv'] = $tbInv->atualizarPro($duplicados, $correto);
			$out['ite'] = $tbIte->atualizarPro($duplicados, $correto);
			$out['ireq'] = $tbiReq->atualizarPro($duplicados, $correto);
			$out['lei'] = $tbLei->atualizarPro($duplicados, $correto);
			$out['set'] = $tbSet->atualizarPro($duplicados, $correto);
			$out['pro'] = $tbPro->atualizarPro($duplicados, $correto);
			$out['req'] = $tbReq->atualizarPro($duplicados, $correto);
			$out['sal'] = $tbSal->atualizarPro($duplicados, $correto);
			$out['vac'] = $tbVac->atualizarPro($duplicados, $correto);
				
			$this->getAdapter()->commit();
			
		} catch (Exception $e){
			$this->getAdapter()->rollBack();
			Zend_Registry::get("logger")->log($e->getMessage(), Zend_Log::INFO);
			return false;
		}
		
		$removidos = $this->remover($duplicados);			
		
		return array(array_sum($out),$removidos);
	}
	
	/**
	 * Recebe um array de usu_codigo e remove todos
	 * @param array $usu_codigo
	 * @return int Número de linhas removidas
	 */
	public function remover($pro_codigo){
		$where = $this->select()->where("pro_codigo IN (?)", $pro_codigo)->getPart(Zend_Db_Table_Select::WHERE);
		$where = $where[0];
		
		//die($where);
		return $this->delete($where);
	}
}