<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Rua extends Elotech_Db_Table_Abstract {
        
        protected $_name = 'rua';
	protected $_primary = 'rua_codigo';
        protected $_sequence = 'seq_rua_codigo';

	/* ------------------------------------------------------
        * MÉTODOS AÇÃO SOCIAL
        * ------------------------------------------------------*/
        
        public function buscaDadosEndereco($term){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("rua"=>"rua"),array("rua_codigo","rua_nome","rua_cep"))
                        ->joinLeft(array("cid"=>"cidade"),"rua.cid_codigo=cid.cid_codigo",array("cid_codigo","cid_nome"))
                        ->joinLeft(array("est"=>"estado"),"cid.uf_codigo=est.uf_codigo",array("uf_codigo","uf_nome"))
                        ->where("rua_nome ILIKE '%$term%'")
                        ->order("rua_nome ASC");
            return $this->fetchAll($sql);
        }
        
        public function buscaRuaDuplicada($rua=FALSE){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("rua"=>"rua"),array("COUNT(rua_codigo) AS qtd_rua"))
                        ->join(array("cid"=>"cidade"),"rua.cid_codigo=cid.cid_codigo",array(""))
                        ->join(array("est"=>"estado"),"cid.uf_codigo=est.uf_codigo",array(""))
                        ->where("rua_nome =?",$rua);
            return $this->fetchRow($sql);
        }
        
        public function getQtdCodRuaDuplicada($dadosRua=FALSE){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from("rua",array("rua_codigo"))
                        ->where("cid_codigo =?",$dadosRua["cid_codigo"])
                        ->where("rua_nome =?",$dadosRua["rua_nome"]);
            return $this->fetchRow($sql);
        }
        
        public function salvarRua($data){
            try{
               return parent::salvar($data);
            } catch (Exception $exc) {
                throw new Zend_Validate_Exception("Falha ao realizar o cadastro de rua: ".$exc->getMessage());
            }
        }
        
        /* ------------------------------------------------------
        * FIM MÉTODOS AÇÃO SOCIAL
        * ------------------------------------------------------*/
        
        
        public function salvar(array $data) {
            return false; // não pode salvar especialidades;
	}

	/**
	 * Buscar as ruas
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE) {
		if ($term)
			$where = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from("rua", array("rua_codigo", "rua_nome"))
					->where("retira_acentos(rua_nome) ilike retira_acentos('%$term%')", "S")
					->order(array("rua_nome"))
					->limit(0);

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $item) {
			$data = $item->toArray();

			$out [] = array(
				"id" => $item->rua_codigo,
				"label" => $item->rua_nome,
				"data" => $data
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("rua_codigo" => "0", "rua_nome" => "")
			);
		}
                
		return $out;
	}
	
	/**
	 * Atualiza todos os domícilios que estão em uma rua duplicada para uma única rua,
	 * depois remove-as.
	 * @param int $correto
	 * @param array $duplicados 
	 * @return array quantos registros foram atualizados e quantos foram removidos
	 */
	public function removerDuplicacoes($correto, $duplicados){
		$tbDom = new Application_Model_Domicilio();
		$atualizados = $tbDom->atualizarRua($duplicados, $correto);
		$removidos = $this->remover($duplicados);			
		
		return array($atualizados,$removidos);
	}
	
	/**
	 * Recebe um array de rua_codigo e remove todos
	 * @param array $rua_codigo
	 * @return int Número de linhas removidas
	 */
	public function remover($rua_codigo){
		$where = $this->select()->where("rua_codigo IN (?)", $rua_codigo)->getPart(Zend_Db_Table_Select::WHERE);
		$where = $where[0];
		return $this->delete($where);
	}
        
        public function getDadosCidadeEstado($codIbge){
            $sql = $this->select(FALSE)
                        ->setIntegrityCheck(FALSE)
                        ->from(array("cid"=>"cidade"),array("cid_codigo","uf_sigla"))
                        ->where("cid_codigo_ibge = '$codIbge'");
            return $this->fetchRow($sql);
        }
        
        public function buscarRua($codCid,$term){
            if ($term)
                    $where = $this->select(FALSE)
                                    ->setIntegrityCheck(FALSE)
                                    ->from("rua", array("rua_codigo", "rua_nome","rua_cep","rua_bairro"))
                                    ->where("retira_acentos(rua_nome) ilike retira_acentos('%$term%')", "S")
                                    ->where("cid_codigo =?",$codCid)
                                    ->order(array("rua_nome"))
                                    ->limit(0);
            $all = $this->fetchAll($where);
            
            $out = array();
            foreach ($all as $item) {
                    $out [] = array(
                            "id" => $item->rua_codigo,
                            "label" => trim($item->rua_nome), 
                            "data" => array("rua_codigo" => $item->rua_codigo, "rua_cep_hidden" => $item->rua_cep, "rua_cep" => $item->rua_cep, "rua_bairro" => $item->rua_bairro, "rua_nome" => $item->rua_nome)
                    );
            }

            if (!count($out)) {
                    $out [] = array(
                            "id" => 0,
                            "label" => "Nenhum item encontrado",
                            "data" => array("rua_codigo" => "", "rua_cep_hidden" => "", "rua_cep" => "", "rua_bairro" => "", "rua_nome" => "")
                    );
            }
            return $out;
        }
        
        public function buscarCep($codCid,$term){
            if ($term)
                    $where = $this->select(FALSE)
                                    ->setIntegrityCheck(FALSE)
                                    ->from("rua", array("rua_codigo", "rua_nome","rua_cep","rua_bairro"))
                                    ->where("rua_cep ILIKE ('%$term%')")
                                    ->where("cid_codigo =?",$codCid)
                                    ->order(array("rua_nome"))
                                    ->limit(0);
            $all = $this->fetchAll($where);
            
            $out = array();
            foreach ($all as $item) {
                    $out [] = array(
                            "id" => $item->rua_codigo,
                            "label" => trim($item->rua_nome), 
                            "data" => array("rua_codigo" => $item->rua_codigo, "rua_cep_hidden" => $item->rua_cep, "rua_cep" => $item->rua_cep, "rua_bairro" => $item->rua_bairro, "rua_nome" => $item->rua_nome)
                    );
            }

            if (!count($out)) {
                    $out [] = array(
                            "id" => 0,
                            "label" => "Nenhum item encontrado",
                            "data" => array("rua_codigo" => "", "rua_cep_hidden" => "", "rua_cep" => "", "rua_bairro" => "", "rua_nome" => "")
                    );
            }
            return $out;
        }
        
}
