<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Saldo extends Elotech_Db_Table_Abstract {

	protected $_name = 'saldo';
	protected $_primary = 'sal_codigo';

	public function salvar(array $data) {
		throw new Zend_Validate_Exception("Esta tabela só pode ser manipulada via trigger", 1000);
	}

	/**
	 * Informa a quantidade do produto em estoque
	 * @param int $pro_codigo
	 * @param int $set_codigo
	 * @param string $lote
	 * @param string $validade
	 * @return int
	 */
	public function getSaldoAtual($pro_codigo, $set_codigo=FALSE, $lote="SEM_LOTE", $validade="2900-12-31") {
		if (!$set_codigo) {
			$tbUsr = new Application_Model_Usuarios;
			$set_codigo = $tbUsr->getUsrAtual()->set_codigo;
		}

		$where = $this->select(TRUE)
				->columns("sal_qtde")
				->where("pro_codigo=?", $pro_codigo)
				->where("set_codigo=?", $set_codigo)
				->where("sal_qtde > 0")
				->where("sal_lote=?", $lote)
				->where("sal_validade=?", $validade);

		return (int) $this->fetchRow($where)->sal_qtde;
	}

	public function getLotes($pro_codigo, $set_codigo, $somenteNaoVencidos=TRUE) {
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("sal"=>"saldo"),array("sal_codigo", "sal_qtde", "sal_dose_lote", "sal_lote","sal_validade"))
				->join(array("pro"=>"produto"),"pro.pro_codigo=sal.pro_codigo","pro_nome")
				->where("sal.set_codigo=?", $set_codigo)
				->where("sal.sal_qtde > 0")
				->where("sal.pro_codigo=?", $pro_codigo)
				->order(array("sal.sal_validade", "sal.sal_qtde"));

		if ($somenteNaoVencidos)
			$where->where("sal_validade >= CURRENT_DATE");

		return $this->fetchAll($where);
	}

}
