<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Setor extends Elotech_Db_Table_Abstract {

	protected $_name = "setor";
	protected $_primary = "set_codigo";
	protected $_sequence = "seq_uni_codigo";
	
	// Método que retorna os 15 últimos setores
	public function getSetor(){
		$where = $this->select(FALSE)
					->setIntegrityCheck()
					->from(array("set"=>"setor"),array("set_codigo","set_nome"))
					->order(array("set_codigo DESC"))
					->limit(15);
		return $this->fetchAll($where);
	}
	
	// Método que salva os dados em BD
	public function salvar(array $data) {
		$set_codigo = parent::salvar($data);
	}

	/**
	 * Buscar os setores
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE) {
		if ($term)
			$where = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("set" => "setor"), array("set_codigo", "set_nome"))
					->where("retira_acentos(set_nome) ilike retira_acentos('%$term%')", "S")
					->order(array("set_nome"))
					->limit(15);
			$all = $this->fetchAll($where);
			$setores = array();
		foreach ($all as $usu) {
			$setores [] = array(
				"id" => $usu->set_codigo,
				"label" => $usu->set_nome,
				"data" => $usu->toArray()
			);
		}

		if (!count($setores)) {
			$setores [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("set_codigo" => "0", "set_nome" => "")
			);
		}

		return $setores;
	}
	
}
