<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Unidade extends Elotech_Db_Table_Abstract {

    protected $_name = 'unidade';
    protected $_primary = 'uni_codigo';
    protected $_sequence = 'seq_uni_codigo';

    /* ------------------------------------------------------
     * MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------ */

    /**
    * Busca autocomplete de Unidade
    * @return json
    */
    public function buscaUnidade($term = FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc","uni_astipo","uni_asnumero"))
	                ->join(array("uniu" => "unidade_usuarios"), "uni.uni_codigo = uniu.uni_codigo", "")
	                ->join(array("usr" => "usuarios"), "usr.usr_codigo = uniu.usr_codigo", "")
                    ->where("retira_acentos(uni.uni_desc) ilike retira_acentos('%$term%')", "S")
                    ->where("uni.uni_as =?","t")
	                ->where("usr.usr_codigo = ? ", $_SESSION['login']['usr_codigo'])
                    ->order(array("uni.uni_desc"))
                    ->limit(8);
        return $this->fetchAll($sql);
    }

    public function verificaAcessoUnidade($uni_codigo){
	    $sql = $this->select(FALSE)
		    ->setIntegrityCheck(FALSE)
		    ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc","uni_astipo","uni_asnumero"))
		    ->join(array("uniu" => "unidade_usuarios"), "uni.uni_codigo = uniu.uni_codigo", "")
		    ->join(array("usr" => "usuarios"), "usr.usr_codigo = uniu.usr_codigo", "")
		    ->where("uni.uni_as =?","t")
		    ->where("usr.usr_codigo = ? ", $_SESSION['login']['usr_codigo'])
		    ->where("uni.uni_codigo=$uni_codigo")
		    ->order(array("uni.uni_desc"));
//	    die($sql);
	    return $this->fetchRow($sql);
    }
    
    /**
    * Valida se cadastro está com os campos obrigatórios preechidos
    * @return SQL
    */
    public function validaCadastro($uniCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni"=>"unidade"),array("uni_codigo"))
                    ->where("uni_codigo =?",$uniCodigo)
                    ->where("((uni_asnumero IS NULL OR uni_asnumero = '') OR "
                            ."(uni_astipo IS NULL OR uni_astipo = ''))");
        return $this->fetchAll($sql)->count();
    }
    
    /**
    * Valida se o nome da Unidade esta cadastrado
    * @return SQL
    */
    public function validaNomeUnidade($uniDesc, $uni_codigo = FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni"=>"unidade"),array("uni_codigo"))
                    ->where("uni_desc =?",$uniDesc)
                    ->where("uni_as =?","t");
        $unidade = $this->fetchRow($sql);

        if(!$uni_codigo){
            return $this->fetchAll($sql)->count();
        }else{
            if($unidade->uni_codigo == $uni_codigo){
                return 0;
            }else{
                return $this->fetchAll($sql)->count();
            }
        }

    }
    
    /**
    * Valida se o nome da Unidade esta cadastrado
    * @return SQL
    */
    public function validaNomeUnidadeGeral($uniDesc){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni"=>"unidade"),array("uni_codigo"))
                    ->where("uni_desc =?",$uniDesc)
                    ->where("uni_as =?","t");
        return $this->fetchRow($sql);
    }
    
    /**
    * Pega os dados da unidade pelo código
    * @return SQL
    */
    public function getUnidade($uni_codigo = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("uni" => "unidade"))
                ->where("uni_codigo=?",$uni_codigo);
        return $this->fetchRow($sql);
    }
    
    /**
    * Pega os dados da unidade e salva
    * @return SQL
    */
    public function salvar($data) {
        try{
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception
                ("Falha ao cadastrar unidade:".$ex->getMessage());
        }
    }
    
    public function listaUnidadesAs() {
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("uni" => "unidade"))
                      ->where("uni_as =?","t");
        return $this->fetchAll($where);
    }
    
    /**
     * Exclui os dados da unidade
     * @return SQL
     */
    public function excluir($uniCodigo = FALSE) {
        $item = $this->fetchRow("uni_codigo=$uniCodigo");
        if ($item)
            $item->delete();

        return true;
    }
    
    /* ------------------------------------------------------
     * FIM MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------ */
    
    /**
     * Buscar as unidade
     * usado para alimentar o plugin de busca (jquery)
     * @return json
     */
    public function buscar($term = FALSE) {

        if ($term)
            $where = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc"))
                    ->where("retira_acentos(uni_desc) ilike retira_acentos('%$term%')", "S")
                    ->where("uni_as = 't'")
                    ->order(array("uni_desc"))
                    ->limit(500);

        $all = $this->fetchAll($where);

        $out = array();
        foreach ($all as $uni) {
            $out [] = array(
                "id" => $uni->uni_codigo,
                "label" => $uni->uni_desc,
                "data" => $uni->toArray()
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("uni_codigo" => "0", "uni_desc" => "")
            );
        }

        return $out;
    }

    public function buscarCidadeDaUnidade($uni_codigo) {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("uni" => "unidade"))
                ->join(array("cid" => "cidade"), "uni.uni_codigo_ibge=cid.cid_codigo_ibge")
                ->where("uni_codigo = $uni_codigo");
        return $this->fetchAll($where);
    }

    public function selectTag($value = NULL, $first = NULL) {
        $where = $this->select()->order("uni_desc");
        return parent::selectTag($where, "uni_desc", NULL, $first, TRUE, NULL, NULL, NULL, $value);
    }

    /**
     * Retorna os laboratórios, unidades ou hospitais que tenham o $term no nome.
     * @param type $term
     * @return stdClass
     * @author Anderson Bernini
     */
    public function buscarLocais($term) {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc", "prestador_servico" => "('U')", "categoria" => "('Unidade')", "uni_cnes")) // prestador_servico: U
                ->where("uni_desc ilike '%$term%'")
                ->order(array("uni_desc"));

        $all = $this->fetchAll($where);

        $out = array();
        foreach ($all as $med) {
            $out [] = array(
                "id" => $med->uni_codigo,
                "label" => $med->uni_desc,
                "data" => $med->toArray()
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("categoria" => "Nenhum item encontrado")
            );
        }

        return $out;
    }

    public function getCodUnidade() {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("uni" => "unidade"), array("uni_codigo"));
        return $this->fetchAll($where);
    }

    public function pesquisa($term) {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("uni" => "unidade"))
            ->where("uni_as =?","t")
            ->where("retira_acentos(uni_desc) ilike retira_acentos('%$term%')", "S")
            ->order("uni_codigo ASC");
        return $this->fetchAll($where);
    }

    public function buscaUnidadeRma($term = FALSE, $tipo = FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc","uni_astipo","uni_asnumero"))
            ->join(array("uniu" => "unidade_usuarios"), "uni.uni_codigo = uniu.uni_codigo", "")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo = uniu.usr_codigo", "")
            ->where("retira_acentos(uni.uni_desc) ilike retira_acentos('%$term%')", "S")
            ->where("uni.uni_as =?","t")
            ->where("usr.usr_codigo = ? ", $_SESSION['login']['usr_codigo'])
            ->where("uni.uni_astipo = ?",$tipo)
            ->order(array("uni.uni_desc"))
            ->limit(8);
        return $this->fetchAll($sql);
    }

}
