<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Usuario extends Elotech_Db_Table_Abstract
{

    protected $_name = 'usuario';
    protected $_primary = 'usu_codigo';
    protected $_sequence = 'seq_usu_codigo';


    /* ------------------------------------------------------
     * MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------*/

    public function buscaCidadaosGeral($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_bloqueado", "usu_nis", "usu_cpf"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_num_prontuario"))
            ->where("usu_nome ilike '%$term%' OR usu_cpf ilike '$term%' OR to_char(usu_datanasc, 'DD/MM/YYYY') ilike '$term%'")
            ->where("usu_as_situacao =?", "t")
            ->where("usu.usu_codigo != 9999999")
            ->order("usu_nome ASC");
        return $this->fetchAll($sql);
    }

    public function buscaCidadaoPorMae($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_bloqueado", "usu_nis", "usu_cpf"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_num_prontuario"))
            ->where("usu_mae ilike '%$term%'")
            ->where("usu_as_situacao =?", "t")
            ->where("usu.usu_codigo != 9999999")
            ->order("usu_nome ASC");
        return $this->fetchAll($sql);
    }

    public function buscaCidadaoPorNis($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_bloqueado", "usu_nis", "usu_cpf"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_num_prontuario"))
            ->where("usu_nis ilike '%$term%'")
            ->where("usu_as_situacao =?", "t")
            ->where("usu.usu_codigo != 9999999")
            ->order("usu_nis ASC");
        return $this->fetchAll($sql);
    }

    public function buscaCidadaos($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_cpf", "usu_bloqueado", "usu_nis"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array("aspsu_codigo", "aspsu_parentesco"))
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_codigo", "asps_num_prontuario"))
            ->joinLeft(array("aspsuni" => "as_prontuario_suas_unidade"), "asps.asps_codigo=aspsuni.asps_codigo", array())
            ->joinLeft(array("uni" => "unidade"), "aspsuni.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
            ->where("usu_nome ilike '%$term%' OR usu_cpf ilike '%$term%'")
            ->where("(usu_asps_ativo = 'f' OR usu_asps_ativo IS NULL)")
            ->where("usu.usu_codigo != 9999999")
            ->limit(8);
        return $this->fetchAll($sql);
    }

    public function buscaDadosCidadaoRef($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_cpf", "usu_bloqueado"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array("aspsu_codigo", "aspsu_parentesco", "aspsu_num_ordem"))
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_codigo", "asps_num_prontuario"))
            ->joinLeft(array("aspsuni" => "as_prontuario_suas_unidade"), "asps.asps_codigo=aspsuni.asps_codigo  ", array())
            ->joinLeft(array("uni" => "unidade"), "aspsuni.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
            ->where("aspsuni_dtfinal is null");
        if (is_numeric($term))
            $sql->where("(asps.asps_num_prontuario = " . str_replace(",", "", $term) . ") OR (usu_cpf ILIKE '%$term%') OR (usu_nis ILIKE '%$term%') OR (asps_num_prontuario) = $term");
        else
            $sql->where("usu_nome ilike '%$term%' OR usu_mae ilike '$term%' OR to_char(usu_datanasc, 'DD/MM/YYYY') ilike '$term%'");
        $sql->where("usu_asps_ref = 't'")
            ->where("usu_asps_ativo = 't'")
            ->where("aspsu_ativo = 't'")
            ->where("usu.usu_codigo != 9999999")
            ->order("asps_num_prontuario ASC")
            ->limit(8);
        return $this->fetchAll($sql);
    }

    public function buscaCidadaoSemFamilia($term)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_nome", "usu_codigo", "usu_mae", "usu_datanasc", "usu_cpf", "usu_bloqueado"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array("aspsu_codigo", "aspsu_parentesco"))
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array("asps_codigo", "asps_num_prontuario"))
            ->joinLeft(array("aspsuni" => "as_prontuario_suas_unidade"), "asps.asps_codigo=aspsuni.asps_codigo", array())
            ->joinLeft(array("uni" => "unidade"), "aspsuni.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
            ->where("usu_nome ilike '%$term%' OR usu_cpf ilike '%$term%'")
            ->where("(usu_asps_ref <> 't' AND usu_asps_ativo = 't') OR (usu_asps_ativo = 'f' OR usu_asps_ativo IS NULL)")
            ->where("usu_ativacao=?", "S")
            ->where("usu.usu_codigo != 9999999")
            ->limit(8);
        return $this->fetchAll($sql);
    }

    public function validaCpf($cpf = FALSE, $usuCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("u" => "usuario"), array("usu_codigo"))
            ->where("usu_cpf=?", str_replace('-', '', str_replace('.', '', $cpf)))
            ->where("usu_cpf <> ''");
        if ($usuCodigo)
            $sql->where("usu_codigo <> $usuCodigo");

        return $this->fetchRow($sql);
    }

    public function validaNome($nome = FALSE, $usuCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("u" => "usuario"), array("usu_codigo"))
            ->where("usu_nome=?", $nome);
        if ($usuCodigo)
            $sql->where("usu_codigo <> $usuCodigo");
        return $this->fetchAll($sql)->count();
    }

    public function getDadosNome($nome = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("u" => "usuario"), array("usu_codigo"))
            ->where("usu_nome=?", $nome)
            ->where("usu_codigo != 9999999");
        return $this->fetchRow($sql);
    }

    public function salvar($data)
    {
        try {
            // Limpando dados em branco
            $this->emptyToUnset($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar cidadão: " . $ex->getMessage());
        }
    }

    public function salvarComCamposVazio($data)
    {
        try {
	        $this->emptyToNull($data);
            return parent::salvar($data);
        } catch (Exception $ex) {
//	        die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar cidadão: " . $ex->getMessage());
        }
    }

    /**
     * Retorna os dados da pessoa de referência da familia
     * @param int $asps_codigo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function getDadosEnderecoPessoaRef($aspsCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->join(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array())
            ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_codigo", "usu.dom_codigo as usu_dom_codigo", "dom_numero", "dom_complemento", "dom_ponto_referencia", "dom_telefone", "dom_as_localizacao", "dom_as_abrigo", "usu_codigo_responsavel"))
            ->joinLeft(array("dom_usu" => "usuario"), "dom.usu_codigo_responsavel=dom_usu.usu_codigo", array("dom_usu.usu_nome as usu_nome_responsavel"))
            ->joinLeft(array("rua" => "rua"), "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_codigo", "rua_cep"))
            ->joinLeft(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo", array("bai_codigo", "bai_nome"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=bai.cid_codigo", array("cid_codigo", "cid_nome"))
            ->joinLeft(array("est" => "estado"), "cid.uf_codigo=est.uf_codigo", array("uf_codigo", "uf_nome"))
            ->where("usu.usu_asps_ativo =?", "t")
            ->where("usu.usu_asps_ref =?", "t")
            ->where("asps.asps_codigo =?", $aspsCodigo);
        return $this->fetchRow($sql);
    }

    /**
     * Verifica se todos os dados esta preenchido
     * @param int $asps_codigo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function validaDadosPessoaRef($asps_codigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array())
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->join(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array())
            ->join(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_codigo", "dom_numero", "dom_complemento", "dom_ponto_referencia", "dom_telefone", "dom_as_localizacao", "dom_as_abrigo"))
            ->join(array("rua" => "rua"), "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_codigo", "rua_cep"))
            ->join(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo", array("bai_codigo", "bai_nome"))
            ->join(array("cid" => "cidade"), "cid.cid_codigo=bai.cid_codigo", array("cid_codigo", "cid_nome"))
            ->join(array("est" => "estado"), "cid.uf_codigo=est.uf_codigo", array("uf_codigo", "uf_nome"))
            ->where("usu.usu_nome IS NOT NULL")
            ->where("usu.usu_mae IS NOT NULL")
            ->where("usu.usu_sexo IS NOT NULL")
            ->where("usu.usu_datanasc IS NOT NULL")
            ->where("dom.dom_codigo IS NOT NULL")
            ->where("usu.usu_asps_ativo =?", "t")
            ->where("usu.usu_asps_ref =?", "t")
            ->where("asps.asps_codigo =?", $asps_codigo)
            ->where("usu.usu_codigo != 9999999");
        return $this->fetchRow($sql);
    }

    /**
     * Retorna a os dados do Cidadão
     * @param int $aspsCodigo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function getDadosCidadao($usuCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"))
            ->joinLeft(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array("aspsu_codigo", "aspsu_parentesco"))
            ->joinLeft(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array())
            ->joinLeft(array("cid_nasc" => "cidade"), "usu.cid_codigo_nasc=cid_nasc.cid_codigo", array("cid_nasc_nome" => "cid_nome"))
            ->where("usu.usu_codigo =?", $usuCodigo)
            ->where("usu.usu_codigo != 9999999");
        return $this->fetchRow($sql);
    }

    public function validaDadosBasico($usuCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_codigo"))
            ->where("usu_nome IS NOT NULL")
            ->where("usu_sexo IS NOT NULL")
            ->where("usu_datanasc IS NOT NULL")
            ->where("usu_asparentesco IS NOT NULL")
            ->where("usu_asdeficiencia IS NOT NULL")
            ->where("usu_asdoc_cnprov IS NOT NULL")
            ->where("usu_asdoc_rgprov IS NOT NULL")
            ->where("usu_asdoc_ctpsprov IS NOT NULL")
            ->where("usu_codigo =?", $usuCodigo);
        return $this->fetchAll($sql)->count();
    }

    /**
     * Retorna a membros da familia em forma de select
     * @param int $aspsCodigo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function selectTagMembrosFamilia($aspsCodigo = FALSE, $usuCodigo = FALSE, $id = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_codigo", "usu_nome"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->join(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array())
            ->where("aspsu.asps_codigo =?", $aspsCodigo)
            ->where("aspsu.aspsu_ativo =?", "t")
            ->order("aspsu.aspsu_num_ordem ASC");
//
//        if ($usuCodigo)
//            $sql->where("usu.usu_codigo <> $usuCodigo");

        if (empty($id))
            $id = "dp_usu_codigo_ate";


        return parent::selectTag($sql, "usu_nome", "usu_codigo", null, true, "usu_codigo_ate", $id, null, $usuCodigo);
    }

    /**
     * Retorna a os dados de renda da família
     * @param int $aspsCodigo
     * @return Zend_Db_Table_Row_Abstract
     */
    /*public function getDadosRendaFamilia($aspsCodigo=FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("usu"=>"usuario"),array("COUNT(usu.usu_codigo) AS qtd_membros",
                        "SUM(as_renda_mensal) AS renda_familia",
                        "(SUM(as_renda_mensal)/COUNT(usu.usu_codigo)) AS renda_percapita"))
                    ->join(array("aspsu"=>"as_prontuario_suas_usuario"),"usu.usu_codigo=aspsu.usu_codigo",array())
                    ->join(array("asps"=>"as_prontuario_suas"),"aspsu.asps_codigo=asps.asps_codigo",array())
                    ->join(array("aspsap"=>"asps_anot_programas_ct"),"asps.asps_codigo=aspsap.asps_codigo",array('aspsap_bolsa_familia_valor','aspsap_bpc_valor','aspsap_peti_valor','aspsap_outros_valor'))
                    ->where("asps.asps_codigo =?",$aspsCodigo)
                    ->where("aspsu.aspsu_ativo =?","t")
                    ->group(array('aspsap_bolsa_familia_valor','aspsap_bpc_valor','aspsap_peti_valor','aspsap_outros_valor'));
        return $this->fetchRow($sql);
    }*/

    public function getDadosRendaFamilia($aspsCodigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("COUNT(usu.usu_codigo) AS qtd_membros",
                "SUM(as_renda_mensal) AS renda_familia",
                "(SUM(as_renda_mensal)/COUNT(usu.usu_codigo)) AS renda_percapita"))
            ->join(array("aspsu" => "as_prontuario_suas_usuario"), "usu.usu_codigo=aspsu.usu_codigo", array())
            ->join(array("asps" => "as_prontuario_suas"), "aspsu.asps_codigo=asps.asps_codigo", array())
            ->where("asps.asps_codigo =?", $aspsCodigo)
            ->where("aspsu.aspsu_ativo =?", "t");
        return $this->fetchRow($sql);
    }

    public function getDadosCabLayout($usuCodigo)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->reset(Zend_Db_Select::WHERE)
            ->from(array("usu" => "usuario"), array("usu_codigo", "usu_sexo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
            ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_numero"))
            ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome"))
            ->where("usu_codigo=?", $usuCodigo);
        return $this->fetchRow($sql);
    }

    /**
     * Retorna a lista de cadastro dos cidadãos
     */
    public function getDados()
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("u" => "usuario"), array("usu_codigo", "usu_nome", "usu_mae", "usu_datanasc", "usu_fone", "usu_nis", "usu_bloqueado", "usu_obito"))
            ->where("usu_codigo <> 9999999")
            ->order("usu_codigo DESC")
            ->limit(500);
        return $this->fetchAll($sql);
    }

    /**
     * Retorna a lista de cadastro dos cidadãos de acordo com a pesquisa realizada
     */
    public function pesquisaDados($busca = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("u" => "usuario"), array("usu_codigo", "usu_nome", "usu_mae", "usu_datanasc", "usu_fone", "usu_nis", "usu_bloqueado", "usu_obito"))
            ->order("usu_nome ASC");

        $validator = new Zend_Validate_Regex("/^((([0][1-9]|[12][0-9])\/02\/(19|20)([13579][26]|[02468][048]))|(([0][1-9]|[1][0-9]|[2][0-8])\/02\/(19|20)([02468][12356]|[013579][13579]))|((([0][1-9]|[12][0-9]|30)\/(0[469]|11)|([0][1-9]|[12][0-9]|3[01])\/(0[13578]|1[02]))\/(19|20)[0-9][0-9]))$/");
        if ($validator->isValid($busca)) {
            $sql->where("to_char(usu_datanasc,'DD/MM/YYYY')='$busca'");
        } else {
            $sql->where("usu_nome ILIKE '%$busca%' or usu_mae ILIKE '%$busca%' or usu_nis ILIKE '%$busca%'");
        }
        $sql->where("u.usu_codigo != 9999999");
        return $this->fetchAll($sql);
    }

    /**
     * Exclui os dados do cidadão
     * @return SQL
     */
    public function excluir($usuCodigo = FALSE)
    {
        $item = $this->fetchRow("usu_codigo=$usuCodigo");
        if ($item)
            $item->delete();

        return true;
    }

    /* ------------------------------------------------------
     * FIM MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------*/


    /**
     * Carrega as informações que serão necessárias nas telas de impressão.
     * @param int $usu_codigo
     * @return stdClass
     */
    public function getDadosToPrint($usu_codigo)
    {
        $dados = new stdClass();

        $usu = $this->find($usu_codigo)->current();

        $end = array();
        $end [] = $usu->usu_end_rua;
        $end [] = $usu->usu_end_nr;
        $end [] = $usu->usu_end_compl;
        $end [] = $usu->usu_end_bairro;
        $end [] = $usu->usu_end_cidade;
        foreach ($end as $k => $item) {
            if (empty($item))
                unset($end[$k]);
        }

        $dados->usu_nome = $usu->usu_nome;
        $dados->usu_endereco = implode(", ", $end);
        $dados->usu_datanasc = $usu->usu_datanasc;

        return $dados;
    }

    public function buscarUsuarios($term = FALSE)
    {
        if ($term) {
            $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->reset(Zend_Db_Select::WHERE)
                ->from(array("usu" => "usuario"), array("usu_codigo", "usu_nome"))
                ->where("usu_nome ILIKE ('%$term%')")
                ->where("usu_ativacao=?", "S")
                ->where("usu.usu_codigo != 9999999");
            $all = $this->fetchAll($sql);
            $out = array();
            foreach ($all as $usu) {
                $data = $usu->toArray();
                $out [] = array(
                    "id" => $usu->usu_codigo,
                    "label" => $usu->usu_nome,
                    "data" => $data
                );
            }
            if (!count($out)) {
                $out [] = array(
                    "id" => 0,
                    "label" => "Nenhum item encontrado",
                    "data" => array("usu_codigo" => "0", "usu_nome" => "")
                );
            }
            return $out;
        }
    }

    /**
     * Buscar os USU's
     * usado para alimentar o plugin de busca (jquery)
     * @return json
     */
    public function buscar($term = FALSE)
    {
        $tbConf = new Application_Model_Configuracao();
        if ($term) {
            $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->reset(Zend_Db_Select::WHERE)
                ->from(array("usu" => "usuario"), array("usu_codigo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
                ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_numero"))
                ->joinLeft("psf", "psf.dom_codigo=dom.dom_codigo", "")
                ->joinLeft("area", "area.area_codigo=psf.psf_area", array("psf_area" => "COALESCE(area_desc::text,'Não definido')"))
                ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
                ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome"))
                ->where("usu.usu_ativacao=?", "S")
                ->where("usu.usu_codigo != 9999999");

            $where2 = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->reset(Zend_Db_Select::WHERE)
                ->from(array("usu" => "usuario"), array("usu_codigo", "usu_nome", "usu_mae", "usu_pai", "usu_datanasc" => "to_char(usu_datanasc,'DD/MM/YYYY')", "usu_prontuario", "usu_cartao_sus", "usu_bloqueado", "usu_nome_resp"))
                ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_numero"))
                ->joinLeft("psf", "psf.dom_codigo=dom.dom_codigo", "")
                ->joinLeft("area", "area.area_codigo=psf.psf_area", array("psf_area" => "COALESCE(area_desc::text,'Não definido')"))
                ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
                ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome"))
                ->where("usu_ativacao=?", "S")
                ->where("usu.usu_codigo != 9999999");
        }

        // repetição
        $validator = new Zend_Validate_Regex("/^((([0][1-9]|[12][0-9])\/02\/(19|20)([13579][26]|[02468][048]))|(([0][1-9]|[1][0-9]|[2][0-8])\/02\/(19|20)([02468][12356]|[013579][13579]))|((([0][1-9]|[12][0-9]|30)\/(0[469]|11)|([0][1-9]|[12][0-9]|3[01])\/(0[13578]|1[02]))\/(19|20)[0-9][0-9]))$/");
        if ($validator->isValid($term)) {
            $where->where("usu_datanasc=?", $term);
        } else {
            if ($tbConf->getConfig("BUSCA_CARTAO_FAMILIA") == 1 && (int)$term) {
                $cond1 = $this->select(FALSE)
                    ->where("usu_nome ilike '%$term%'")
                    ->orWhere("usu_prontuario = '$term'")
                    ->orWhere("usu.dom_codigo = '$term'")
                    //->orWhere("usu_codigo = " . ((int) $term))
                    ->getPart(Zend_Db_Select::WHERE);
            } else {
                $cond1 = $this->select(FALSE)
                    ->where("usu_nome ilike '%$term%'")
                    ->orWhere("usu_prontuario = '$term'")
                    //->orWhere("usu_codigo = " . ((int) $term))
                    ->getPart(Zend_Db_Select::WHERE);
            }


            $cond2 = $this->select(FALSE)
                ->where("usu_mae ilike '%$term%'")
                ->getPart(Zend_Db_Select::WHERE);


            $cond1 = implode(" ", $cond1);
            $cond2 = implode(" ", $cond2);
            $where->where($cond1);
            $where2->where($cond2);
        }
        //die($where);

        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->union(array($where, $where2), Zend_Db_Select::SQL_UNION_ALL);
        $all = $this->fetchAll($sql);

        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usu_codigo" => "0", "usu_mae" => "", "usu_datanasc" => "", "usu_nome" => "")
            );
        }
        return $out;
    }

    /**
     * Retorna os dados do paciente. Usar em cabeçalhos.
     * @param int $usu_codigo
     */
    public function getInfo($usu_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("usu" => "usuario"), array("usu_codigo", "usu_nome", "usu_sexo", "usu_datanasc", "usu_mae", "usu_fone", "usu_cartao_sus", "usu_ocupacao", "usu_endereco" => "usu_end_rua"))
            ->joinLeft(array("estc" => "estado_civil"), "estc.estc_codigo=usu.usu_estado_civil", array("estado_civil" => "estc_descricao"))
            ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("dom_codigo", "dom_numero", "dom_segmento", "dom_complemento"))
            ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", array("rua_nome", "rua_bairro"))
            ->joinLeft(array("log" => "tb_ms_tipo_logradouro"), "log.co_tipo_logradouro=rua.co_tipo_logradouro", "ds_tipo_logradouro_abrev")
            ->joinLeft(array("cid" => "cidade"), "cid.cid_codigo=rua.cid_codigo", array("cid_nome", "uf_sigla"))
            ->joinLeft(array("cbo" => "tb_ocupacao"), "cbo.co_ocupacao=usu.usu_ocupacao", array("no_ocupacao"))
            ->where("usu.usu_codigo=?", $usu_codigo)
            ->where("usu.usu_codigo != 9999999");

        $usu = $this->fetchRow($where);
        if ($usu->dom_codigo) {
            $out = array();
            $out [] = trim($usu->ds_tipo_logradouro_abrev . ": " . $usu->rua_nome);
            $out [] = $usu->dom_numero;
            $out [] = trim($usu->dom_segmento);
            $out [] = trim($usu->dom_complemento);
            $out [] = trim($usu->rua_bairro);
            $out [] = $usu->cid_nome;

            $this->emptyToUnset($out);

            $usu->usu_endereco = ucwords(strtolower(implode(", ", $out))) . "/" . $usu->uf_sigla;
        } else {
            $usu->usu_endereco = "<em>Não cadastrado</em>";
        }

        return $usu;
    }

    public function relProntuario($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $options = FALSE)
    {
        $dados = new stdClass();

        $dados->usu = $this->getInfo($usu_codigo);

        if (!$options || in_array("alertas", $options)) {
            $tbAle = new Application_Model_Alerta();
            $dados->alertas = $tbAle->getItens($usu_codigo);
        }

        if (!$options || in_array("atendimentos", $options)) {
            $tbAte = new Application_Model_Atendimento();
            $dados->atendimentos = $tbAte->getHistoricoDetalhado($usu_codigo, $data_inicial, $data_final);
            //echo "<pre>".print_r($tbAte->getHistoricoDetalhado($usu_codigo, $data_inicial, $data_final),1);
            //exit();
        }

        if (!$options || in_array("pre-consulta", $options)) {
            $tbPC = new Application_Model_PreConsulta();
            $dados->pre_consultas = $tbPC->getHistorico($usu_codigo, $data_inicial, $data_final, $options['pre-consulta']);
        }

        if (!$options || in_array("exames", $options)) {
            $tbAge = new Application_Model_Agenda();
            $dados->exames = $tbAge->getHistoricoDeExames($usu_codigo, $data_inicial, $data_final);
        }

        if (!$options || in_array("procedimentos", $options)) {
            $tbProc = new Application_Model_ProcedimentoAtendimento();
            $dados->procedimentos = $tbProc->getHistoricoPorPaciente($usu_codigo, $data_inicial, $data_final);
        }

        if (!$options || in_array("medicamentos", $options)) {
            $tbMov = new Application_Model_Movimento();
            $dados->medicamentos = $tbMov->getMedicamentosDispensados($usu_codigo, $data_inicial, $data_final);
        }

        if (!$options || in_array("observacoes", $options)) {
            //die($this->find($usu_codigo)->current()->usu_observacao);
            $dados->observacoes = $this->find($usu_codigo)->current()->usu_observacao;
        }

        if (!$options || in_array("vacinas", $options)) {
            $tbVac = new Application_Model_VacinaUsuario();
            $dados->vacinasAprazadas = $tbVac->getHistorico($usu_codigo, array(Application_Model_VacinaUsuario::APRAZAR), $data_inicial, $data_final);
            $dados->vacinas = $tbVac->getHistorico($usu_codigo, array(
                Application_Model_VacinaUsuario::APLICAR,
                Application_Model_VacinaUsuario::PREENCHER
            ), $data_inicial, $data_final);
        }

        if (!$options || in_array("internacoes", $options)) {
            //die($this->find($usu_codigo)->current()->usu_observacao);
            $tbIo = new Application_Model_InternacaoObservacao();
            $dados->internacoes = $tbIo->getHistorico($usu_codigo, $data_inicial, $data_final);
        }

        if (!$options || in_array("importacoes", $options)) {
            //die($this->find($usu_codigo)->current()->usu_observacao);
            $dados->importacoes = $this->find($usu_codigo)->current()->usu_importacao;
        }
        return $dados;
    }

    /**
     * Traz o histórico de consultas do paciente, para ser usado no modo ficha
     * @param int $usu_codigo
     * @param string $data_inicial
     * @param string $data_final
     * @param int $usr_codigo
     */
    public function relProntuarioFicha($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $usr_codigo = FALSE, $limit = FALSE)
    {
        $dados = new stdClass();

        $dados->usu = $this->getInfo($usu_codigo);


        $todasConsultas = (object)$this->relProntuarioFichaBuscar($usu_codigo, $data_inicial, $data_final, $usr_codigo, $limit)->toArray();
        $out = array();

        $tbPat = new Application_Model_ProcedimentoAtendimento();
        $modelFunc = new Application_Model_Funcoes();
        $tbReq = new Application_Model_RequisicaoExame();
        $tbIRec = new Application_Model_ReceitaItens();
        $tbEnc = new Application_Model_Encaminhamento();
        $tbPC = new Application_Model_PreConsulta();

        foreach ($todasConsultas as $consulta) {
            $consulta = (object)$consulta;

            $consulta->pre_consulta = $tbPC->temPreConsulta($consulta->age_codigo);

            $procs = $tbPat->getHistoricoPorAgendamento($consulta->age_codigo);
            $consulta->procedimentos = $modelFunc->rowsetToStr($procs, "proc_nome");

            $exames = $tbReq->getHistorico($consulta->ate_codigo);
            $consulta->exames = $modelFunc->rowsetToStr($exames, "proc_nome");

            $medicamentos = $tbIRec->getHistorico($consulta->ate_codigo);
            $consulta->medicamentos = $modelFunc->rowsetToStr($medicamentos, "pro_nome");

            $encamihamentos = $tbEnc->getHistorico($consulta->ate_codigo);
            $consulta->encaminhamentos = $modelFunc->rowsetToStr($encamihamentos, "esp_nome");

            $out [] = $consulta;
        }

        $dados->atendimentos = (object)$out;

        return $dados;
    }

    /**
     * Traz o histórico de consultas do paciente, para ser usado no modo ficha
     * @param int $usu_codigo
     * @param int $data_inicial
     * @param int $data_final
     * @param int $usr_codigo
     * @return Zend_Db_Table_Rowset_Abstract
     */
    private function relProntuarioFichaBuscar($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $usr_codigo = FALSE, $limit = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ate" => "atendimento"), array("ate_codigo", "ate_data", "ate_hora", "ate_reclamacao", "ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo"))
            ->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_codigo", "age_data"))
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr_nome")
            ->join(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", "esp_nome")
            ->join(array("uni" => "unidade"), "uni.uni_codigo=age.uni_codigo", "uni_desc")
            ->where("age.usu_codigo=?", $usu_codigo)
            ->order(array("age_data DESC", "age_hora DESC"));

        if ($data_inicial)
            $where->where("age.age_data >= ?", $data_inicial);

        if ($data_final)
            $where->where("age.age_data <= ?", $data_final);

        if ($usr_codigo)
            $where->where("age.med_codigo=?", $usr_codigo);

        if ($limit)
            $where->limit($limit);

        return $this->fetchAll($where);
    }

    /**
     * Atualiza todas as tabelas do sistema que estão vinculadas a um paciente duplicado para um único paciente
     * depois remove-os.
     * @param int $correto
     * @param array $duplicados
     * @return array quantos registros foram atualizados e quantos foram removidos por tabela
     */
    public function removerDuplicacoes($correto, $duplicados)
    {
        Zend_Registry::get("logger")->log(array($correto, $duplicados), Zend_Log::INFO);

        $out = array();
        $tbAge = new Application_Model_Agendamento();
        $tbAgexl = new Application_Model_AgendamentoExameLista();
        $tbAgee = new Application_Model_AgendamentoExterno();
        $tbAIH = new Application_Model_AIH();
        $tbAle = new Application_Model_Alerta();
        $tbApac = new Application_Model_Apac();
        $tbAte = new Application_Model_Atendimento();
        $tbAtf = new Application_Model_AtendimentoFamilia();
        $tbBPA = new Application_Model_BPA();
        $tbCtp = new Application_Model_CotaPaciente();
        $tbDou = new Application_Model_DoencaUsuario();
        $tbEvu = new Application_Model_EventoUsuario();
        $tbEvua = new Application_Model_EventoUsuarioAux();
        $tbGau = new Application_Model_GrupoAtendimentoUsuario();
        $tbHiper = new Application_Model_Hiperdia();
        $tbLie = new Application_Model_ListaEspera();
        $tbMov = new Application_Model_Movimento();
        $tbProc = new Application_Model_ProcedimentosMedico();
        $tbReq = new Application_Model_Requisicao();
        $tbSPN = new Application_Model_SisPreNatal();
        $tbTub = new Application_Model_Tuberculose();
        $tbGest = new Application_Model_UsuarioGestante();
        $tbVac = new Application_Model_VacinaUsuario();

        $this->getAdapter()->beginTransaction();

        try {
            $out['age'] = $tbAge->atualizarUsu($duplicados, $correto);
            $out['agexl'] = $tbAgexl->atualizarUsu($duplicados, $correto);
            $out['agee'] = $tbAgee->atualizarUsu($duplicados, $correto);
            $out['aih'] = $tbAIH->atualizarUsu($duplicados, $correto);
            $out['ale'] = $tbAle->atualizarUsu($duplicados, $correto);
            $out['apac'] = $tbApac->atualizarUsu($duplicados, $correto);
            $out['ate'] = $tbAte->atualizarUsu($duplicados, $correto);
            $out['atf'] = $tbAtf->atualizarUsu($duplicados, $correto);
            $out['bpa'] = $tbBPA->atualizarUsu($duplicados, $correto);
            $out['ctp'] = $tbCtp->atualizarUsu($duplicados, $correto);
            $out['dou'] = $tbDou->atualizarUsu($duplicados, $correto);
            $out['evu'] = $tbEvu->atualizarUsu($duplicados, $correto);
            $out['evua'] = $tbEvua->atualizarUsu($duplicados, $correto);
            $out['gau'] = $tbGau->atualizarUsu($duplicados, $correto);
            $out['hiper'] = $tbHiper->atualizarUsu($duplicados, $correto);
            $out['lie'] = $tbLie->atualizarUsu($duplicados, $correto);
            $out['mov'] = $tbMov->atualizarUsu($duplicados, $correto);
            $out['proc'] = $tbProc->atualizarUsu($duplicados, $correto);
            $out['req'] = $tbReq->atualizarUsu($duplicados, $correto);
            $out['spn'] = $tbSPN->atualizarUsu($duplicados, $correto);
            $out['tub'] = $tbTub->atualizarUsu($duplicados, $correto);
            $out['gest'] = $tbGest->atualizarUsu($duplicados, $correto);
            $out['vac'] = $tbVac->atualizarUsu($duplicados, $correto);

            $this->getAdapter()->commit();
        } catch (Exception $e) {
            $this->getAdapter()->rollBack();
            Zend_Registry::get("logger")->log($e->getMessage(), Zend_Log::INFO);
            return false;
        }
        $removidos = $this->remover($duplicados);
        return array(array_sum($out), $removidos);
    }

    /**
     * Recebe um array de usu_codigo e remove todos
     * @param array $usu_codigo
     * @return int Número de linhas removidas
     */
    public function remover($usu_codigo)
    {
        $where = $this->select()->where("usu_codigo IN (?)", $usu_codigo)->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];
        return $this->delete($where);
    }

}
