<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Usuarios extends Elotech_Db_Table_Abstract {

	protected $_name = 'usuarios';
	protected $_primary = 'usr_codigo';
	protected $_dependentTables = array('Agendamento');
	protected $_sequence = "seq_usr_codigo_9041";

	/*---------------------------------------------------
	* MÉTODOS AÇÃO SOCIAL
	*--------------------------------------------------*/

	public function getDadosPeloLogin($usrLogin = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("usr_codigo"))
			->where("usr.usr_login ='$usrLogin'");
		return $this->fetchRow($sql);
	}

	public function getDadosPeloNome($usrNome = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("usr_codigo"))
			->where("usr.usr_nome =?", $usrNome);
		return $this->fetchRow($sql);
	}

	public function buscaGeral($term = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("usr_codigo", "usr_nome"))
            ->joinLeft(array("crg" => "cargos"), "usr.crg_codigo = crg.crg_codigo AND crg.crg_status IS TRUE", array("crg_nome", "crg_codigo"))
			->where("retira_acentos(usr_nome) ilike retira_acentos('%$term%')")
			->where("usr_modulos in ('A','T')")
			->where("usr_ativo = 'S'")
			->order(array("usr_nome"))
			->limit(15);
		return $this->fetchAll($sql);
	}

	/*---------------------------------------------------
	* FIM MÉTODOS AÇÃO SOCIAL
	*--------------------------------------------------*/

	public function salvar(array $data) {
		// regra de negocio
		return parent::salvar($data);
	}

	/**
	 * Pega o usuário na session e busca em logon
	 * @throw Zend_Exception (cód: 1)caso não aja $_SESSION
	 * @throw Zend_Exception (cód: 2) caso não haja informação sobre o setor escolhido
	 * @return Object (Zend_Db_Table_Row->toArray())
	 */
	public function getUsrAtual() {
		$logon = new Zend_Session_Namespace("logon");
		//die($id_login."a");

		if (!isset($logon->usr->usr_codigo) || empty($logon->usr->usr_codigo)) {
			if (empty($_SESSION['usr_codigo'])) {
				throw new Zend_Exception("É necessário fazer login", 1);
			}
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("u" => "usuarios"))
				->join(array("l" => "logon"), "l.id_login=u.usr_codigo", "")
				->joinLeft(array("e" => "especialidade"), "e.esp_codigo=l.esp_codigo", array("esp_codigo", "esp_nome", "esp_pre_consulta"))
				->join(array("uni" => "unidade"), "uni.uni_codigo=l.uni_codigo", array("uni_codigo", "uni_desc"))
				->joinLeft(array("s" => "setor"), "s.set_codigo=l.cod_setor", array("set_codigo", "set_nome"))
				->where("id_login=?", $_SESSION["usr_codigo"]);

			$usr = $this->fetchRow($where);
            $logon->usr = (object) $usr->toArray();
		}

		return $logon->usr;
	}

	public function isMedico() {
		return in_array($this->getUsrAtual()->usr_tipo_medico, array("M", "D"));
	}

	/**
	 * Buscar os usuários
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term = FALSE, $incluirExterno = FALSE, $conveniado = FALSE) {
		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("usr" => "usuarios"), array("usr_codigo", "usr_nome", "interno" => "('1')", "categoria" => "('Interno')"))
				->where("retira_acentos(usr_nome) ilike retira_acentos('%$term%')");


		if ($incluirExterno) {
			$medico = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("med" => "medico"), array("med_codigo", "med_nome", "interno" => "('0')", "categoria" => "('Externo')"))
				->where("retira_acentos(med_nome) ilike retira_acentos('%$term%')");


			if ($conveniado) {
				$where->join(array("coni" => "convenio_itens"), "usr.usr_codigo=coni.usr_codigo", "")
					->joinLeft(array("mesp" => "medico_especialidade"), "mesp.med_codigo=usr.usr_codigo", "")
					->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mesp.esp_codigo", "esp_codigo")
					->where("conv_codigo=?", $conveniado);

				$medico->joinLeft(array("mesp" => "medico_especialidade"), "mesp.med_codigo=med.med_codigo", "esp_codigo");
			}

			$union = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->union(array($where, $medico), Zend_Db_Select::SQL_UNION_ALL)
				->order(array("categoria DESC", "usr_nome DESC"))
				->limit(15);
			$all = $this->fetchAll($union);
		} else {
			$where->order(array("usr_nome"))
				->limit(15);

			$all = $this->fetchAll($where);
		}

		$out = array();
		foreach ($all as $usr) {
			$out [] = array(
				"id" => $usr->usr_codigo,
				"label" => $usr->usr_nome,
				"data" => $usr->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("usr_codigo" => "0", "usr_nome" => "", "categoria" => "Nenhum médico encontrado")
			);
		}

		return $out;
	}

	public function fazPreConsulta() {
		// Tipos de usr que fazem pré-consulta:
		$fazPC = array("E", "A"); // (E)nfermeiro e (A)ux. de Enfermagem

		$usr = $this->getUsrAtual();
		return in_array($usr->usr_tipo_medico, $fazPC);
	}

	public function espPreciaDePreConsulta() {
		$usr = $this->getUsrAtual();
		return $usr->esp_pre_consulta;
	}

	public function estaLogado($usr_codigo, $min = 100) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("u" => "usuarios"), "usr_codigo")
			->join(array("l" => "logon"), "l.id_login=u.usr_codigo", "")
			->where("id_login=?", $usr_codigo)
			->where("dt_atualizacao >= NOW()+interval '$min minute'");

		$usr = $this->fetchRow($where);
		return (BOOL)$usr;
	}

	public function getInfoUsr($usr_codigo = FALSE) {
		if (!$usr_codigo)
			return false;

		return $this->fetchRow("usr_codigo=$usr_codigo");
	}

	/**
	 * Buscar os profissionais da saúde que não está ligados naquele convenio
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscarProfissionais($term = FALSE, $conv_codigo = FALSE) {
		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("usr" => "usuarios"), array("usr_codigo", "usr_nome"))
				->where("retira_acentos(usr_nome) ilike retira_acentos('%$term%')")
				->where("usr_modulos in ('A','T')");
		// ->where("usr.usr_codigo not IN (select usr_codigo from convenio_itens where conv_codigo = $conv_codigo )");

		$where->order(array("usr_nome"))
			->limit(15);

		$all = $this->fetchAll($where);


		$out = array();
		foreach ($all as $usr) {
			$out [] = array(
				"id" => $usr->usr_codigo,
				"label" => $usr->usr_nome,
				"data" => $usr->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("usr_codigo" => "0", "usr_nome" => "")
			);
		}

		return $out;
	}

	/**
	 * Buscar os profissionais da saúde que não está ligados naquele convenio
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscarUsuariosSaude($term = FALSE) {

		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("usr" => "usuarios"), array("usr_codigo", "usr_nome"))
				->join(array("mede" => "medico_especialidade"), "mede.med_codigo = usr.usr_codigo", "")
				->where("retira_acentos(usr_nome) ilike retira_acentos('%$term%')")
				->where("usr_tipo_medico in('M','E','A','D','P')");
		// ->where("usr.usr_codigo not IN (select usr_codigo from convenio_itens where conv_codigo = $conv_codigo )");

		$where->order(array("usr_nome"))
			->limit(15);

		$all = $this->fetchAll($where);
		//  die($where);


		$out = array();
		foreach ($all as $usr) {
			$out [] = array(
				"id" => $usr->usr_codigo,
				"label" => $usr->usr_nome,
				"data" => $usr->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("usr_codigo" => "0", "usr_nome" => "")
			);
		}

		return $out;
	}

	public function verificaLoginExistente($term = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("count(*) as logins"))
			->where("retira_acentos(usr_login) = upper(retira_acentos('$term')) OR retira_acentos(usr_login) = lower(retira_acentos('$term'))");
		return $this->fetchRow($where);
	}

	public function getUsuariosModulo() {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"))
			->limit(15)
			->where("usr_modulo='A'")
			->where("usr_ativo = 'S'");
		return $this->fetchAll($where);
	}

	public function getUsuariosBuscaFormSocial($term = FALSE, $mestre = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("usuarios", array("usr_codigo", "usr_nome", "usr_tipo_medico" => "(CASE WHEN usr_tipo_medico = 'M' THEN 'Médico'
                                                                                                                 WHEN usr_tipo_medico = 'E' THEN 'Enfermeiro(a)'
                                                                                                                 WHEN usr_tipo_medico = 'D' THEN 'Dentista'
                                                                                                                 WHEN usr_tipo_medico = 'P' THEN 'Psicólogo(a)'
                                                                                                                 WHEN usr_tipo_medico = 'C' THEN 'Comum'
                                                                                                                 WHEN usr_tipo_medico = 'F' THEN 'Farmáceutico(a)'
                                                                                                                 WHEN usr_tipo_medico = 'B' THEN 'Bioquímico(a)'
                                                                                                                 WHEN usr_tipo_medico = 'A' THEN 'Aux. Enfermagem'
                                                                                                             END)",
				"usr_login",
				"usr_ativo" => "(CASE WHEN usr_ativo = 'S' THEN 'Ativo'
                                                                                    WHEN usr_ativo = 'N' THEN 'Inativo(a)'
                                                                               ELSE 'Sem Status'
                                                                                END)"))
			->order("usr_codigo DESC");
		if ($term) {
            $where->where("usr_nome ilike '%$term%' or usr_login ilike '%$term%'");
            if(!$mestre){
                $where->where("usr_modulos in ('A', 'T')");
            }

		} else {
		    $where->where("usr_ativo = 'S'");
            if(!$mestre){
                $where->where("usr_modulos in ('A', 'T')");
            }
		}
		return $this->fetchAll($where);
	}

	public function getGridResource($page = 1, $limit = FALSE, $sidx = NULL, $sord = "ASC", $where = NULL) {
		$this->setFields(array("usr_codigo", "usr_nome"));

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"), array("usr_codigo", "usr_nome"));

		return parent::getGridResource($page, $limit, $sidx, $sord, $where);
	}

	public function verificaSenhaAtual($dados=FALSE){
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from('usuarios', 'COUNT(usr_codigo) as qtd')
			->where('usr_codigo=?', $dados['usr_codigo'])
			->where('usr_senha=?', md5($dados['usr_senha']));
		return $this->fetchRow($sql)->qtd;

	}

	public function pesquisa($term, $status)
	{
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("usr" => "usuarios"));
		if ($status !== 'Todos') {
			$status = ($status == 'Ativos' ? 'S' : 'N');
			$sql->where("usr.usr_ativo =?", $status);
		}
		$sql->where("retira_acentos(usr_nome) ilike retira_acentos('%$term%')")
            ->where("usr.usr_modulos IN ('A', 'T')")
			->order("usr.usr_ativo DESC")
			->order("usr.usr_codigo DESC");

//		die($sql);
		return $this->fetchAll($sql);
	}

	public function getDadosParaVinculo(){
	   $sql = $this->select()
           ->setIntegrityCheck(FALSE)
           ->from(array("mesp" => "medico_especialidade"))
           ->join(array("unid"=>"unidade_usuarios"),"mesp.med_codigo = unid.usr_codigo","")
           ->join(array("uni"=>"unidade"),"uni.uni_codigo = unid.uni_codigo", array("uni_usuario"=>"uni_codigo"))
           ->where("mesp.uni_codigo IS NULL AND uni.uni_as IS TRUE")
           ->order("mesp.med_codigo");

	   return $this->fetchAll($sql)->toArray();
    }

    public function getDadosVinculados($cod){
        $sql = $this->select()
            ->distinct(true)
            ->setIntegrityCheck(FALSE)
            ->from(array("mesp" => "medico_especialidade"))
            ->join(array("unid"=>"unidade_usuarios"),"mesp.med_codigo = unid.usr_codigo","")
            ->join(array("uni"=>"unidade"),"uni.uni_codigo = unid.uni_codigo", "uni_desc")
            ->join(array("usr"=>"usuarios"), "mesp.med_codigo = usr.usr_codigo", "usr_nome")
            ->join(array("esp"=>"especialidade"), "mesp.esp_codigo = esp.esp_codigo","esp_nome")
            ->where("mesp.mes_codigo = ?", $cod)
            ->order("usr.usr_nome");

        return $this->fetchRow($sql)->toArray();
    }

    public function getUsuariosSocialPermissoes($id=FALSE, $term=FALSE){
	    $where = $this->select()
                      ->from(["usr"=>"usuarios"],["usr_codigo","usr_nome","usr_ativo"]);
            if($id){
                $where->where("usr_codigo = $id");
            } else if($term){
                $where->where("usr_nome ILIKE '%$term%'");
            }
                $where->where("usr_modulos in ('A','T')")
                      ->order("usr_nome");
	    return $this->fetchAll($where);
    }
}
