<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_ViagemUsuario extends Elotech_Db_Table_Abstract {

    protected $_name = 'viagem_usuario';
    protected $_primary = 'viausu_codigo';   

    /**
     * Persiste um item (insert ou update)
     * @param array $data array de chave=>valor, cada chave corresponde a um atributo
     * @return int primary key do item (nextVal para insert) 
     */
    public function salvar(array $data) {
        $this->valoresPadrao($data);
        $this->notEmpty(array("usu_codigo","viausu_alimentacao","viausu_pernoite","cid_codigo_origem","cid_codigo_destino"), $data);
        $this->emptyToUnset($data);     
        return parent::salvar($data);
    }
    
    /**
    * Valores padrão do insert/update
    * @param array $data valores do insert
    */
   private function valoresPadrao(&$data) {
           $tbUsr = new Application_Model_Usuarios();
           $data['usr_codigo_cadastro'] = $tbUsr->getUsrAtual()->usr_codigo;
                         
          
   }
   
    /**
     * Exclui um veiculo	
     * @param int $vei_codigo Código da veiculo
     * @return Zend_Db_Table_Row_Abstract 
     */
    public function excluir($viausu_codigo=FALSE) {
        $item = $this->fetchRow("viausu_codigo=$viausu_codigo");
        if ($item) {
                $item->delete();
        }
    }
     /**
     * Busca ViagemUsuario	
     * @param int $dados Dados poder ser o nome do setor ou a descricai da Veiculo
     * @return Zend_Db_Table_Row_Abstract 
     */
    public function getViagemUsuario($via_codigo) {
      
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vu"=>"viagem_usuario"),array("viausu_codigo"))
                            ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu_nome","usu_celular"))
                            ->joinLeft(array("dom"=>"domicilio"),"dom.dom_codigo=usu.dom_codigo","dom_telefone")
                            ->join(array("cid1"=>"cidade"), "vu.cid_codigo_origem = cid1.cid_codigo",array("cid1.cid_nome as cid_nome_origem"))
                            ->join(array("cid2"=>"cidade"), "vu.cid_codigo_destino = cid2.cid_codigo",array("cid2.cid_nome as cid_nome_destino"))
                            ->join(array("via"=>"viagem"), "via.via_codigo = vu.via_codigo",array("via.via_local","via.via_hora"))		
                            ->where("vu.via_codigo=?",$via_codigo);
        // die($where);
            return $this->fetchAll($where);
    }
     /**
     * Busca ViagemUsuario	
     * @param int $id código do usuario da viagem
     * @return Zend_Db_Table_Row_Abstract 
     */
    public function getViagemPorUsuario($id) {
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vu"=>"viagem_usuario"),array("viausu_codigo","viausu_alimentacao","viausu_pernoite","viausu_despesas","viausu_km","viausu_observacao"))
                            ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu.usu_nome","usu_codigo"))                            
                            ->join(array("cid1"=>"cidade"), "vu.cid_codigo_origem = cid1.cid_codigo",array("cid1.cid_nome as busca1","cid1.cid_codigo as cid_codigo"))
                            ->join(array("cid2"=>"cidade"), "vu.cid_codigo_destino = cid2.cid_codigo",array("cid2.cid_nome as busca2","cid2.cid_codigo as cid_codigo_2"))
                            ->join(array("via"=>"viagem"), "via.via_codigo = vu.via_codigo",array("via_codigo","via_data","via.via_local","via.via_hora"))
                            ->join(array("vei"=>"veiculo"),"via.vei_codigo=vei.vei_codigo",array("vei_descricao"))
                            ->where("vu.viausu_codigo=?",$id);
         
       // die($where);
            return $this->fetchRow($where);
    }
    
     public function getViagemPorUsuarioJson($id) {
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vu"=>"viagem_usuario"),array("viausu_codigo","viausu_alimentacao","viausu_pernoite","viausu_despesas","viausu_km"))                            
                            ->join(array("via"=>"viagem"), "via.via_codigo = vu.via_codigo",array("via_codigo","via_data","via.via_local","via.via_hora"))                            
                            ->where("vu.via_codigo=?",$id);
         
        //die($where);
            return $this->fetchAll($where);
    }
    
         /**
     * Busca Usuarios daquela Viagem	
     * @param int $id codigo da viagem
     * @return Zend_Db_Table_Row_Abstract 
     */
    public function getUsuariosDaViagem($id) {
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vu"=>"viagem_usuario"),array("viausu_codigo"))
                            ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu.usu_nome","usu_codigo"))                                                       
                            ->where("vu.via_codigo=?",$id);
       
          //die($where);
            return $this->fetchAll($where);
    }
    
    public function getDadosFullDaViagem($id) {
        $where = $this->select(FALSE)
                     ->setIntegrityCheck(FALSE)
                     ->distinct()
                     ->from(array("via"=>"viagem"),"")
                     ->join(array("vu"=>"viagem_usuario"),"vu.via_codigo = via.via_codigo",array("vu.viausu_codigo","vu.viausu_despesas","COALESCE(viausu_observacao,NULL,'---') as viausu_observacao"))
                     ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu.usu_codigo","usu.usu_nome","usu_celular"))
                     ->joinLeft(array("dom"=>"domicilio"),"dom.dom_codigo=usu.dom_codigo","COALESCE(dom_telefone,NULL,'---') as dom_telefone")
                     ->where("vu.via_codigo=?",$id)
                     ->order(array("usu.usu_nome"));
        /* Consulta antiga
        $where = $this->select(FALSE)
                     ->setIntegrityCheck(FALSE)
                     ->distinct()
                     ->from(array("via"=>"viagem"),"")
                     ->join(array("vu"=>"viagem_usuario"),"vu.via_codigo = via.via_codigo",array("vu.viausu_codigo","vu.viausu_despesas","COALESCE(viausu_observacao,NULL,'---') as viausu_observacao"))
                     ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu.usu_codigo","usu.usu_nome","usu_celular"))
                     ->joinLeft(array("dom"=>"domicilio"),"dom.dom_codigo=usu.dom_codigo","COALESCE(dom_telefone,NULL,'---') as dom_telefone")
                     ->joinLeft(array("ua"=>"usuario_acompanhante"), "ua.viausu_codigo=vu.viausu_codigo","")
                     ->joinLeft(array("usu2"=>"usuario"), "usu2.usu_codigo=ua.usu_codigo","usu2.usu_nome as nome_acompanhante")
                     ->where("vu.via_codigo=?",$id)
                     ->order(array("usu.usu_nome","usu2.usu_nome"));
       */
       //die($where);
       return $this->fetchAll($where);
    }
    
    public function getBalancoViagem($id){
        $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vu"=>"viagem_usuario"),array("(select count(*) from viagem_procedimento_usuario vpu2 where vpu2.viausu_codigo = vu.viausu_codigo and vpu2.proc_codigo = vpu.proc_codigo) as qtde","viausu_codigo","viausu_despesas"))
                            ->join(array("usu"=>"usuario"),"usu.usu_codigo = vu.usu_codigo",array("usu.usu_nome","usu_codigo"))                                                       
                            ->join(array("ua"=>"usuario_acompanhante"),"ua.viausu_codigo = vu.viausu_codigo", "")
                            ->join(array("usua"=>"usuario"),"usua.usu_codigo = ua.usu_codigo",array("usua.usu_nome as usu_nome_acompanhante"))
                            ->joinLeft(array("vpu"=>"viagem_procedimento_usuario"),"vpu.viausu_codigo = vu.viausu_codigo","")
                            ->join(array("proc"=>"procedimento"),"proc.proc_codigo = vpu.proc_codigo",array("proc_nome","proc_vlsa"))
                            ->where("vu.via_codigo=?",$id)
                            ->order(array("usu.usu_nome","usua.usu_nome","proc_nome"));
        
        return $this->fetchAll($where);
    }
    
    public function getDadosAcompanhantesDaViagem($viausu_codigo){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("ua"=>"usuario_acompanhante"),"")
                      ->join(array("usu"=>"usuario"),"ua.usu_codigo=usu.usu_codigo",array("usu.usu_nome"))
                      ->where("viausu_codigo=?",$viausu_codigo);
        return $this->fetchAll($where);
    }
    
    
    /**
     * Busca ViagemUsuario	
     * @param int $dados Dados poder ser o nome do setor ou a descricai da Veiculo
     * @return Zend_Db_Table_Row_Abstract 
     */
    public function pesquisar($via_data=FALSE,$cid_codigo_origem=FALSE,$cid_codigo_destino=FALSE,$vei_codigo=FALSE) {
        $arrayOrigem = array();
        $arrayDestino = array();
        
        $where = $this->select(FALSE)
              ->setIntegrityCheck(FALSE)
              ->distinct()
              ->from(array("via"=>"viagem"),array("via.via_codigo","via_data","via_codigo","via_local","via_hora"))
              ->join(array("usr"=>"usuarios"),"usr.usr_codigo=via.usr_codigo" ,"usr_nome")
              ->join(array("vei"=>"veiculo"), "vei.vei_codigo=via.vei_codigo","vei_descricao")
              ->joinLeft(array("vu"=>"viagem_usuario"), "vu.via_codigo=via.via_codigo","")
              ->joinLeft(array("cid1"=>"cidade"), "cid1.cid_codigo=vu.cid_codigo_origem",$arrayOrigem)
              ->joinLeft(array("cid2"=>"cidade"), "cid2.cid_codigo=vu.cid_codigo_destino",$arrayDestino)
              ->order("via.via_codigo desc");  
        if($via_data){
            $where->where("via_data=?",$via_data);
        }
        if($cid_codigo_origem){
            array_push($arrayOrigem, "cid1.cid_nome");
            $where->where("cid_codigo_origem=?",$cid_codigo_origem);
        }
        if($cid_codigo_destino){
            array_push($arrayOrigem, "cid2.cid_nome");
            $where->where("cid_codigo_destino=?",$cid_codigo_destino);
        }
        if($vei_codigo){
            $where->where("vei.vei_codigo=?",$vei_codigo);
        }
        //die($where);
        return $this->fetchAll($where);
                
    }
    
        
}

