<?php
class Acesso_AcessoController extends Zend_Controller_Action {
    public function init() {
       $this->view->title = "Acesso";
       $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/acesso/acesso/form.js');
    }
    
    public function indexAction(){
        $tbAce = new Application_Model_Acesso();
        $this->view->itens = $tbAce->getAcessos();
    }
    
   public function salvarAction() {
       $tbAce = new Application_Model_Acesso();        
       $this->_helper->layout->disableLayout();
       
       $dados = array("ace_descricao"=>$this->_getParam("ace_descricao_novo",FALSE),
                      "ace_caminho"=>$this->_getParam("ace_caminho",FALSE),
                      "ace_modulo"=>"13",
                      "ace_pai"=>$this->_getParam("ace_codigo",FALSE),
                      "ace_item_menu"=>($this->_getParam("ace_item_menu",FALSE) != "t" ? "f" : "t") );

       if($this->_getParam("ace_codigo_novo",FALSE)){
          $dados[ace_codigo] =  $this->_getParam("ace_codigo_novo",FALSE);
       }
       $tbAce->salvar($dados);
       $this->_redirect("acesso/acesso/");
   }
   
    public function novoAction(){
        
        $this->render("form");
    }
    
    public function buscarAction(){
        $tbAce = new Application_Model_Acesso();
		
        $term = $this->_getParam("term",FALSE);

        $this->view->dados = $tbAce->buscar($term);
        //echo "<pre>".print_r($this->view->dados,1);die();
        return $this->render("dados", NULL, TRUE);
    }
   
    
    public function deletarAction(){
       $id = $this->_getParam("id",false);        
       $tbAce = new Application_Model_Acesso();
       //$ver = $tbAce->verificaTodosVinculos($id);
       try{
        $tbAce->excluir($id);
       }  catch (Zend_Exception $e){
           $this->view->dados = $e->getMessage();
       }
       return $this->render("dados", NULL, TRUE);
    }
    
    public function editarAction(){
        $ace_codigo = $this->_getParam("id");
        $tbAce = new Application_Model_Acesso();
        $this->view->dados = $tbAce->getAcesso($ace_codigo);
        return $this->render("form");
    }
    
    public function pesquisaAction() {
        if ($this->_request->isPost()) {
            $tbAce = new Application_Model_Acesso();
            $this->view->busca = $this->_request->getPost("busca");                
            $this->view->itens = $tbAce->pesquisar($this->view->busca);
            $this->render("index");
        } else {
             $this->_redirect("/acesso/acesso/index");
        }
    }
    
   
    
}
?>
