<?php

class Acesso_AcessoUsuariosController extends Zend_Controller_Action
{
    public function init()
    {
    }

    public function indexAction()
    {

    }

    public function salvarAcessoUsuariosAction()
    {

        $ace_codigo = $this->_getParam("ace_codigo");
        $usr_codigo = $this->_getParam("usr_codigo");


        $dados = array(
            "ace_codigo" => $ace_codigo,
            "usr_codigo" => $usr_codigo
        );

        $tbAcu = new Application_Model_AcessoUsuarios();
        try {
            $tbAcu->salvar($dados);
            $this->view->dados = array("success" => true);
        } catch (Exception $e) {
            $this->view->dados = array("success" => false, "mensagem" => $e->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function deletarAction()
    {
        $acu_codigo = $this->_getParam("acu_codigo");
        $tbAcu = new Application_Model_AcessoUsuarios();
        try {
            $tbAcu->excluir($acu_codigo);
            $this->view->dados = array("success" => true);
        } catch (Exception $e) {
            $this->view->dados = array("success" => false, "mensagem" => $e->getMessage());
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisarAction()
    {
        $term = $this->_getParam("busca");

        $tbUsr = new Application_Model_Usuarios();

        $this->view->dados = $tbUsr->getUsuariosSocialPermissoes(FALSE, $term)->toArray();

        return $this->render("dados", NULL, TRUE);
    }

    public function carregarPermissoesAction()
    {
        $id = $this->_getParam("id");
        $term = $this->_getParam("term", FALSE);
        $this->view->dados = (new Application_Model_AcessoUsuarios())->getPermissoesById($id, $term)->toArray();
        return $this->render("dados", NULL, TRUE);

    }
}

?>
