<?php
class Acesso_GrupoController extends Zend_Controller_Action {
    public function init() {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/acesso/grupo/grupo.js');
        parent::init();
        $this->view->title = "Grupo de Acesso";
    }
    
   public function indexAction(){
       $this->_helper->layout->setLayout("simples");
        $tbAce = new Application_Model_GrupoAcesso();
        $this->view->grupos = $tbAce->fetchAll(null,"grac_descricao");
        $this->view->usuarios = (new Application_Model_Usuarios())->getUsuariosSocialPermissoes();
    }
    
   public function salvarAction() {

            $tbGrac = new Application_Model_GrupoAcesso();
            $dados = array(
                    "grac_descricao" => strtoupper($this->_request->getPost("grac_descricao", FALSE)),
            );
            $duplicidade = $tbGrac->verificaPendencias($dados['grac_descricao']);
            $grac_codigo = $this->_request->getPost("grac_codigo", FALSE);

            if($grac_codigo){

                if($duplicidade){
                    if($grac_codigo == $duplicidade->grac_codigo){
                        $dados['grac_codigo'] = $grac_codigo;
                    } else{
                        $this->view->dados = array("error" => "Ja existe um grupo com esta descrição!");
                        return $this->render("dados", NULL, TRUE);
                    }
                } else{
                    $dados['grac_codigo'] = $grac_codigo;
                }

            } else if ($duplicidade){
                $this->view->dados = array("error" => "Ja existe um grupo com esta descrição!");
                return   $this->render("dados", NULL, TRUE);
            }

            try {
                    $tbGrac->salvar($dados);
                    $this->view->dados = array("success" => true);
            } catch (Exception $exc) {
                    $this->view->dados = array("error" => $exc->getMessage());

            }
      return $this->render("dados", NULL, TRUE);
    }

   public function deletarAction(){
        $tbGrac = new Application_Model_GrupoAcesso();
        $tbGrau = new Application_Model_GrupoAcessoUsuarios();
        $grac_codigo = $this->_getParam("grac_codigo");

        $usrs = $tbGrau->getUsrsByGrupo($grac_codigo);
       Zend_Db_Table::getDefaultAdapter()->beginTransaction();
       try{
           foreach ($usrs as $usr){

               $tbGrau->excluir($usr->grau_codigo);
           }
           $tbGrac->excluir($grac_codigo);
           Zend_Db_Table::getDefaultAdapter()->commit();
           $this->view->dados = array("success"=>true);
       }  catch (Exception $e){
           Zend_Db_Table::getDefaultAdapter()->rollBack();
           $this->view->dados = array("success"=>false, "mensagem"=>$e->getMessage());
       }

        return $this->render("dados", NULL, TRUE);
    }
    
   public function carregarUsuariosAction(){
        $id = $this->_getParam("id");
        $tbGrau = new Application_Model_GrupoAcessoUsuarios();

        if($id){
            $this->view->dados = $tbGrau->getUsrsByGrupo($id)->toArray();
            return $this->render("dados", NULL, TRUE);
        }
    }

   public function pesquisarAction(){
       $term = $this->_getParam("busca");
       $tbGrac = new Application_Model_GrupoAcesso();
       if($term){
           $this->view->dados = $tbGrac->fetchAll("grac_descricao ILIKE '%$term%'","grac_descricao")->toArray();
       } else{
           $this->view->dados = $tbGrac->fetchAll(null,"grac_descricao")->toArray();
       }
       return $this->render("dados", NULL, TRUE);
   }
    
}

