<?php

class Agenda_ConvenioController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Convênios";
	}

	public function indexAction() {
		$this->view->title = "Cadastro de convênio";
		$tbConv = new Application_Model_Convenio();
		//$this->view->convenio = $tbConv->selectTag();
		$this->view->itens = $tbConv->pesquisar(FALSE, 1);
	}

	public function novoAction() {
		$this->view->title = "Cadastro de convênio";
	}

	/**
	 * Busca as unidades, laboratórios e hospitáis conveniados
	 * @example Para buscar somente os já cadastrados: /WebSocialSaude/zf/agenda/convenio/buscar/?term=nome
	 * @example Para buscar todos os prestadores e unidades: /WebSocialSaude/zf/agenda/convenio/buscar/?term=nome&todos=1
	 */
	public function buscarAction() {
		$term = $this->_getParam("term", FALSE);
		if (!$term)
			return false;

		$tbConv = new Application_Model_Convenio();
		$limite = $this->_getParam("limite", FALSE);
		$somenteConveniados = !$this->_getParam("todos", FALSE);

		$this->view->dados = $tbConv->buscar($term, $limite, $somenteConveniados);

		return $this->render("dados", NULL, TRUE);
	}

	public function pesquisaAction() {
		if ($this->_request->isPost()) {
			$this->view->busca = $this->_request->getPost("busca");
			$tbProc = new Application_Model_Convenio();
			$this->view->itens = $tbProc->pesquisar($this->view->busca);
			$this->render("index");
		} else {
			$this->_redirect("agenda/convenio");
		}
	}

	public function salvarAction() {
		$this->view->title = "Cadastro de convênio";

		if ($this->_request->isPost()) {
                    //echo "<pre>".print_r($_POST,1);exit;
                        if($this->_request->getPost("prestador_servico") == "U"){
                            $convenioUni = $this->_request->getPost("codigo_convenio");
                        }else{
                            $convenioLab = $this->_request->getPost("codigo_convenio");
                        }
                    	$dados = array(                               
				"med_codigo" => $convenioLab,
                                "uni_codigo" => $convenioUni,
				"conv_sabado" => $this->_request->getPost("sabado", "F"),
				"conv_domingo" => $this->_request->getPost("domingo", "F")
			);

			try {
				$tbConv = new Application_Model_Convenio();
				$pk = $tbConv->salvar($dados);
				return $this->_redirect("/agenda/convenio-itens/index/conv/$pk");
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->render("novo");
			}
		} else {
			$this->_redirect("/agenda/convenio");
		}
	}

	public function atendeAction() {
		$this->_helper->layout->disableLayout();
		/*
		  conv_codigo: id,
		  tipo: 'sabado',
		  to: to
		 */
		$dados = array(
			"conv_codigo" => $this->_request->getPost("conv_codigo", NULL),
			"to" => $this->_request->getPost("to", NULL),
			"tipo" => $this->_request->getPost("tipo", NULL),
		);

		try {
			$tbConv = new Application_Model_Convenio();
			$pk = $tbConv->salvar($dados);
			$this->view->dados = $dados["to"];
		} catch (Zend_Validate_Exception $exc) {
			die($exc->getMessage());
			$this->view->dados = "Ocorreu um erro desconhecido";
			if (APPLICATION_ENV == "development")
				$this->view->dados = $exc->getMessage();
		}
	}

	public function excluirAction() {
		$id = (int) $this->_getParam("id", 0);

		if (!$id) {
			return $this->_redirect("/agenda/convenio");
		}
		$tbConv = new Application_Model_Convenio();
		$tbConv->excluir($id);

		if ($this->_getParam("json", FALSE)) {
			$this->view->dados = array("success" => TRUE);
			return $this->render("dados", NULL, TRUE);
		}

		return $this->_redirect("/agenda/convenio");
	}

}

