<?php

class Agenda_ConvenioItensController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Itens do Convênios";
	}

	public function indexAction() {
		$conv_codigo= $this->carregaDadosConvenio();
		$tbConv = new Application_Model_Convenio();	
		$tbConI = new Application_Model_ConvenioItens();
		$this->view->fds = $tbConv->atendeSabadoEDomingo($conv_codigo);
	}

	public function itensAction() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo)
			return $this->_redirect("/agenda/convenio");

		$tbConI = new Application_Model_ConvenioItens();
		$tbConv = new Application_Model_Convenio();

		$this->view->prestador = $tbConv->buscarPeloConv($conv_codigo)->prestador_servico;
		$this->view->itens = $tbConI->buscarPeloConvenio($conv_codigo);

		//die($this->view->fds);
		// echo "<pre>" . print_r( $this->view->fds, 1);
		// die();
	}

	public function buscarAction() {
		$conv_codigo = $this->_getParam("conv_codigo", FALSE);
		$term = $this->_getParam("term", FALSE);
		$tbConI = new Application_Model_ConvenioItens();
		$this->view->dados = $tbConI->buscaSelectProcedimento($conv_codigo, $term);
		//echo "<pre>".  print_r($res,1);

		return $this->render("dados", NULL, TRUE);
		//$this->view->itens = $res;
	}

	/**
	 * Listar os procedimentos* de um convenio
	 * Chamar por post
	 * @param int conv_codigo
	 * @return json
	 */
	public function procedimentosAjaxAction() {

		$conv_codigo = $this->_request->getPost("conv_codigo", FALSE);
		if (!$conv_codigo)
			return $this->_redirect("/agenda/convenio/novo");

		$tbConvI = new Application_Model_ConvenioItens();

		$this->view->dados = $tbConvI->buscarPeloConvenio($conv_codigo, "S")->toArray();

		return $this->render("dados", NULL, TRUE);
	}

	public function salvarAction() {
		$this->view->title = "Cadastro de convênio";
		// echo "<pre>".print_r($_POST,1);exit;

		// Validando se está vindo dados via post
		if ($this->_request->isPost()) {
			// Criando o array com os dados para inserir no banco
			$dados = array(
				"proc_codigo" => $this->_request->getPost("proc_codigo", NULL),
				"esp_codigo" => $this->_request->getPost("esp_codigo", NULL),
				"usr_codigo" => $this->_request->getPost("usr_codigo", NULL),
				"conv_codigo" => $this->_request->getPost("conv_codigo", FALSE),
				"coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
				"coni_valor" => $this->_request->getPost("coni_valor", NULL),
				"coni_cota_mes" => $this->_request->getPost("coni_cota_mes", -1),
				"coni_cota_dia" => $this->_request->getPost("coni_cota_dia", -1),
				"coni_cota_mes_original" => $this->_request->getPost("coni_cota_mes_original", -1),
				"coni_cota_dia_original" => $this->_request->getPost("coni_cota_dia_original", -1),
				"coni_tipo_origem" => $this->_request->getPost("prestador", "P"),
				"coni_tipo_prestador" => $this->_request->getPost("coni_tipo_prestador", "Q"),
				"coni_ativo" => $this->_request->getPost("coni_ativo"),
				"coni_encaixe" => $this->_request->getPost("coni_encaixe", NULL),
				"coni_intervalo" => $this->_request->getPost("coni_intervalo", NULL)
			);
			
			if ($this->_request->getPost("coni_data_inicio")) {
				$dados["coni_data_inicio"] = $this->_request->getPost("coni_data_inicio");
			}
			
			if ($this->_request->getPost("coni_data_termino")) {
				$dados["coni_data_termino"] = $this->_request->getPost("coni_data_termino");
			}
			
			try {
				// Chamando o model de convênio itens
				$tbConv = new Application_Model_ConvenioItens();
				// Enviando os dados para salvar no banco
				$coni_codigo = $tbConv->salvar($dados);
				// Remove os horários dos convênios pra atualizar posteriormente
				$tbHora = new Application_Model_ConvenioHorarios();
				$tbHora->excluir($coni_codigo);
				// Colocando os horários em array e salvando em banco	
				for ($i = 1; $i <= $this->_request->getPost("qtd_hr", 0); $i++) {
					$dadosHora = array(
						"coni_codigo" => $coni_codigo,
						"hora_inicial" => $this->_request->getPost("hr_inicio" . $i, FALSE),
						"hora_final" => $this->_request->getPost("hr_fim" . $i, FALSE)
					);
					$tbHora->salvar($dadosHora);
				}
				// Chamando o model de dias da semana
				$tbDias = New Application_Model_ConvenioDiasSemana();
				// Removendo os dias cadastrados, para atualizar posteriormente 
				$tbDias->excluir($coni_codigo);
				$dias = $this->_request->getPost("dias", 0);
				foreach ($dias as $value) {
					$dadosDias = array(
						"coni_codigo" => $coni_codigo,
						"condi_dia" => $value);
					$tbDias->salvar($dadosDias);
				}
				// Redirecionando a página, tratamento de erros
				return $this->_redirect("/agenda/convenio-itens/index/conv/" . $dados["conv_codigo"]);
			// Tratamento de erro
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->carregaDadosConvenio();
				return $this->render("index");
			}
		} else {
			$this->_redirect("/agenda/convenio/novo");
		}
	}

	private function carregaDadosConvenio() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo) {
			return $this->_redirect("/agenda/convenio/novo");
		}
		$tbConv = new Application_Model_Convenio();
		$this->view->conv = $tbConv->buscarPeloConv($conv_codigo);
		return $conv_codigo;
	}

	public function editarAction() {
		$conv_codigo = $this->carregaDadosConvenio();
		$coni_codigo = (int) $this->_getParam("id", 0);
		if (!$coni_codigo)
			return $this->_redirect("/agenda/convenio-itens");
		$tbConi = new Application_Model_ConvenioItens();
		$tbDias = new Application_Model_ConvenioDiasSemana();
		$tbHora = new Application_Model_ConvenioHorarios();

		$this->view->itens = $tbConi->buscarPeloConvenio($conv_codigo);
		$this->view->dados = $tbConi->busca($coni_codigo);

		$this->view->atende = $tbDias->getDiasDeAtendimentoArray($coni_codigo);
		$this->view->hora = $tbHora->getHorariosArray($coni_codigo);
		//  echo "<pre>" . print_r($_SESSION, 1);               die();


		return $this->render("index");
	}

	public function excluirAction() {
		$id = (int) $this->_getParam("id", 0);
		$conv = (int) $this->_getParam("conv", 0);

		if (!$id) {
			return $this->_redirect("/agenda/convenio-itens");
		}

		$tbHora = new Application_Model_ConvenioHorarios();
		$tbHora->excluir($id);

		$tbDias = new Application_Model_ConvenioDiasSemana();
		$tbDias->excluir($id);

		$tbConi = new Application_Model_ConvenioItens();
		$tbConi->excluir($id);

		if ($this->_getParam("json", FALSE)) {
			$this->view->dados = array("success" => TRUE);
			return $this->render("dados", NULL, TRUE);
		}

		return $this->_redirect("/agenda/convenio-itens/index/conv/$conv");
	}

	public function carregaEspecialidadeAction() {
		$usr_codigo = (int) $this->_getParam("usr_codigo", false);
		$conv_codigo = (int) $this->_getParam("conv_codigo", false);
		$tbMes = new Application_Model_MedicoEspecialidade();
		$this->view->dados = $tbMes->getEspecialidadePorMedico($usr_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function carregaEspecialidadePorConvenioAction() {
		$conv_codigo = $this->_getParam("conv_codigo", false);
		$usr_codigo = $this->_getParam("usr_codigo", false);
		$tbMes = new Application_Model_MedicoEspecialidade();
		$this->view->dados = $tbMes->getEspecialidadePorConvenio($conv_codigo, $usr_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

}

