<?php

class Agenda_RecepcaoController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Recepção de pacientes";
                $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/agenda/distribuicao.js');
	}

	public function indexAction() {
		$this->view->title = "Recepção de pacientes";
                
		//$tbConv = new Application_Model_ConvenioItens();
		//$this->view->convenio = $tbConv->selectTag();
		//$this->view->itens = $tbConv->getNomeProfissionaisPorUnidade(570019);
	}

	public function buscarProfissionaisAction() {
		$this->_helper->layout->disableLayout();
		$uni_codigo = $this->_getParam("uni_codigo", false);
		$tbConi = new Application_Model_ConvenioItens();

		$this->view->dados = $tbConi->getNomeProfissionaisPorUnidade($uni_codigo)->toArray();

		$this->render("dados", NULL, TRUE);
	}

	public function carregaEspecialidadeAction() {
		$this->_helper->layout->disableLayout();
		$uni_codigo = $this->_getParam("uni_codigo", false);
		$usr_codigo = $this->_getParam("usr_codigo", false);

		$tbConi = new Application_Model_ConvenioItens();

		$this->view->dados = $tbConi->getEspecialidadeMedicoPorConvenio($uni_codigo, $usr_codigo)->toArray();

		$this->render("dados", NULL, TRUE);
	}

	public function carregaPacientesAgendadosAction() {
                
		$this->_helper->layout->disableLayout();
		$uni_codigo = $this->_getParam("uni_codigo", false);
		$usr_codigo = $this->_getParam("usr_codigo", false);
		$esp_codigo = $this->_getParam("esp_codigo", false);
		$age_data = $this->_getParam("age_data", false);
		$tbAge = new Application_Model_Agendamento();
		$this->view->dados = $tbAge->getPacientesAgendados($uni_codigo, $usr_codigo, $esp_codigo, $age_data)->toarray();
		$this->render("dados", NULL, TRUE);
	}
	
	public function imprimePacientesAgendadosAction() {
		Zend_Layout::getMvcInstance()->setLayout("relatorio");
                $usr_codigo = $this->_getParam("usr", false);
                $age_data = $this->_getParam("age", false);
                $tbUsr = new Application_Model_Usuarios();
                $usr_nome = $tbUsr->getInfoUsr($usr_codigo);
                $this->view->params = serialize(array("titulo"=>"Atendente","dados"=>"$usr_nome->usr_nome  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Data:</strong> $age_data"));
		$uni_codigo = $this->_getParam("uni", false);
		$esp_codigo = $this->_getParam("esp", false);
		$pac = 1;
		$tbAge = new Application_Model_Agendamento();
		$this->view->dados_pac = $tbAge->getPacientesAgendados($uni_codigo, $usr_codigo, $esp_codigo, $age_data)->toArray();
		//$this->render("dados");
	}

	public function cancelarOuFaltaAgendamentoAction() {
		$this->_helper->layout->disableLayout();
		$tbAge = new Application_Model_Agendamento();
		$age_codigos = $this->_getParam("age_codigos", false);
		$motivo = $this->_getParam("motivo", false);
		//die($age_codigos . "-".$motivo);
		if ($motivo != 'C') {
			foreach ($age_codigos as $age_codigo) {
				$dados = array("age_codigo" => $age_codigo,
					"age_atendido" => $motivo);
				$tbAge->salvar($dados);
			}
		} else {
			foreach ($age_codigos as $age_codigo) {
				// echo "age:".$age_codigo;
				$tbAge->excluir($age_codigo);
			}
		}
		//  die('apara');
		// $this->view->dados = $tbAge->getPacientesAgendados($uni_codigo, $usr_codigo, $esp_codigo, $age_data)->toarray();
		//$this->view->dados = $age_codigos;
		$this->render("dados", NULL, TRUE);
	}

	public function alteraSituacaoAction() {
		$this->_helper->layout->disableLayout();
		$age_codigo = $this->_getParam("age_codigo", false);
		$tbAge = new Application_Model_Agendamento();
		$situacao = $tbAge->getAgendamento($age_codigo)->age_atendido;
		if ($situacao == "S") {
			$altera = "N";
		} else {
			$altera = "S";
		}
		$tbAge->alteraSituacao($altera, $age_codigo);
		$this->view->dados = $altera;

		$this->render("dados", NULL, TRUE);
	}

}

