<?php

class Agendamento_AgendamentoController extends Zend_Controller_Action {

    public function historicoAction(){
            $this->_helper->layout->disableLayout();

            $usu_codigo = $this->_getParam("usu", FALSE);
            if(!$usu_codigo)
                    return $this->_redirect ("/agendamento/index");

            $tbAge = new Application_Model_Agendamento();
            $this->view->itens = $tbAge->getHistoricoPorUsuario($usu_codigo);
    }
    
    public function selecionarDataAction(){
        $this->_helper->layout->disableLayout();

        $usr_codigo = $this->_getParam("prof", FALSE);
        $coni_codigo = $this->_getParam("coni_codigo", FALSE);
        $this->view->data_inicial = $this->_getParam("de", date("Y-m-d"));
        
        if(!$usr_codigo)
            return $this->_helper->viewRenderer->setNoRender(true);


        $tbAge = new Application_Model_Agendamento();
        $tbConI = new Application_Model_ConvenioItens();
        //$coni_codigo = $tbConI->getItemPorUsuarios($usr_codigo,$conv_codigo);
        $this->view->data_final = $tbAge->calculaDataFinal($this->view->data_inicial);
        $this->view->coni_codigo = $coni_codigo;
        $this->view->vagas = $tbAge->getVagas($coni_codigo, $this->view->data_inicial, $this->view->data_final);
        $this->view->nomeProf = $tbConI->getNomeProfissional($coni_codigo);
                
    }
    
    public function selecionarHorarioAction(){
        $this->_helper->layout->disableLayout();

        //$usr_codigo = $this->_getParam("prof", FALSE);
        $coni_codigo = $this->_getParam("coni_codigo", FALSE);
        $conv_codigo = $this->_getParam("conv_codigo", FALSE);
        $this->view->data_inicial = $this->_getParam("ds", date("Y-m-d"));
        
        if(!$coni_codigo){
                return $this->_helper->viewRenderer->setNoRender(true);
        }
        $tbAge = new Application_Model_Agendamento();
        $tbConI = new Application_Model_ConvenioItens();
        $tbConH = new Application_Model_ConvenioHorarios();
        $tbFun = new Application_Model_Funcoes();
        //$coni_codigo = $tbConI->getItemPorUsuarios($usr_codigo,$conv_codigo);
        $tbGrap = new Application_Model_GradePeriodo();
        $horarios = $tbGrap->getHorariosDia($coni_codigo, $this->view->data_inicial);
        $quantidades = $tbFun->calculaQuantidadePorIntervalo($horarios,$coni_codigo,$this->view->data_inicial);
        $distribuicao = $tbFun->distribuicao($quantidades,$horarios,$coni_codigo,$this->view->data_inicial);
        $this->view->distribuicao = $distribuicao;
        $encaixe = $tbConI->busca($coni_codigo);
        $this->view->encaixe = $encaixe->coni_encaixe;
        
                
    }
    
    public function buscarEspecialidadePorConiAction(){
        $this->_helper->layout->disableLayout();
        
        $coni_codigo = $this->_getParam("coni_codigo", FALSE);
        
        $tbConI = new Application_Model_ConvenioItens();
        $this->view->dados = $tbConI->getEspecialidadeConvenioItens($coni_codigo)->toArray();
       
        return $this->render("dados", NULL, TRUE);
        
                
    }
    
    public function salvarAction(){
        $tbAge = new Application_Model_Agendamento();
        $tbEsp = new Application_Model_Especialidade();
        $tbUsr = new Application_Model_Usuarios();
        $tbConv = new Application_Model_Convenio();

        $session = new Zend_Session_Namespace();
        $session->dados =  $this->_request->getPost();
        $horario_de_encaixe = $this->_request->getPost("horario_de_encaixe", FALSE);
        if($horario_de_encaixe == "S"){
            $uni_codigo = $tbUsr->getUsrAtual();
            if($uni_codigo->uni_codigo != $this->_request->getPost("codigo_convenio", FALSE)){
                 $unidade = $tbConv->getUnidadePorConvenio($this->_request->getPost("codigo_convenio", FALSE));
                 $this->view->dados = array("success"=>FALSE, "titulo"=>"Aviso", "mensagem"=>"As vagas de encaixe são de uso exclusivo da ".$unidade->uni_desc);
                 return $this->render("dados", NULL, TRUE);
            }
            
            if($this->_request->getPost("age_data", FALSE) != date("Y-m-d")){
                $this->view->dados = array("success"=>FALSE, "titulo"=>"Aviso", "mensagem"=>"As vagas de encaixe só podem ser utilizadas no dia da consulta!");
                return $this->render("dados", NULL, TRUE);
            }
        }
        
        $dados = array(
                    "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
                    "age_paciente" => $this->_request->getPost("usu_nome", FALSE),
                    "age_horario" => $this->_request->getPost("age_horario", FALSE),
                    "age_data" => $this->_request->getPost("age_data", FALSE),
                    "coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
                    "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
                    "coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
                    "uni_codigo" => $this->_request->getPost("codigo_convenio", FALSE),
                    "med_codigo" => $this->_request->getPost("usr_codigo_medico", FALSE),
                    "esp_codigo" => $tbEsp->getEspecialidadePorConvenio($this->_request->getPost("esp_codigo", FALSE))->esp_codigo,
                    "age_atendido"=>"N",
                    "dt_cadastro"=>"NOW()",
                    "tpf_codigo" => $this->_request->getPost("tpf_codigo", FALSE));
        
        
        $tem_agendamento = $tbAge->verificaSeTemAgendamento($this->_request->getPost("coni_codigo", FALSE),$this->_request->getPost("age_data", FALSE),$this->_request->getPost("usu_codigo", FALSE));
        $espConfig = $this->_request->getPost("esp_codigo_config");
        //echo "<pre>".print_r($tbEsp->getEspecialidade($espConfig)->toArray());die();
      // die($tbEsp->getEspecialidade($espConfig));
        if($tbEsp->getEspecialidade($espConfig)->esp_mais_agendamento){
            $this->salvaOuNao($dados);
        }else{
            if($tem_agendamento->quantidade > 0){
                $this->view->dados = array("success"=>FALSE, "titulo"=>"Aviso", "mensagem"=>"Este paciente já possui agendamento para esta data");
            }else{
                 $this->salvaOuNao($dados);
            }
        }
        return $this->render("dados", NULL, TRUE);
    }
    public function salvaOuNao(array $dados){
        $tbAge = new Application_Model_Agendamento();
        
        try {
            $age_codigo = $tbAge->salvar($dados);
            $this->view->dados = array("success"=>TRUE,"age_codigo"=>$age_codigo);
            //colocar mais informações na sessao


        }catch (Zend_Validate_Exception $exc) { // Exceção de validação
            $this->view->dados = array("success"=>FALSE, "titulo"=>"Erro", "mensagem"=>$exc->getMessage(), "code"=>$exc->getCode());

        }
    }
    public function imprimirAction(){
        $age_codigo = $this->_getParam("age", FALSE);
        $this->_helper->layout->setLayout("modelo-print");

        $tbAge = new Application_Model_Agendamento();
        $age = $tbAge->getAgendamento($age_codigo);

        $this->view->codigo = $age_codigo;
        $this->view->usu_codigo = $age->usu_codigo;
        $this->view->age = $age;
    }
    
    
    
}

