<?php

class Atendimento_AtendimentoController extends Zend_Controller_Action {

	public function init() {
            set_time_limit (600000);
            $this->view->headLink()->appendStylesheet($this->view->baseUrl().'/public/css/atendimento/atendimento/index.css','all');
            $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.easing.min.js');
            $this->_helper->layout->setLayout("simples");
            $tipoDeFicha = Application_Model_Agendamento::usuEmAberto()->tpf_codigo;
            $this->view->tipo_ficha = $tipoDeFicha;
            if($this->view->tipo_ficha == 1){
               $this->view->ficha_name = "fim_";
            }else if($this->view->tipo_ficha == 2){
               $this->view->ficha_name = "fii_";
            }else if($this->view->tipo_ficha == 3){
                $this->view->ficha_name = "fica_";
            }else if($this->view->tipo_ficha == 4){
                $this->view->ficha_name = "fid_";
            }else if($this->view->tipo_ficha == 5){
                $this->view->ficha_name = "fip_";
            }else if($this->view->tipo_ficha == 6){
                $this->view->ficha_name = "fims_";
            }
        }

	public function indexAction() {
            $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.easing.min.js');
            $this->_helper->layout->setLayout("simples");
            $dadosFicha = $this->getDadosFichaAction();
            if (!empty($dadosFicha)) {
                $this->view->dados = $dadosFicha;
            }    
        }
        
        public function historicoDeFichasAction(){
            // Verifica tipos de ficha que tem o usuário
            /*$tbAteSocial = new Application_Model_AtendimentoSocial();
            $usuCodigo =  Application_Model_Agendamento::usuEmAberto()->usu_codigo;
            $dadosFicha = $tbAteSocial->getTiposDeFichasPorUsuario($usuCodigo)->toArray();
            $dadosContFicha = array();
            foreach ($dadosFicha as $dados) {
                $inst = $this->verificaObjeto($dados["tpf_codigo"]);
                $dadosContFicha[] = $inst->getDadosFicha($usuCodigo)->toArray();
            }
            echo "<pre>";
            print_r($dadosContFicha);
            echo "</pre>";*/
        }
        
        public function getDadosFichaAction(){
            $tbAge = new Application_Model_Agendamento(); 
            $tipoDeFicha = $tbAge->usuEmAberto()->tpf_codigo;
            $usuCodigo = $tbAge->usuEmAberto()->usu_codigo;
            $inst = $this->verificaObjeto($tipoDeFicha);
            $dadosFicha = $inst->getDadosFicha($usuCodigo);
            return $dadosFicha;
        }
        
        public function formVidaEscolarAction(){
            
        }
        
        public function formVidaProfissionalAction(){
            
        }
        
        public function formVidaFamiliarSocialAction(){
            
        }
        
        public function formSituacaoEconomicaSocialAction(){
            
        }
        
        public function formFormaDeAcessoAction(){
            
        }
        
        public function formSaudeAction(){
            
        }
        
        public function formCotidianoFamiliarSocialAction(){
            
        }
        
        public function formMedidaSocioeducativaAction(){
            
        }
        
        public function salvarAction(){
            $arr = $this->_request->getPost();
            if (!empty($arr)) {
                unset($arr["submit"]); 
                unset($arr["names"]);
                unset($arr["no_ocupacao"]); 
                foreach($arr as $ind => $val){
                    if($val == "" || $val == NULL){
                        unset($arr[$ind]);
                    }
                }
                $inst = $this->verificaObjeto($arr["tipo_ficha"]);
                $tbAge = new Application_Model_Agendamento(); 
                $arr["usu_codigo"] = $tbAge->usuEmAberto()->usu_codigo;
                $arr["age_codigo"] = $tbAge->usuEmAberto()->age_codigo;
                try{
                    $inst->salvar($arr);
                    $this->view->dialog = array("Confirmação", "Dados salvo com sucesso!", 300, 140);
                }catch (Zend_Validate_Exception $exc){
                    throw new Zend_Validate_Exception($exc->getMessage());
                }
            }
            $this->_redirect("atendimento/atendimento");
        }
        
        public function verificaObjeto($tipo_ficha){
            switch ($tipo_ficha) {
                case 1:
                    $tbFicha = new Application_Model_FichaMulher();
                    break;
                case 2:
                    $tbFicha = new Application_Model_FichaIdoso();
                    break;
                case 3:
                    $tbFicha = new Application_Model_FichaCriancaAdolescente();
                    break;
                case 4:
                    $tbFicha = new Application_Model_FichaDeficiente();
                    break;
                case 5:
                    $tbFicha = new Application_Model_FichaPopulacaoRua();
                    break;
                case 6:
                    $tbFicha = new Application_Model_FichaMedidaSocioEducativa();
                    break;
            }
            return $tbFicha;
                
        }
        
        public function formRelPacientesAtendidosAction(){
            Zend_Layout::getMvcInstance()->setLayout("layout");
            $this->view->title = "Relatório de Atendimento Básico";
            $tbTpf = new Application_Model_TipoFicha();
            $this->view->tpf = $tbTpf->getTiposDeFicha();
        }
        
        public function relPacientesAtendidosAction(){
            $this->view->headLink()->appendStylesheet($this->view->baseUrl().'/public/css/relatorio.css','all');
            Zend_Layout::getMvcInstance()->setLayout("relatorio");
            $this->view->title = "Atendimento por Atendente";
            $usrCodigo = $this->_request->getPost("usr_codigo");
            $uniCodigo = $this->_request->getPost("uni_codigo");
            $uniDesc = $this->_request->getPost("uni_desc");
            $tipoAtend = $this->_request->getPost("tipo_atend");
            $dtInicial = $this->_request->getPost("data_inicial");
            $dtFinal = $this->_request->getPost("data_final");
            $tbAte = new Application_Model_Atendimento();
            $tbUsr = new Application_Model_Usuarios();
            $array = array('uni_desc'=> $uniDesc);
            if ($dtInicial)
                $array["data_inicial"] = $dtInicial;
            if ($dtFinal)
                $array["data_final"] = $dtFinal;
            $this->view->params = serialize($array);
            $this->view->dados = $tbAte->relPacientesAtendidos($usrCodigo, $uniCodigo, $tipoAtend, $dtInicial, $dtFinal);
        }

}

