<?php

class Atendimentocras_AtendimentoBasicoController extends Zend_Controller_Action {

    public function init() {
      //$this->_helper->acl->allow(NULL,array("buscar"));
    }

    public function indexAction() {
      $this->view->title = "ATENDIMENTO BÁSICO";
      $this->_helper->layout->setLayout("simples");
      $tbAteBasCras = new Application_Model_AsAtendimentoBasicoCras();
      $usrLogin = $this->_request->getParam("id_login");
      $tbUsr = new Application_Model_Usuarios();
      $this->view->usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;

      //Verifica o tipo da unidade logada
      $tbUni = new Application_Model_Unidade();
      $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;

      $this->view->dados = $tbAteBasCras->getDados($tipoUnidade, $this->getDadosUsuarioLogado($usrLogin));
    }

    public function formAction() {
      $this->_helper->layout->disableLayout();
      $tbAteBasCras = new Application_Model_AsAtendimentoBasicoCras();
      $tbAteTipo = new Application_Model_AsAtendimentoTipo();
      $tbGruAce = new Application_Model_GrupoAcessoUsuarios();
      $usrCodigo = $this->_request->getParam("usr_codigo");
      $asabCodigo = $this->_request->getParam("asab_codigo");
      if ($asabCodigo) {
        $this->view->dados = $tbAteBasCras->getDadosPorId($asabCodigo);

        $tbMot = new Application_Model_MotivoAtendimento();
        $motivos = $tbMot->getMotivoPorAsab($asabCodigo);
        if (count($motivos) > 0) {
          $this->view->motivos = $motivos;
        }
      }

      $asatCodigo = $this->view->dados->asat_codigo;
      $this->view->acessoCursoSup = $tbGruAce->verificaAcessoCursoSuperior($usrCodigo);
      $this->view->selectTipoAte = $tbAteTipo->selectTag($asatCodigo);
    }

    public function formSalvarAction() {
      $this->_helper->layout->disableLayout();
      try {
        $tbAteBas = new Application_Model_AsAtendimentoBasicoCras();
        $asabCodigoPost = $this->_request->getPost("asab_codigo");
        $dados = array_map('strtoupper',$_POST);
        // Removendo dados não utilizado
        unset($dados["uni_desc"]);
        unset($dados["usr_nome"]);
        unset($dados["usu_nome"]);
        unset($dados["asam_codigo"]);
        unset($dados["asam_nome"]);
        unset($dados["usu_anonimo"]);
        // Valida Edição
        if ($asabCodigoPost == "") {
          unset($dados["asab_codigo"]);
        }
        $asabCodigo = $tbAteBas->salvar($dados);
        // Validação se cidadão possui familia no Prontuario Suas
        $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();

        $usuCodigo = $this->_request->getPost("usu_codigo");
        $asatCodigo = $this->_request->getPost("asat_codigo");

        $aspsCodigo = $tbAspsu->getDadosPorCidadao($usuCodigo)->asps_codigo;
        if ($aspsCodigo && $asabCodigoPost == "") {
          // Busca dados do tipo de atendimento
          $tbAteTipo = new Application_Model_AsAtendimentoTipo();
          $dadosAteTipo = $tbAteTipo->getDadosPeloCodigo($asatCodigo);
          $dadosPront = array(
            "asps_codigo" => $aspsCodigo,
            "usr_codigo" => $this->_request->getPost("usr_codigo"),
            "usu_codigo" => $usuCodigo,
            "aspsrs_descricao" => $dadosAteTipo->asat_nome,
            "aspsrs_codigo_desc" => $dadosAteTipo->asat_codigo_num,
          );
          $tbAsRegSim = new Application_Model_AspsRegistroSimplificado();
          $tbAsRegSim->salvar($dadosPront);
        }

        $tbMot = new Application_Model_MotivoAtendimento();

        if(isset($asabCodigo)) {
          $tbMot->excluirMotivosAtendimento($asabCodigo);
        }
        $dadosMotAte = $this->_request->getPost("motivos",FALSE);
        foreach ($dadosMotAte as $motAte) {
          $arrayDados = array(
            "asam_codigo" => $motAte,
            "asab_codigo" => $asabCodigo
          );
          $tbMot->salvar($arrayDados);
        }

        $this->view->dados = $asabCodigo;
      } catch (Exception $exc) {
        $this->view->dados = $exc->getMessage();
      }
      return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction() {
      $this->_helper->layout->disableLayout();
      $tbAteBas = new Application_Model_AsAtendimentoBasicoCras();
      $busca = $this->_request->getPost("busca");

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;
	    $tbUsr = new Application_Model_Usuarios();
	    $usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;
      $this->view->dados = $tbAteBas->pesquisaDados($busca, $tipoUnidade, $usr_codigo)->toArray();
      return $this->render("dados", NULL, TRUE);
    }

    public function getDadosUsuarioLogado($usrLogin) {
      $tbUsr = new Application_Model_Usuarios();
      return $tbUsr->getDadosPeloLogin($usrLogin)->usr_codigo;
    }

    public function formCadastroMotivoAction() {
      $this->_helper->layout->disableLayout();
      // Utilizado para setar em qual campo jogará os valores depois de salvo
      $this->view->idCodigo = $this->_request->getParam("idCodigo");
      $this->view->idDesc = $this->_request->getParam("idDesc");
      $this->view->idAlert = $this->_request->getParam("idAlert");
    }

    public function trataValor($valor) {
      return (!empty($valor) ? mb_strtoupper($valor, "UTF-8") : NULL);
    }

    public function formCadastroMotivoGeralSalvarAction() {
      try {
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $dados = array(
            "asam_nome" => $this->trataValor($this->_request->getPost("asam_nome"))
        );
        $asaCodigo = $tbAte->salvar($dados);
        $this->view->dados = $tbAte->getDadosPeloCodigo($asaCodigo)->toArray();
        return $this->render("dados", NULL, TRUE);
      } catch (Exception $exc) {
        $exc->getMessage();
      }
    }
}
