<?php

class Atendimentocras_AtendimentoColetivoController extends Zend_Controller_Action {
    
    public function init(){
        
    }
    
    public function indexAction(){
        $this->_helper->layout->setLayout("simples");
        $tbAsag = new Application_Model_AsAtendimentocolGrupo();

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;

        $this->view->dados = $tbAsag->getDados($tipoUnidade);
    }
    
    /*---------------------------------------------------------------------/
     * DADOS GRUPO DE ATENDIMENTO COLETIVO                                 /  
     *--------------------------------------------------------------------*/
    
    public function formGrupoAction() {
        $this->_helper->layout->disableLayout();
        $asagCodigo = $this->_request->getParam("asag_codigo");
        if ($asagCodigo){
            $tbAsag = new Application_Model_AsAtendimentocolGrupo();
            $this->view->dados = $tbAsag->getDadosGrupo($asagCodigo);
            $programa_projeto = $this->view->dados->asap_codigo;
            $unidade_realizacao = $this->view->dados->asau_codigo;
        }
	    $tbAsAteProg = new Application_Model_AsAtendimentocolProgramas();
	    $this->view->selectProgs = $tbAsAteProg->selectTag($programa_projeto);
	    $tbAsAteUni = new Application_Model_AsAtendimentocolUnidades();
	    $this->view->selectUnidades = $tbAsAteUni->selectTag($unidade_realizacao);
    }
    
    public function formGrupoSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $dados = $_POST;
            unset($dados["usr_nome"]);
            unset($dados["uni_desc"]);
            $tbAteGru = new Application_Model_AsAtendimentocolGrupo();
            $asagCodigo = $tbAteGru->salvar($dados);
            $this->view->dados = $asagCodigo; 
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function formGrupoExcluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbAsag = new Application_Model_AsAtendimentocolGrupo();
            $asagCodigo = $this->_request->getPost("asag_codigo");
            $asagCodigo = $tbAsag->excluir($asagCodigo);
            $this->view->dados = $asagCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function buscaDadosGrupoAction() {
        $tbAteGru = new Application_Model_AsAtendimentocolGrupo();
        $term = $this->_getParam("term",FALSE);

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;

        $all = $tbAteGru->buscaDados($term, $tipoUnidade);
        
        $out = array();
        foreach ($all as $gru) {
            $data = $gru->toArray();
            
            $out [] = array(
                "id" => $gru->asag_codigo,
                "label" => $gru->asag_titulo,
                "unidade" => $gru->uni_desc,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("asag_codigo" => "0", "asag_titulo" => "")
            );
        }
        
        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
    
    /*---------------------------------------------------------------------/
     * FIM DADOS GRUPO DE ATENDIMENTO COLETIVO                             /  
     *--------------------------------------------------------------------*/
    
    /*---------------------------------------------------------------------/
     * PROFISSIONAIS RESPONSÁVEL                                           /  
     *--------------------------------------------------------------------*/
    
    /*---------------------------------------------------------------------/
     * FIM PROFISSIONAIS RESPONSÁVEL                                       /  
     *--------------------------------------------------------------------*/
    
    /*---------------------------------------------------------------------/
     * CIDADÃOS PARTICIPANTES                                              /  
     *--------------------------------------------------------------------*/
    
    public function cidadaosPartAction(){
        $this->_helper->layout->disableLayout();
        $asagCodigo = $this->_request->getParam("asag_codigo");
        $tbAtePart = new Application_Model_AsAtendimentocolParticipantes();
        $this->view->dados = $tbAtePart->getDados($asagCodigo);
    }
    
    public function formCidadaoGrupoAction(){
        $this->_helper->layout->disableLayout();
        $tbUsu = new Application_Model_Usuario();
        $usuCodigo = $this->_request->getParam("usu_codigo");
        $this->view->dadosCid = $tbUsu->getDadosCidadao($usuCodigo);
        $asagCodigo = $this->_request->getParam("asag_codigo");
        $this->view->asagCodigo = $asagCodigo; 
        $asaparCodigo = $this->_request->getParam("asapar_codigo");
        if ($asaparCodigo) {
            $tbAtePart = new Application_Model_AsAtendimentocolParticipantes();
            $this->view->dados = $tbAtePart->getDadosPorId($asaparCodigo);
        }
    }
    
    public function formCidadaoGrupoSalvarAction(){
        $this->_helper->layout->disableLayout();
        $dados = array(
            "asapar_codigo" => $this->_request->getPost("asapar_codigo"),
            "asag_codigo" => $this->_request->getPost("asag_codigo"),
            "usu_codigo" => $this->_request->getPost("usu_codigo"),
            "asapar_dtingresso" => $this->_request->getPost("asapar_dtingresso"),
            "asapar_dtsaida" => $this->_request->getPost("asapar_dtsaida"),
            "asapar_status" => ($this->_request->getPost("asapar_dtsaida")!="" ? 'f' : 't')
        );
        try{
            $tbAtePart = new Application_Model_AsAtendimentocolParticipantes();
            $asaparCodigo = $tbAtePart->salvar($dados);
            $this->view->dados = $asaparCodigo;
        } catch (Exception $ex) {
            $this->view->dados = $ex->getMessage();
        }
        return $this->render("dados",NULL,TRUE);
    }
    
    /*---------------------------------------------------------------------/
     * FIM CIDADÃOS PARTICIPANTES                                          /  
     *--------------------------------------------------------------------*/
    
    /*---------------------------------------------------------------------/
     * REUNIÕES                                                     /  
     *--------------------------------------------------------------------*/
    
    public function reunioesAction(){
        $this->_helper->layout->disableLayout();
        $asagCodigo = $this->_request->getParam("asag_codigo");
        $tbAteEnc = new Application_Model_AsAtendimentocolEncontros();
        $this->view->dados = $tbAteEnc->getDados($asagCodigo);
    }
    
    public function reunioesDadosAction(){
        $this->_helper->layout->disableLayout();
        $asaeCodigo = $this->_request->getParam("asae_codigo");
        $this->view->asaeCodigo = $asaeCodigo;
        $tbAteEnc = new Application_Model_AsAtendimentocolEncontros();
        $this->view->dados = $tbAteEnc->getDadosPorId($asaeCodigo);
    }
    
    public function formReuniaoAction() {
        $this->_helper->layout->disableLayout();
        $asagCodigo = $this->_request->getParam("asag_codigo");
        $this->view->asagCodigo = $asagCodigo;
        $tbAsEst = new Application_Model_AsEstabelecimentos();
        $this->view->selectEst = $tbAsEst->selectTag();
        $tbAsAteUni = new Application_Model_AsAtendimentocolUnidades();
        $this->view->selectUnidades = $tbAsAteUni->selectTag();
        $asaeCodigo = $this->_request->getParam("asae_codigo");
        if ($asaeCodigo) {
            $tbAteEnc = new Application_Model_AsAtendimentocolEncontros();
            $this->view->dados = $tbAteEnc->getDadosPorId($asaeCodigo);
        }
    }
    
    public function formReuniaoSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $dados = array_map("strtoupper", $_POST);
            // Salvando dados da reunião ou encontro
            $tbAteEnc = new Application_Model_AsAtendimentocolEncontros();
            $asaeCodigo = $tbAteEnc->salvar($dados);
            $asaeCodigoPost = $this->_request->getPost("asae_codigo");
            // Incluindo participantes do grupo no encontro
            if ($asaeCodigoPost=="") {
                $asagCodigo = $this->_request->getPost("asag_codigo");
                $this->adicionaCidadaoReuniaoAction($asagCodigo,$asaeCodigo);
            }
            $this->view->dados = $asaeCodigo; 
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function adicionaCidadaoReuniaoAction($asagCodigo=FALSE,$asaeCodigo=FALSE) {
        $this->_helper->layout->disableLayout();
        $tbAtePart = new Application_Model_AsAtendimentocolParticipantes();
        $cidsPart = $tbAtePart->getCidadaosPorGrupo($asagCodigo);
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        if (count($cidsPart)>0) {
            foreach ($cidsPart as $val) {
                $qtdCid = $tbAteEnch->confereCidadaoReuniao($val->usu_codigo,$asaeCodigo)->qtdCid;
                if ($qtdCid==0){
                    $dados = "";
                    $dados = array(
                        "asae_codigo" => $asaeCodigo, 
                        "usu_codigo" => $val->usu_codigo,
                        "asaeh_presenca" => 'f'
                    );
                    $tbAteEnch->salvar($dados);
                }    
            }
        }
    }
    
    public function atualizaCidadaosReuniaoAction() {
        $this->_helper->layout->disableLayout();
        $asagCodigo = $this->_request->getPost("asag_codigo");
        $asaeCodigo = $this->_request->getPost("asae_codigo");
        $tbAtePart = new Application_Model_AsAtendimentocolParticipantes();
        $cidsPart = $tbAtePart->getCidadaosPorGrupo($asagCodigo);
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        if (count($cidsPart)>0) {
            foreach ($cidsPart as $val) {
                $qtdCid = $tbAteEnch->confereCidadaoReuniao($val->usu_codigo,$asaeCodigo)->qtdCid;
                if ($qtdCid==0){
                    $dados = "";
                    $dados = array(
                        "asae_codigo" => $asaeCodigo, 
                        "usu_codigo" => $val->usu_codigo,
                        "asaeh_presenca" => 'f'
                    );
                    $tbAteEnch->salvar($dados);
                }    
            }
        }
        $this->view->dados = "ok";
        return $this->render("dados",NULL,TRUE);
    }
    
    public function reunioesParticipantesAction(){
        $this->_helper->layout->disableLayout();
        $asaeCodigo = $this->_request->getParam("asae_codigo");
        $this->view->asaeCodigo = $asaeCodigo;
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        $this->view->dados = $tbAteEnch->getDados($asaeCodigo);
    }
    
    public function reunioesProfissionaisAction(){
        $this->_helper->layout->disableLayout();
        $asaeCodigo = $this->_request->getParam("asae_codigo");
        $this->view->asaeCodigo = $asaeCodigo;
        $tbRespEnc = new Application_Model_AsAtendimentocolRespencontro();
        $this->view->dados = $tbRespEnc->getDados($asaeCodigo);
    }
    
    public function adicionaProfissionalReuniaoAction(){
        $this->_helper->layout->disableLayout();
        $dados = array(
            "asae_codigo" => $this->_request->getPost("asae_codigo"),
            "usr_codigo" => $this->_request->getPost("usr_codigo")
        );
        try{
            $tbRespEnc = new Application_Model_AsAtendimentocolRespencontro();
            $asarCodigo = $tbRespEnc->salvar($dados);
            $this->view->dados = $asarCodigo;
        } catch (Exception $ex) {
            $this->view->dados = $ex->getMessage();
        }
        return $this->render("dados",NULL,TRUE);
    }
    
    public function excluirProfissionalReuniaoAction(){
        $asarCodigo = $this->_request->getPost("asar_codigo");
        $tbRespEnc = new Application_Model_AsAtendimentocolRespencontro();
        try{
            $tbRespEnc->excluir($asarCodigo);
        } catch (Exception $ex) {
            $ex->getMessage();
        }
    }
    
    public function reunioesComparecimentosAction(){
        $this->_helper->layout->disableLayout();
        $asaehCodigoPost = $this->_request->getParam("asaeh_codigo");
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        $statusPart = $tbAteEnch->getStatusParticipante($asaehCodigoPost)->asaeh_presenca;
        if ($statusPart == 1) { $novoStatus = "f"; } else { $novoStatus = "t"; } 
        $dadosAtu = array(
            "asaeh_codigo" => $asaehCodigoPost,
            "asaeh_presenca" => $novoStatus
        );
        $asaehCodigo = $tbAteEnch->salvar($dadosAtu);
        // Registra Atendimento Simplificado de acordo com o status
        if ($novoStatus=="t") {
            $this->registraAtendimentoSimp($asaehCodigo);
        } else {
            $this->excluiAtendimentoSimp($asaehCodigo);
        }
        $this->view->dados = $novoStatus;
        return $this->render("dados",NULL,TRUE);
    }
    
    public function registraAtendimentoSimp($asaehCodigo=FALSE){
        // Pega os dados do cidadão e do encontro para registrar atendimento simplificado
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        $dadosEncCid = $tbAteEnch->getDadosPorId($asaehCodigo);
        // Confere se cidadão pertence a uma familia 
        $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
        $aspsCodigo = $tbAspsu->getDadosPorCidadao($dadosEncCid->usu_codigo)->asps_codigo;
        if ($aspsCodigo) {
            $dadosPront = array(
                "asps_codigo" => $aspsCodigo,
                "usr_codigo" => $dadosEncCid->usr_codigo,
                "usu_codigo" => $dadosEncCid->usu_codigo,
                "aspsrs_data_atendimento" => $dadosEncCid->asae_dtinicio,
                "aspsrs_descricao" => ($dadosEncCid->asap_num == 5 ? "ATENDIMENTO EM ATIVIDADE COLETIVA DE CARÁTER CONTINUADO" : 
                        "PARTICIPAÇÃO EM ATIVIDADE DE CARÁTER NÃO CONTINUADO"),
                "aspsrs_codigo_desc" => ($dadosEncCid->asap_num == 5 ? "2" : "1"),
            );
            $tbAsRegSim = new Application_Model_AspsRegistroSimplificado();
            $tbAsRegSim->salvar($dadosPront);
        }
    }
    
    public function excluiAtendimentoSimp($asaehCodigo=FALSE){
        // Pega os dados do cidadão e do encontro para registrar atendimento simplificado
        $tbAteEnch = new Application_Model_AsAtendimentocolEncontrosHist();
        $dadosEncCid = $tbAteEnch->getDadosPorId($asaehCodigo);
        // Confere se cidadão pertence a uma familia 
        $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
        $aspsCodigo = $tbAspsu->getDadosPorCidadao($dadosEncCid->usu_codigo)->asps_codigo;
        // Pega o código do atendimento simplificado para exclusão
        $tbAspsrs = new Application_Model_AspsRegistroSimplificado();
        $aspsrsCodigo = $tbAspsrs->getIdParametros($dadosEncCid, $aspsCodigo)->aspsrs_codigo;
        $tbAspsrs->excluir($aspsrsCodigo);
    }
    
    /*---------------------------------------------------------------------/
     * FIM REUNIÕES                                                 /  
     *--------------------------------------------------------------------*/
    
}

