<?php

// Referênca Tabela: Usuario
// Motivo: Seguir a mesma estrutura do Saúde e realizar possíveis Iterações
class Atendimentocras_AtendimentomotivoController extends Zend_Controller_Action {
    
    public function init(){
    
    }
    
    public function indexAction(){
        $this->_helper->Layout->setLayout("simples");
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $this->view->dados = $tbAte->getDados();
    }
    
    public function buscaGeralAction() {
        /*
         * Funcao busca cidadao, por nome cpf e nome da mae, nessa ordem de prioridade
         */
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $term = $this->_getParam("term",FALSE);
        $all = $tbAte->buscaMotivosGeral($term);
        
        //Busca por nome fica em prioridade, sendo a primeira a alimentar o array
        $out = array();
        
        
        foreach ($all as $asam) {
            
            //$data = $asam->toArray();
            
            $out [] = array(
                "id"    => $asam->asam_codigo,
                "label" => $asam->asam_nome,
                "data"  => $data
            );
        }

        //Se busca vier vazia, retorna essa resposta
        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("asam_codigo" => "0", "asam_nome" => "")
            );
        }
        
        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
    
    public function buscaAction() {
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $term = $this->_getParam("term",TRUE);
        
        $all = $tbAte->getDadosPorMotivoNome(FALSE,$term);
        $out = array();
        $data = $all->toArray();
        
        foreach ($data as $asam) {
            $out [] = array(
                "id"    => $asam["asam_codigo"],
                "label" => $asam["asam_nome"],
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id"    => 0,
                "label" => "Nenhum item encontrado",
                "data"  => array("asam_codigo" => "0", "asam_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
    
    
    public function formCadastroAction(){
        $this->_helper->layout->disableLayout();
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $asamCodigo = $this->_request->getParam("asam_codigo");
        if ($asamCodigo)
            $this->view->dados = $tbMot->getDadosMotivo($asamCodigo);
    }
    
    public function formCadastroSalvarAction(){
        $this->_helper->layout->disableLayout();
        try{
            $tbAte = new Application_Model_AsAtendimentoMotivo();
            //$tbMot = new Application_Model_MotivoAtendimento();
            $dadosAtendimento = array(
                "asam_codigo" => $this->trataValor($this->_request->getPost("asam_codigo")),
                "asam_nome" => $this->trataValor($this->_request->getPost("asam_nome")),
            );
//            $dadosMotivos = array(
//                "asam_codigo" => $this->trataValor($this->_request->getPost("asam_codigo")),
//                "asab_codigo" => $this->trataValor($this->_request->getPost("asab_codigo")),
//            );
            $codAtend = $tbAte->salvar($dadosAtendimento);
            //$codMot = $tbMot->salvar($dadosMotivos);
            $this->view->dados = $codAtend;
            //$this->view->motivo = $codMot;
            return $this->render("dados",NULL,TRUE);
        } catch (Exception $ex) {
            $this->view->dados = $ex->getMessage();
            //$this->view->motivo = $ex->getMessage();
            return $this->render("dados",NULL,TRUE);
        }
    }
    
    public function validaNomeAction(){
        $this->_helper->layout->disableLayout();
        $nome = $this->trataValor($this->_request->getPost("asam_nome"));
        $asamCodigo = $this->_request->getPost("asam_codigo");
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $this->view->dados = $tbAte->validaNome($asamCodigo,$nome);
        return $this->render("dados",NULL,TRUE);
    }
    
    public function getDadosNomeAction(){
        $this->_helper->layout->disableLayout();
        $nome = $this->trataValor($this->_request->getPost("asam_nome"));
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        die($nome);
        $this->view->dados = $tbAte->getDadosPorMotivoNome($nome)->asam_codigo;
        return $this->render("dados",NULL,TRUE);
    }
    
    public function validaDadosBasicoAction(){
        $this->_helper->layout->disableLayout();
        $tbAte = new Application_Model_AsAtendimentoMotivo();
        $asamCodigo = $this->_request->getPost("asam_codigo");
        $this->view->dados = $tbAte->validaDadosBasico($asamCodigo);
        return $this->render("dados",NULL,TRUE);
    }
    
    public function trataValor($valor){
        $valorFinal = ($valor != "" ? $valor : NULL); 
        return mb_strtoupper($valorFinal,"UTF-8");
    }
    
    public function formCadastroGeralAction(){
        $this->_helper->layout->disableLayout();
        // Utilizado para setar em qual campo jogará os valores depois de salvo
        $this->view->idCodigo = $this->_request->getParam("idCodigo");
        $this->view->idDesc   = $this->_request->getParam("idDesc");
        $this->view->idAlert  = $this->_request->getParam("idAlert");
    }
    
    public function formCadastroMotivoAction(){
        $this->_helper->layout->disableLayout();
        // Utilizado para setar em qual campo jogará os valores depois de salvo
        $this->view->idCodigo = $this->_request->getParam("idCodigo");
        $this->view->idDesc   = $this->_request->getParam("idDesc");
        $this->view->idAlert  = $this->_request->getParam("idAlert");
    }
    
    public function formCadastroGeralSalvarAction(){
        try{
            $tbAte=  new Application_Model_AsAtendimentoMotivo();
            $dados = array(
                "asam_nome" => $this->trataValor($this->_request->getPost("asam_nome"))
            );
            $this->view->dados = $tbAte->salvar($dados);
            return $this->render("dados",NULL,TRUE);
        } catch (Exception $exc) {
            $exc->getMessage();
        }
    }
    
    public function pesquisaDadosAction(){
        $this->_helper->layout->disableLayout();
        $tbAte =  new Application_Model_AsAtendimentoMotivo();
        $busca = $this->_request->getPost("busca");
        $this->view->dados = $tbAte->pesquisaDados($busca)->toArray();
        return $this->render("dados",NULL,TRUE);
    }
    
    public function excluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbAte = new Application_Model_AsAtendimentoMotivo();
            $asamCodigo = $this->_request->getPost("asam_codigo");
            $asamCodigo = $tbAte->excluir($asamCodigo);
            $this->view->dados = $asamCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
}
