<?php

class Atendimentocras_BeneficiosCidadaoController extends Zend_Controller_Action {

  const SOLICITACAO_CONCESSAO_BENEFICIO_EVENTUAL = 6;

    public function init() {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.maskMoney.js');
    }

    public function indexAction() {

        $this->view->title = "BENEFÍCIOS EVENTUAIS";
        $this->_helper->layout->setLayout("simples");
        $usrLogin = $this->_request->getParam("id_login");
        $this->view->usr_codigo = $this->getDadosUsuarioLogado($usrLogin);
        $tbBenDados = new Application_Model_AsBeneficiosDados();
        $tbConf = new Application_Model_Configuracao();

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;

        $this->view->dadosBen = $tbBenDados->getDados($tipoUnidade,$this->getDadosUsuarioLogado($usrLogin));
        $this->view->mov_data_status = $tbConf->getConfig("BENEFICIO_RETROATIVO");
        $this->view->codigo = '';
    }

    public function formAction() {
        $this->_helper->layout->disableLayout();
        $asbdCodigo = $this->_request->getParam("asbd_codigo");
        if ($asbdCodigo){
            $tbBenDados = new Application_Model_AsBeneficiosDados();
            $this->view->dados = $tbBenDados->getDadosPorId($asbdCodigo);
            $tbBenItens = new Application_Model_AsBeneficiosDadosItens();
            $this->view->dadosBenItens = $tbBenItens->getDadosPorId($asbdCodigo);
	        $tbUni = new Application_Model_Unidade();
	        $this->view->acessoUsuario = $tbUni->verificaAcessoUnidade($this->view->dados->uni_codigo)->uni_codigo;
        }
        $this->view->codigo = $asbdCodigo;
        $tbBenTipo = new Application_Model_AsBeneficiosTipo();
        $this->view->selectTipoBen = $tbBenTipo->selectTag($asbtCodigo, ((!$this->view->acessoUsuario && !empty($this->view->dados->asbd_codigo)) ? 'disabled': ''));
        $tbEst = new Application_Model_AsEstabelecimentos();
        $this->view->selectEst = $tbEst->selectTag($aseCodigo, ((!$this->view->acessoUsuario && !empty($this->view->dados->asbd_codigo)) ? 'disabled': ''));
        $this->view->usr_codigo = $this->_request->getParam("usr_codigo");
        $tbConf = new Application_Model_Configuracao();
        $this->view->mov_data_status = $tbConf->getConfig("BENEFICIO_RETROATIVO");
    }

    public function formSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $asbdCodigoPost = $this->_request->getPost("asbd_codigo");
            $dados = array_map("strtoupper", $_POST);

            $this->view->codigo = $asbdCodigoPost;
            // Removendo dados não utilizado
            unset($dados["uni_desc"]);
            unset($dados["ben_nome"]);
            unset($dados["usu_nome"]);

            // Valida Edição
            if (empty($asbdCodigoPost)) {
              unset($dados["asbd_codigo"]);
            }

            try{
                $tbBenDados = new Application_Model_AsBeneficiosDados();
                $this->view->dados = $tbBenDados->salvar($dados);
            } catch (Exception $exc) {
                $this->view->dados = $exc->getMessage();
            }
            // Validação se cidadão possui familia no Prontuario Suas
            $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
            $usuCodigo = $this->_request->getPost("usu_codigo");
            $aspsCodigo = $tbAspsu->getDadosPorCidadao($usuCodigo)->asps_codigo;
            if ($aspsCodigo && $asbdCodigoPost=="") {
                $dadosPront = array(
                    "asps_codigo" => $aspsCodigo,
                    "usr_codigo" => $this->_request->getPost("usr_codigo"),
                    "usu_codigo" => $usuCodigo,
                    "aspsrs_descricao" => "Solicitação/Concessão de Benefício Eventual",
                    "aspsrs_codigo_desc" => "6",
                );
                $tbAsRegSim = new Application_Model_AspsRegistroSimplificado();
                $tbAsRegSim->salvar($dadosPront);
            }
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }

        return $this->render("dados", NULL, TRUE);
    }

    public function formSalvarItensAction(){
        $this->_helper->layout->disableLayout();
        try{
            $dados = $_POST;
            $dados["asbdi_valor"] = $this->moedaBD($dados["asbdi_valor"]);
            unset($dados["ben_nome"]);

            $tbAsBenDados = new Application_Model_AsBeneficiosDadosItens();
            $this->view->dados = $tbAsBenDados->salvar($dados);
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados",NULL,TRUE);
    }

    public function formSalvarFinalizarAction(){
      try{
        $asbdCodigo = $this->_request->getPost("asbd_codigo");
        $tbAteBas = new Application_Model_AsAtendimentoBasicoCras();
        $existeAtendimento = $tbAteBas->getAtendimentoDaConcessaoDeBeneficio($asbdCodigo);

        // soh salva atendimento quando for um novo registro e nao uma edicao
        if (empty($existeAtendimento)) {
          $dados = array_map("strtoupper", $_POST);
          $dadosAtendimento = Array
          (
            'uni_codigo' => $dados['uni_codigo'],
            'usr_codigo' => $dados['usr_codigo'],
            'usu_codigo' => $dados['usu_codigo'],
            'asab_data' => $dados['asbd_dtcadastro'],
            'asat_codigo' => self::SOLICITACAO_CONCESSAO_BENEFICIO_EVENTUAL,
            'asbd_codigo' => $dados['asbd_codigo']
          );
          $tbAteBas->salvar($dadosAtendimento);
          self::formSalvarAction();
        }
      }catch(Exception $exc){
        return $exc;
      }
    }

    public function excluirAction(){
        $this->_helper->layout->disableLayout();
        try{
            $asbdiCodigo = $this->_request->getPost("asbdi_codigo");
            $tbAsBenItens = new Application_Model_AsBeneficiosDadosItens();
            $this->view->dados = $tbAsBenItens->excluir($asbdiCodigo);
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados",NULL,TRUE);
    }

    public function pesquisaDadosAction(){
        $this->_helper->layout->disableLayout();
        $tbBenCid =  new Application_Model_AsBeneficiosDados();
        $busca = $this->_request->getPost("busca");
        //die($busca);

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;
        $tbUsr = new Application_Model_Usuarios();
        $usr_codigo = $tbUsr->getUsrAtual();
        $this->view->dados = $tbBenCid->getDadosPesquisa($busca, $tipoUnidade, $usr_codigo)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function getDadosUsuarioLogado($usrLogin){
        $tbUsr = new Application_Model_Usuarios();
        return $tbUsr->getDadosPeloLogin($usrLogin)->usr_codigo;
    }

    public function imprimirAction(){
        Zend_Layout::getMvcInstance()->setLayout("paisagem-print");
        // Dados Secretaria
        $tbSec = new Application_Model_Secretaria();
        $this->view->secretaria  = $tbSec->getDadosSec();
        $this->view->tipo_impressao = "BENEFÍCIO EVENTUAL";
        $this->view->title = "Imprimir benefício eventual";
        // Dados beneficio recebido
        $asbdCodigo = $this->_request->getParam("asbc_codigo");
        $tbBenDados = new Application_Model_AsBeneficiosDados();
        $dados = $tbBenDados->getDadosPorId($asbdCodigo);
        $this->view->dados = $dados;
        $tbBenItens = new Application_Model_AsBeneficiosDadosItens();
        $this->view->dadosItens = $tbBenItens->getDadosPorId($asbdCodigo);
        $this->view->codigoBarras = $this->view->dados->asbd_codigo;
        $idade = $this->calculaIdade($dados[usu_datanasc]);
        $this->view->idade = $idade;
    }

    public function imprimir1Action(){
        Zend_Layout::getMvcInstance()->setLayout("paisagem2-print");
        // Dados Secretaria
        $tbSec = new Application_Model_Secretaria();
        $this->view->secretaria  = $tbSec->getDadosSec();
        $this->view->tipo_impressao = "BENEFÍCIO EVENTUAL";
        $this->view->title = "Imprimir benefício eventual";
        // Dados beneficio recebido
        $asbdCodigo = $this->_request->getParam("asbc_codigo");
        $tbBenDados = new Application_Model_AsBeneficiosDados();
        $dados = $tbBenDados->getDadosPorId($asbdCodigo);
        $this->view->dados = $dados;
        $tbBenItens = new Application_Model_AsBeneficiosDadosItens();
        $this->view->dadosItens = $tbBenItens->getDadosPorId($asbdCodigo);
        $this->view->codigoBarras = $this->view->dados->asbd_codigo;
        $idade = $this->calculaIdade($dados[usu_datanasc]);
        $this->view->idade = $idade;
    }


    public function beneficiosFamiliaAction() {
        $this->_helper->layout->disableLayout();
        $usuCodigo = $this->_request->getParam("usu_codigo");
        // Busca prontuário suas cidadão
        $tbAsps = new Application_Model_AsProntuarioSuasUsuario();
        $aspsCodigo = $tbAsps->getDadosPorCidadao($usuCodigo)->asps_codigo;
        // Se cidadão possuir suas, busca beneficios recebido pela familia
        if ($aspsCodigo){
            $codCidsObject = $tbAsps->getCodigosCidadaoFamilia($aspsCodigo);
            $codCids = "";
            foreach($codCidsObject as $val){ $codCids .= $val->usu_codigo.","; }
            $usuCodigos = substr($codCids,0,-1);
        } else {
            $usuCodigos = $usuCodigo;
        }
        $tbAsBenIte = new Application_Model_AsBeneficiosDadosItens();
        $this->view->dados = $tbAsBenIte->getBeneficiosFamilia($usuCodigos);
    }

    function calculaIdade($data_nascimento) {

        $data_nasc = explode('/', $data_nascimento);
        $data = date('d/m/Y');
        $data = explode("/", $data);
        $anos = $data[2] - $data_nasc[2];
        if ($data_nasc[1] >= $data[1]){
            if ($data_nasc[0] <= $data[0]){
                return $anos;
            } else {
                return $anos-1;
            }
        } else {
            return $anos;
        }
    }

    public function formCadastroItensBeneficioAction() {
        $this->_helper->layout->disableLayout();
    }

    private function moedaBD($get_valor) {
        $source = array('.', ',');
        $replace = array('', '.');
        $valor = str_replace($source, $replace, $get_valor); //remove os pontos e substitui a virgula pelo ponto
        return $valor; //retorna o valor formatado para gravar no banco
    }

}
