<?php

class Atendimentocras_EncaminhamentoController extends Zend_Controller_Action {

    public function init() {
        //$this->_helper->acl->allow(NULL,array("buscar"));
    }

    public function indexAction() {
        $this->view->title = "ENCAMINHAMENTO";
        $this->_helper->layout->setLayout("simples");
        $tbAsEnc =  new Application_Model_AsEncaminhamento();
        $usrLogin = $this->_request->getParam("id_login");
        $this->view->usr_codigo = $this->getDadosUsuarioLogado($usrLogin);

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;

      $this->view->dados = $tbAsEnc->getDados($tipoUnidade, $this->view->usr_codigo);
    }

    public function formAction() {
        $this->_helper->layout->disableLayout();
        $asencCodigo = $this->_request->getParam("asenc_codigo");
        if ($asencCodigo){
            $tbAsEnc =  new Application_Model_AsEncaminhamento();
            $this->view->dados = $tbAsEnc->getDadosPorId($asencCodigo);
            $asecCodigo = $this->view->dados->asec_codigo;
            $aseCodigo = $this->view->dados->ase_codigo;
        }
        $tbAsEc = new Application_Model_AsEncaminhamentoCodigos();
        $this->view->selectEncCods = $tbAsEc->selectTag($asecCodigo);
        $tbEst = new Application_Model_AsEstabelecimentos();
        $this->view->selectEst = $tbEst->selectTag($aseCodigo);
        $this->view->usr_codigo = $this->_request->getParam("usr_codigo_logado");
    }

    public function formSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $asencCodigoPost = $this->_request->getPost("asenc_codigo");
            $dados = array_map("strtoupper", $_POST);
            // Removendo dados não utilizado
            unset($dados["uni_desc"]);
            unset($dados["usr_nome"]);
            unset($dados["usu_nome"]);
            unset($dados["usr_codigo_logado"]);
            $tbAsEnc = new Application_Model_AsEncaminhamento();
            $asencCodigo = $tbAsEnc->salvar($dados);
            // Validação se cidadão possui familia no Prontuario Suas
            $tbAspsu = new Application_Model_AsProntuarioSuasUsuario();
            $usuCodigo = $this->_request->getPost("usu_codigo");
            $aspsCodigo = $tbAspsu->getDadosPorCidadao($usuCodigo)->asps_codigo;
            if ($aspsCodigo && $asencCodigoPost=="") {
                $dadosPront = array(
                    "asps_codigo" => $aspsCodigo,
                    "usr_codigo" => $this->_request->getPost("usr_codigo_logado"),
                    "usu_codigo" => $usuCodigo,
                    "aspsrs_descricao" => "ENCAMINHAMENTO",
                    "aspsrs_codigo_desc" => "9",
                );
                $tbAsRegSim = new Application_Model_AspsRegistroSimplificado();
                $tbAsRegSim->salvar($dadosPront);
            }
            $this->view->dados = $asencCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction(){
        $this->_helper->layout->disableLayout();
        $tbAsEnc =  new Application_Model_AsEncaminhamento();
        $busca = $this->_request->getPost("busca");

	    //Verifica o tipo da unidade logada
	    $tbUni = new Application_Model_Unidade();
	    $tipoUnidade = $tbUni->verificaAcessoUnidade($_SESSION['logon']['usr']->uni_codigo)->uni_astipo;
        $tbUsr = new Application_Model_Usuarios();
        $usr_codigo = $tbUsr->getUsrAtual();
        $this->view->dados = $tbAsEnc->pesquisaDados($busca, $tipoUnidade, $usr_codigo)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function getDadosUsuarioLogado($usrLogin){
        $tbUsr = new Application_Model_Usuarios();
        return $tbUsr->getDadosPeloLogin($usrLogin)->usr_codigo;
    }

    public function imprimirAction(){
        Zend_Layout::getMvcInstance()->setLayout("paisagem-print");
        // Dados Secretaria
        $tbSec = new Application_Model_Secretaria();
        $this->view->secretaria  = $tbSec->getDadosSec();
        $this->view->tipo_impressao = "ENCAMINHAMENTO";
        $this->view->title = "Imprimir encaminhamento";
        // Dados beneficio recebido
        $tbAsEnc =  new Application_Model_AsEncaminhamento();
        $asencCodigo = $this->_request->getParam("asenc_codigo");
        $this->view->dados = $tbAsEnc->getDadosPorId($asencCodigo);
        $this->view->codigoBarras = $this->view->dados->asenc_codigo;
    }

}
