<?php

// Referênca Tabela: Usuario
// Motivo: Seguir a mesma estrutura do Saúde e realizar possíveis Iterações
class Cidadao_CidadaoController extends Zend_Controller_Action {

    public function init(){
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/usuarios/form.js');
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.pstrength-min.1.2.js');
        $this->view->headLink()->appendStylesheet($this->view->baseUrl().'/public/css/usuarios/form.css','all');
        parent::init();
    }

    public function indexAction(){
        $this->_helper->Layout->setLayout("simples");
        $tbUsu = new Application_Model_Usuario();
        $this->view->dados = $tbUsu->getDados();
    }

    public function buscaGeralAction() {
        /*
         * Funcao busca cidadao, por nome cpf e nome da mae, nessa ordem de prioridade
         */
        $tbUsu = new Application_Model_Usuario();
        $term = $this->_getParam("term",FALSE);
        $all = $tbUsu->buscaCidadaosGeral($term);
        $buscaPorMae = $tbUsu->buscaCidadaoPorMae($term);
        $buscaPorNis = $tbUsu->buscaCidadaoPorNis($term);

        //Busca por nome fica em prioridade, sendo a primeira a alimentar o array
        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        /*
         * Busca por nome da mae é de menor prioridade, alimentandop o array
         * depois do nome do cidadao
        */
        foreach ($buscaPorMae as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        /*
         * Busca por NIS é de menor prioridade, alimentando o array
         * depois do nome da mãe
        */
        foreach ($buscaPorNis as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        //Se busca vier vazia, retorna essa resposta
        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usu_codigo" => "0", "usu_mae" => "", "usu_datanasc" => "", "usu_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    public function buscaAction() {
        $tbUsu = new Application_Model_Usuario();
        $term = $this->_getParam("term",FALSE);
        $all = $tbUsu->buscaCidadaos($term);
        $buscaPorNis = $tbUsu->buscaCidadaoPorNis($term);

        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        foreach ($buscaPorNis as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usu_codigo" => "0", "usu_mae" => "", "usu_datanasc" => "", "usu_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    public function buscaDadosCidadaoRefAction() {
        $tbUsu = new Application_Model_Usuario();
        $term = $this->_getParam("term",FALSE);
        $all = $tbUsu->buscaDadosCidadaoRef($term);

        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usu_codigo" => "0", "usu_mae" => "", "usu_datanasc" => "", "usu_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    public function buscaCidadaoSemFamiliaAction() {
        $tbUsu = new Application_Model_Usuario();
        $term = $this->_getParam("term",FALSE);
        $all = $tbUsu->buscaCidadaoSemFamilia($term);

        $out = array();
        foreach ($all as $usu) {
            $data = $usu->toArray();

            $out [] = array(
                "id" => $usu->usu_codigo,
                "label" => $usu->usu_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("usu_codigo" => "0", "usu_mae" => "", "usu_datanasc" => "", "usu_nome" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    public function formCadastroAction(){
        $this->_helper->layout->disableLayout();
        $tbUsu = new Application_Model_Usuario();
        $usuCodigo = $this->_request->getParam("usu_codigo");
        $this->view->tipoCertidao = '';

        if ($usuCodigo) {
          $this->view->dados = $tbUsu->getDadosCidadao($usuCodigo);

          $tbTipoCertidao = new Application_Model_TipoCertidao();
          $this->separaCertidoes($tbTipoCertidao->getTipoCertidao($usuCodigo), $this->view->tipoCertidao);
        }

        $tbRac = new Application_Model_Raca();
        $this->view->raca = $tbRac->fetchAll("rac_ativacao = 'A'");
        $tbEtn = new Application_Model_Etnia();
        $this->view->etnia = $tbEtn->fetchAll();
        $tbEpa = new Application_Model_EsusPais();
        $this->view->esus_pais = $tbEpa->fetchAll();
    }

    private function separaCertidoes($certidoes, &$objCertidao) {
      foreach($certidoes as $certidao) {
        if ($certidao->tipo_certidao == 1) {
          $objCertidao->nascimento = $certidao;
          continue;
        } elseif ($certidao->tipo_certidao == 2) {
          $objCertidao->casamento = $certidao;
          continue;
        }
        $objCertidao->rani = $certidao;
        continue;
      }
    }

    public function formCadastroSalvarAction(){
        $this->_helper->layout->disableLayout();
        try{
            $tbUsu = new Application_Model_Usuario();
            $tbTipoCertidao = new Application_Model_TipoCertidao();

            $dados = [
                "usu_codigo" => $this->trataValor($this->_request->getPost("usu_codigo")),
                "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
                "usu_fone" => $this->trataValor($this->_request->getPost("usu_fone")),
                "usu_mae" => $this->trataValor($this->_request->getPost("usu_mae")),
                "usu_pai" => $this->trataValor($this->_request->getPost("usu_pai")),
                "usu_cpf" => preg_replace('#[^0-9]#','',$this->_request->getPost("usu_cpf")),
                "usu_nis" => ($this->_request->getPost("usu_nis") ? preg_replace('#[^0-9]#','',$this->_request->getPost("usu_nis")):NULL),
                "usu_rg" => $this->trataValor($this->_request->getPost("usu_rg")),
                "usu_rg_emissor" => $this->trataValor($this->_request->getPost("usu_rg_emissor")),
                "uf_sigla_rg" => $this->trataValor($this->_request->getPost("uf_sigla_rg")),
                "usu_rg_dt_emissao" => $this->trataValor($this->_request->getPost("usu_rg_dt_emissao")),
                "usu_sexo" => $this->trataValor($this->_request->getPost("usu_sexo")),
                "usu_obito" => $this->_request->getPost("usu_obito", NULL),
                "usu_dt_obito" => $this->trataValor($this->_request->getPost("usu_dt_obito")),
                "usu_datanasc" => $this->trataValor($this->_request->getPost("usu_datanasc")),
                "usu_asdeficiencia" => $this->trataValor($this->_request->getPost("usu_asdeficiencia")),
                "usu_asdoc_cnprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cnprov")),
                "usu_asdoc_rgprov" => $this->trataValor($this->_request->getPost("usu_asdoc_rgprov")),
                "usu_asdoc_ctpsprov" => $this->trataValor($this->_request->getPost("usu_asdoc_ctpsprov")),
                "usu_asdoc_cpfprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cpfprov")),
                "usu_asdoc_teprov" => $this->trataValor($this->_request->getPost("usu_asdoc_teprov")),
                "rac_codigo" => $this->trataValor($this->_request->getPost("rac_codigo")),
                "etn_codigo" => $this->trataValor($this->_request->getPost("etn_codigo")),
                "epa_codigo" => $this->trataValor($this->_request->getPost("epa_codigo")),
                "nr_portaria_naturalizacao" => $this->trataValor($this->_request->getPost("nr_portaria_naturalizacao")),
                "dt_naturalizacao" => $this->trataValor($this->_request->getPost("dt_naturalizacao")),
                "usu_dt_entrada_pais" => $this->trataValor($this->_request->getPost("usu_dt_entrada_pais")),
                "cid_codigo_nasc" => $this->trataValor($this->_request->getPost("cid_codigo_nasc")),
                "cd_nacionalidade" => $this->trataValor($this->_request->getPost("cd_nacionalidade")),
            ];
            if($dados['usu_codigo'] == null || $dados['usu_codigo'] == ""){
                $dados['usr_cadastro_codigo'] = $_SESSION['usr_codigo'];
                $dados['uni_cadastro_codigo'] = $_SESSION['logon']['usr']->uni_codigo;
                $dados['usu_data_cad'] = date("Y-m-d");
            }
            if($this->_request->getPost("usu_obito") == "t"){
                $dados['usu_bloqueado'] = "t";
            }else {
                $dados['usu_bloqueado'] = "f";
            }
            $codCid = $tbUsu->salvar($dados);
            $this->view->dados = $codCid;

            $arrayNomesCertidoes = [
              0 => 'nascimento',
              1 => 'casamento',
              2 => 'rani',
            ];
            for($i = 0; $i < count($arrayNomesCertidoes); $i++) {
              if ($this->_request->getPost("tipo_certidao_codigo") > 0 && $this->_request->getPost("nome_cartorio_" . $arrayNomesCertidoes[$i])) {
                $dados = [
                  "cer_codigo" => $this->trataValor($this->_request->getPost("cer_codigo_" . $arrayNomesCertidoes[$i])),
                  "usu_codigo" => $this->trataValor($codCid),
                  "tipo_certidao" => ($i + 1),
                  "nome_cartorio" => $this->trataValor($this->_request->getPost("nome_cartorio_" . $arrayNomesCertidoes[$i])),
                  "numero_livro" => $this->trataValor($this->_request->getPost("numero_livro_" . $arrayNomesCertidoes[$i])),
                  "numero_folha" => $this->trataValor($this->_request->getPost("numero_folha_" . $arrayNomesCertidoes[$i])),
                  "numero_termo" => $this->trataValor($this->_request->getPost("numero_termo_" . $arrayNomesCertidoes[$i])),
                  "data_registro" => $this->trataValor($this->_request->getPost("data_registro_" . $arrayNomesCertidoes[$i])),
                  "estado_registro" => $this->trataValor($this->_request->getPost("estado_registro_" . $arrayNomesCertidoes[$i])),
                  "municipio_registro" => $this->trataValor($this->_request->getPost("municipio_registro_" . $arrayNomesCertidoes[$i])),
                  "codigo_cartorio" => $this->trataValor($this->_request->getPost("codigo_cartorio_" . $arrayNomesCertidoes[$i])),
                ];

                $tbTipoCertidao->salvar($dados);
              }
            }

            return $this->render("dados",NULL,TRUE);
        } catch (Exception $ex) {
            $this->view->dados = $ex->getMessage();
            return $this->render("dados",NULL,TRUE);
        }
    }

    public function validaCpfAction(){
        $this->_helper->layout->disableLayout();
        $tbUsu = new Application_Model_Usuario();
        $cpf = $this->_request->getPost("cpf",FALSE);
        $usuCodigo = $this->_request->getPost("usu_codigo",FALSE);
        if ($tbUsu->validaCpf($cpf,$usuCodigo)->usu_codigo){
            $this->view->dados = "cpf-erro";
        } else {
            $this->view->dados = "cpf-ok";
        }
        return $this->render("dados",NULL,TRUE);
    }

    public function validaNomeAction(){
        $this->_helper->layout->disableLayout();
        $nome = $this->trataValor($this->_request->getPost("usu_nome"));
        $usuCodigo = $this->_request->getPost("usu_codigo");
        $tbUsu = new Application_Model_Usuario();
        $this->view->dados = $tbUsu->validaNome($nome,$usuCodigo);
        return $this->render("dados",NULL,TRUE);
    }

    public function getDadosNomeAction(){
        $this->_helper->layout->disableLayout();
        $nome = $this->trataValor($this->_request->getPost("usu_nome"));
        $tbUsu = new Application_Model_Usuario();
        $this->view->dados = $tbUsu->getDadosNome($nome)->usu_codigo;
        return $this->render("dados",NULL,TRUE);
    }

    public function validaDadosBasicoAction(){
        $this->_helper->layout->disableLayout();
        $tbUsu = new Application_Model_Usuario();
        $usuCodigo = $this->_request->getPost("usu_codigo");
        $this->view->dados = $tbUsu->validaDadosBasico($usuCodigo);
        return $this->render("dados",NULL,TRUE);
    }

    public function trataValor($valor){
      return (!empty($valor) ? mb_strtoupper($valor, "UTF-8") : NULL);
    }

    public function formCadastroGeralAction(){
        $this->_helper->layout->disableLayout();
        // Utilizado para setar em qual campo jogará os valores depois de salvo
        $cidCodigo = $this->_request->getParam("cidCodigo");

        if($cidCodigo){
	        $tbCidadao = new Application_Model_Usuario();
	        $this->view->dados = $tbCidadao->getDadosCidadao($cidCodigo);
        }

	    $tbRac = new Application_Model_Raca();
	    $this->view->raca = $tbRac->fetchAll("rac_ativacao = 'A'");
	    $tbEtn = new Application_Model_Etnia();
	    $this->view->etnia = $tbEtn->fetchAll();
	    $tbEpa = new Application_Model_EsusPais();
	    $this->view->esus_pais = $tbEpa->fetchAll();

        $this->view->idCodigo = $this->_request->getParam("idCodigo");
        $this->view->idDesc = $this->_request->getParam("idDesc");
        $this->view->idAlert = $this->_request->getParam("idAlert");
    }

    public function formCadastroGeralSalvarAction(){
        try{
            $tbUsu = new Application_Model_Usuario();
	        $dados = array(

		        "usu_codigo" => $this->trataValor($this->_request->getPost("usu_codigo")),
		        "usu_nome" => $this->trataValor($this->_request->getPost("usu_nome")),
		        "usu_fone" => $this->trataValor($this->_request->getPost("usu_fone")),
		        "usu_mae" => $this->trataValor($this->_request->getPost("usu_mae")),
		        "usu_pai" => $this->trataValor($this->_request->getPost("usu_pai")),
		        "usu_cpf" => preg_replace('#[^0-9]#','',$this->_request->getPost("usu_cpf")),
		        "usu_rg" => $this->trataValor($this->_request->getPost("usu_rg")),
		        "usu_rg_emissor" => $this->trataValor($this->_request->getPost("usu_rg_emissor")),
		        "uf_sigla_rg" => $this->trataValor($this->_request->getPost("uf_sigla_rg")),
		        "usu_rg_dt_emissao" => $this->trataValor($this->_request->getPost("usu_rg_dt_emissao")),
		        "usu_sexo" => $this->trataValor($this->_request->getPost("usu_sexo")),
		        "usu_obito" => $this->trataValor($this->_request->getPost("usu_obito")),
		        "usu_datanasc" => $this->trataValor($this->_request->getPost("usu_datanasc")),
                "usu_dt_obito" => $this->trataValor($this->_request->getPost("usu_dt_obito")),
		        "usu_asdeficiencia" => $this->trataValor($this->_request->getPost("usu_asdeficiencia")),
		        "usu_asdoc_cnprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cnprov")),
		        "usu_asdoc_rgprov" => $this->trataValor($this->_request->getPost("usu_asdoc_rgprov")),
		        "usu_asdoc_ctpsprov" => $this->trataValor($this->_request->getPost("usu_asdoc_ctpsprov")),
		        "usu_asdoc_cpfprov" => $this->trataValor($this->_request->getPost("usu_asdoc_cpfprov")),
		        "usu_asdoc_teprov" => $this->trataValor($this->_request->getPost("usu_asdoc_teprov")),
		        "rac_codigo" => $this->trataValor($this->_request->getPost("rac_codigo")),
		        "etn_codigo" => $this->trataValor($this->_request->getPost("etn_codigo")),
		        "epa_codigo" => $this->trataValor($this->_request->getPost("epa_codigo")),
		        "nr_portaria_naturalizacao" => $this->trataValor($this->_request->getPost("nr_portaria_naturalizacao")),
		        "dt_naturalizacao" => $this->trataValor($this->_request->getPost("dt_naturalizacao")),
		        "usu_dt_entrada_pais" => $this->trataValor($this->_request->getPost("usu_dt_entrada_pais")),
		        "cid_codigo_nasc" => $this->trataValor($this->_request->getPost("cid_codigo_nasc")),
		        "cd_nacionalidade" => $this->trataValor($this->_request->getPost("cd_nacionalidade"))
	        );
            if($dados['usu_codigo'] == null || $dados['usu_codigo'] == ""){
                $dados['usr_cadastro_codigo'] = $_SESSION['usr_codigo'];
                $dados['uni_cadastro_codigo'] = $_SESSION['logon']['usr']->uni_codigo;
                $dados['usu_data_cad'] = date("Y-m-d");
            }
            if($this->_request->getPost("usu_obito") == "t"){
                $dados['usu_bloqueado'] = "t";
            }else {
                $dados['usu_bloqueado'] = "f";
            }
            $this->view->dados = $tbUsu->salvar($dados);
            return $this->render("dados",NULL,TRUE);
        } catch (Exception $exc) {
            $exc->getMessage();
        }
    }

    public function pesquisaDadosAction(){
        $this->_helper->layout->disableLayout();
        $tbUsu =  new Application_Model_Usuario();
        $busca = $this->_request->getPost("busca");
        $this->view->dados = $tbUsu->pesquisaDados($busca)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function excluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbUsu = new Application_Model_Usuario();
            $usuCodigo = $this->_request->getPost("usu_codigo");
            $usuCodigo = $tbUsu->excluir($usuCodigo);
            $this->view->dados = $usuCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

}
