<?php

class BeneficiosController extends Zend_Controller_Action {

    public function init() {
        $this->view->headScript()->appendFile($this->view->baseUrl().'/public/js/jquery.maskMoney.js');
    }

    public function indexAction() {
        $this->view->title = "MÓDULO BENEFÍCIOS";
        $this->_helper->layout->setLayout("simples");
        $tbBen = new Application_Model_Beneficios();
        $this->view->dados = $tbBen->getDados();
    }

    public function formAction() {
        $this->_helper->layout->disableLayout();
        $tbBen = new Application_Model_Beneficios();
        $benCodigo = $this->_request->getParam("cod_ben");
        if ($benCodigo)
            $this->view->dados = $tbBen->getDadosPorId($benCodigo);
    }

    public function formSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $tbBen = new Application_Model_Beneficios();
            $dados = array_map("strtoupper", $_POST);
            $dados["valor"] = $this->moedaBD($dados["valor"]);

            // Valida Edição
            if ($this->_request->getPost("cod_ben")=="") { 
                unset($dados["cod_ben"]);
            }
            $benCodigo = $tbBen->salvar($dados);
            $this->view->dados = $benCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function formExcluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbBen = new Application_Model_Beneficios();
            $benCodigo = $this->_request->getPost("cod_ben");
            $benCodigo = $tbBen->excluir($benCodigo);
            $this->view->dados = $benCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function buscaGeralAction() {
        $tbBen = new Application_Model_Beneficios();
        $term = $this->_getParam("term",FALSE);
        $all = $tbBen->buscaGeral($term);
        
        $out = array();
        foreach ($all as $ben) {
            $data = $ben->toArray();
            $out [] = array(
                "id" => $ben->cod_ben,
                "label" => $ben->beneficio,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("cod_ben" => "0", "beneficio" => "")
            );
        }
        
        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
    
    public function getDadosNomeAction(){
        $this->_helper->layout->disableLayout();
        $nome = $this->_request->getPost("beneficio");
        $tbBen = new Application_Model_Beneficios();
        $this->view->dados = $tbBen->getDadosNome($nome)->cod_ben;
        return $this->render("dados",NULL,TRUE);
    }

    public function pesquisaDadosAction() {
        $this->_helper->layout->disableLayout();
        $tbBen = new Application_Model_Beneficios();
        $busca = $this->_request->getPost("busca");
        $status = $this->_request->getPost("status");
        $this->view->dados = $tbBen->pesquisa($busca, $status)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    private function moedaBD($get_valor) {
        $source = array('.', ',');
        $replace = array('', '.');
        $valor = str_replace($source, $replace, $get_valor); //remove os pontos e substitui a virgula pelo ponto
        return $valor; //retorna o valor formatado para gravar no banco
    }
}
