<?php

class CargosController extends Zend_Controller_Action
{

    public function init()
    {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.maskMoney.js');
    }

    public function indexAction()
    {
        $this->view->title = "CADASTRO DE CARGOS";
        $this->_helper->layout->setLayout("simples");
        $tbMot = new Application_Model_Cargos();
        $this->view->dados = $tbMot->getDados();
    }

    public function formAction()
    {
        $this->_helper->layout->disableLayout();
        $tbCrg = new Application_Model_Cargos();
        $crgCodigo = $this->_request->getParam("crg_codigo");
        if ($crgCodigo)
            $this->view->dados = $tbCrg->getDadosPorId($crgCodigo);
    }

    public function formSalvarAction()
    {
        $this->_helper->layout->disableLayout();
        try {
	        $tbCrg = new Application_Model_Cargos();
            $dados = array_map("strtoupper", $_POST);
            // Valida Edição
            if ($this->_request->getPost("crg_codigo") == "") {
                unset($dados["crg_codigo"]);
            }
            $crgCodigo = $tbCrg->salvar($dados);
            $this->view->dados = $crgCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function formExcluirAction()
    {
        $this->_helper->layout->disableLayout();
        try {
	        $tbCrg = new Application_Model_Cargos();
            $asamCodigo = $this->_request->getPost("asam_codigo");
            $asamCodigo = $tbCrg->excluir($asamCodigo);
            $this->view->dados = $asamCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaGeralAction()
    {
	    $tbCrg = new Application_Model_Cargos();
        $term = $this->_getParam("term", FALSE);
        $all = $tbCrg->buscaGeral($term);

        $out = array();
        foreach ($all as $crg) {
            $data = $crg->toArray();
            $out [] = array(
                "id" => $crg->crg_codigo,
                "label" => $crg->crg_nome,
                "status" => $crg->crg_status,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "status" => "",
                "data" => array("crg_codigo" => "0", "crg_nome" => "", "crg_status" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados", NULL, TRUE);
    }

    public function getDadosNomeAction()
    {
        $this->_helper->layout->disableLayout();
        $nome = $this->_request->getPost("crg_nome");
        $tbCrg = new Application_Model_Cargos();
        $this->view->dados = $tbCrg->getDadosNome($nome)->crg_codigo;
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction()
    {
        $this->_helper->layout->disableLayout();
        $tbCrg = new Application_Model_Cargos();
        $busca = $this->_request->getPost("busca");
        $status = $this->_request->getPost("status");
        $this->view->dados = $tbCrg->pesquisa($busca, $status)->toArray();

        return $this->render("dados", NULL, TRUE);
    }

	public function getCargoPorProfissionalAction(){
		$usr_codigo = $this->_getParam("usr_codigo",FALSE);

		$tbCrg = new Application_Model_Cargos();
		$this->view->dados = $tbCrg->getCargoPorProfissional($usr_codigo)->toArray();
		return $this->render("dados",null,true);
	}
}
