<?php

class CidadeController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->allow(NULL,array("buscar"));
	}

	public function indexAction() {
		// action body
	}
        
        /*-----------------------------------------------------------
        * AÇÃO SOCIAL
        *----------------------------------------------------------*/
        
        public function getCodigoPeloNomeAction(){
            $tbCid = new Application_Model_Cidade();
            $cidade = $this->_request->getPost("cidade");
            $this->view->dados = $tbCid->getCodigoPeloNome($cidade)->toArray();
            return $this->render("dados",NULL,TRUE);
        }
        
        public function buscaDadosAction(){
            $tbCid = new Application_Model_Cidade();
            $term = $this->_request->getParam("term");
            $all = $tbCid->buscaDados($term);
        
            $out = array();
            foreach ($all as $cid) {
                $data = $cid->toArray();

                $out [] = array(
                    "id" => $cid->cid_codigo,
                    "label" => $cid->cid_nome,
                    "data" => $data
                );
            }

            if (!count($out)) {
                $out [] = array(
                    "id" => 0,
                    "label" => "Nenhum item encontrado",
                    "data" => ""
                );
            }
            $this->view->dados = $out;
            return $this->render("dados",NULL,TRUE);
        }
        
        /*-----------------------------------------------------------
        * FIM AÇÃO SOCIAL
        *----------------------------------------------------------/
        
        

	/**
	 * Retorna a cidadades em JSON
	 * O retorno é usado pelo plugin de busca
	 */
	public function buscarAction(){
		$tbCid = new Application_Model_Cidade();
		
		$term = $this->_getParam("term",FALSE);
		$this->view->dados = $tbCid->buscar($term);
		return $this->render("dados", NULL, TRUE);
	}

    public function getCidadePorDistritoAction(){
        $dis_codigo = $this->_getParam("dis_codigo",FALSE);

        $tbCidade = new Application_Model_Cidade();
        $this->view->dados = $tbCidade->getCidadePorDistrito($dis_codigo)->toArray();
        return $this->render("dados",null,true);
    }
}

