<?php

class ConfiguracaoController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Configurações";
	}

	public function indexAction() {
		$tbConifg = new Application_Model_Configuracao();
		$this->view->dados = $tbConifg->fetchAll(NULL, "conf_codigo");
	}
	
	public function salvarAction(){
		if ($this->_request->isPost()) {

			$dados = array(
				"config" => $this->_request->getPost("config",array()),
				"tipo"=> $this->_request->getPost("tipo",array())
			);
			try {
				$tbConf = new Application_Model_Configuracao();
				$tbConf->salvar($dados);
				$this->view->dialog = array("Confirmação", "Configurações salvas com sucesso!", 300, 140);
				$tbConifg = new Application_Model_Configuracao();
				$this->view->dados = $tbConifg->fetchAll(NULL, "conf_codigo");
				$this->render("index");
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) array_merge($dados,$outros);
				$this->render("index");
			}
		} else {
			$this->_redirect("/configuracao");
		}
		
	}

}

