<?php

class EstabelecimentosController extends Zend_Controller_Action {

    public function init() {
        //$this->_helper->acl->allow(NULL,array("buscar"));
    }

    public function indexAction() {
        $this->view->title = "MÓDULO ESTABELECIMENTOS";
        $this->_helper->layout->setLayout("simples");
        $tbAse = new Application_Model_AsEstabelecimentos();
        $this->view->dados = $tbAse->getDados();
    }

    public function formAction() {
        $this->_helper->layout->disableLayout();
        $tbAse = new Application_Model_AsEstabelecimentos();
        $aseCodigo = $this->_request->getParam("ase_codigo");
        if ($aseCodigo)
            $this->view->dados = $tbAse->getDadosPorId($aseCodigo);
    }

    public function formSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $tbAse = new Application_Model_AsEstabelecimentos();
            $dados = array_map("strtoupper", $_POST);
            // Valida Edição
            if ($this->_request->getPost("ase_codigo")=="") { 
                unset($dados["ase_codigo"]);
            }
            $aseCodigo = $tbAse->salvar($dados);
            $this->view->dados = $aseCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    public function formExcluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbAse = new Application_Model_AsEstabelecimentos();
            $aseCodigo = $this->_request->getPost("ase_codigo");
            $aseCodigo = $tbAse->excluir($aseCodigo);
            $this->view->dados = $aseCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction() {
        $this->_helper->layout->disableLayout();
        $tbBen = new Application_Model_AsEstabelecimentos();
        $busca = $this->_request->getPost("busca");
        $status = $this->_request->getPost("status");
        $this->view->dados = $tbBen->pesquisa($busca, $status)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

}
