<?php

class EstadoController extends Zend_Controller_Action {

    public function init() {
    }

    public function indexAction() {
    }

    public function getCodigoPeloNomeAction() {
        $tbEst = new Application_Model_Estado();
        $estado = $this->_request->getPost("estado");
        $this->view->dados = $tbEst->getCodigoPeloNome($estado)->toArray();
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaDadosAction(){
        $tbEst = new Application_Model_Estado();
        $term = $this->_request->getParam("term");
        $all = $tbEst->buscaDados($term);

        $out = array();
        foreach ($all as $est) {
            $data = $est->toArray();

            $out [] = array(
                "id" => $est->uf_codigo,
                "label" => $est->uf_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => ""
            );
        }
        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }

    /**
  	 * Retorna os estados em JSON
  	 * O retorno é usado pelo plugin de busca
  	 */
  	public function buscarAction() {
  		$tbEst = new Application_Model_Estado();
  		$term = $this->_getParam("term", FALSE);
  		$this->view->dados = $tbEst->buscar($term);

  		return $this->render("dados", NULL, TRUE);
  	}

}
