<?php

class MotivoController extends Zend_Controller_Action
{

    public function init()
    {
        $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.maskMoney.js');
    }

    public function indexAction()
    {
        $this->view->title = "MÓDULO MOTIVO";
        $this->_helper->layout->setLayout("simples");
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $this->view->dados = $tbMot->getDados();
    }

    public function formAction()
    {
        $this->_helper->layout->disableLayout();
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $asamCodigo = $this->_request->getParam("asam_codigo");
        if ($asamCodigo)
            $this->view->dados = $tbMot->getDadosPorId($asamCodigo);
    }

    public function formSalvarAction()
    {
        $this->_helper->layout->disableLayout();
        try {
            $tbMot = new Application_Model_AsAtendimentoMotivo();
            $dados = array_map("strtoupper", $_POST);
            // Valida Edição
            if ($this->_request->getPost("asam_codigo") == "") {
                unset($dados["asam_codigo"]);
            }
            $asamCodigo = $tbMot->salvar($dados);
            $this->view->dados = $asamCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function formExcluirAction()
    {
        $this->_helper->layout->disableLayout();
        try {
            $tbBen = new Application_Model_AsAtendimentoMotivo();
            $asamCodigo = $this->_request->getPost("asam_codigo");
            $asamCodigo = $tbBen->excluir($asamCodigo);
            $this->view->dados = $asamCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaGeralAction()
    {
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $term = $this->_getParam("term", FALSE);
        $all = $tbMot->buscaGeral($term);

        $out = array();
        foreach ($all as $mot) {
            $data = $mot->toArray();
            $out [] = array(
                "id" => $mot->asam_codigo,
                "label" => $mot->asam_nome,
                "status" => $mot->asam_status,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "status" => "",
                "data" => array("asam_codigo" => "0", "asam_nome" => "", "asam_status" => "")
            );
        }

        $this->view->dados = $out;
        return $this->render("dados", NULL, TRUE);
    }

    public function getDadosNomeAction()
    {
        $this->_helper->layout->disableLayout();
        $nome = $this->_request->getPost("asam_nome");
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $this->view->dados = $tbMot->getDadosNome($nome)->asam_codigo;
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction()
    {
        $this->_helper->layout->disableLayout();
        $tbMot = new Application_Model_AsAtendimentoMotivo();
        $busca = $this->_request->getPost("busca");
        $status = $this->_request->getPost("status");
        $this->view->dados = $tbMot->pesquisa($busca, $status)->toArray();

        return $this->render("dados", NULL, TRUE);
    }
}
