<?php

class PacienteController extends Zend_Controller_Action {

	public function init() {
            $this->_helper->acl->allow(NULL);
	}
        
        public function index(){
            
        }  
        
        public function buscarDomicilioAction(){
            $term = $this->_getParam("term",FALSE);
            $tbDom = new Application_Model_Domicilio();
            $this->view->dados = $tbDom->buscaDomicilio($term);; 
            return $this->render("dados",NULL,TRUE);
        }
        
        public function buscarUsuariosAction(){
            $tbUsu = new Application_Model_Usuario();
            $term = $this->_getParam("term",FALSE);
            $this->view->dados = $tbUsu->buscarUsuarios($term);
            return $this->render("dados", NULL, TRUE);
        }


        public function buscarNumerosDeDomicilioPorEnderecoAction(){
            $rua_nome = $this->_getParam("rua_nome",FALSE);
            $rua_cep = $this->_getParam("rua_cep",FALSE);
            $rua_bairro = $this->_getParam("rua_bairro",FALSE);
            $term = $this->_getParam("term",FALSE);
            $tbDom = new Application_Model_Domicilio();
            $this->view->dados = $tbDom->buscarNumerosDeDomicilioPorEndereco($rua_nome,$rua_cep,$rua_bairro,$term);
            return $this->render("dados",NULL,TRUE);
        }
        
        public function buscarRuaAction(){
            $tbConf = new Application_Model_Configuracao();
            $tbRua = new Application_Model_Rua();
            $codIbge = $tbConf->getConfig("CID_CODIGO_IBGE");
            $codCid = $tbRua->getDadosCidadeEstado($codIbge)->cid_codigo;
            $term = $this->_getParam("term",FALSE);
            $this->view->dados = $tbRua->buscarRua($codCid, $term);
            return $this->render("dados",NULL,TRUE);
        }
        
        public function buscarCepAction(){
            $tbConf = new Application_Model_Configuracao();
            $tbRua = new Application_Model_Rua();
            $codIbge = $tbConf->getConfig("CID_CODIGO_IBGE");
            $codCid = $tbRua->getDadosCidadeEstado($codIbge)->cid_codigo;
            $term = $this->_getParam("term",FALSE);
            $this->view->dados = $tbRua->buscarCep($codCid,$term);
            return $this->render("dados",NULL,TRUE);
        }
        
        public function buscaEstadoPorPaisAction(){
            $pais_codigo = $this->_request->getPost("pais_codigo");
            //$pais_codigo = $this->_getParam("pais_codigo",FALSE);
            $tbEst = new Application_Model_Estado();
            $this->view->dados = $tbEst->listaEstadoPorPais($pais_codigo)->toArray();
            
            
            return $this->render("dados", NULL, TRUE);
        }
        
        public function buscaCidadePorEstadoAction(){
            $ufCodigo = $this->_getParam("uf_codigo",FALSE);
            $tbCid = new Application_Model_Cidade();
            //$this->view->dados = $tbCid->fetchAll("uf_codigo = '$uf_codigo'","cid_nome")->toArray();
            $this->view->dados = $tbCid->listaCidadePorEstadoCodigo($ufCodigo)->toArray();
            return $this->render("dados", NULL, TRUE);
        }
        
        public function formPacienteAction() {
            $this->view->title = "Cadastro de Pessoa";
            $tbEsC = new Application_Model_EstadoCivil();
            $tbPais = new Application_Model_Pais();
            $tbEst = new Application_Model_Estado();
            $tbCid = new Application_Model_Cidade();
            $tbUni = new Application_Model_Unidade();
            $tbRac = new Application_Model_Raca();
            $tbOcu = new Application_Model_Ocupacao();
            $tbEsco = new Application_Model_Escolaridade();
            $tbSitF = new Application_Model_SituacaoFamiliar();
            $tbPes = new Application_Model_PessoaPaciente();
            $tbConf = new Application_Model_Configuracao();
            $tbRua = new Application_Model_Rua();
            $codIbge = $tbConf->getConfig("CID_CODIGO_IBGE");
            $dadosEstCid = array(
                "codCid" => $tbRua->getDadosCidadeEstado($codIbge)->cid_codigo,
                "ufSigla" => $tbRua->getDadosCidadeEstado($codIbge)->uf_sigla 
            );
            $this->view->dadosEstCid = $dadosEstCid;
            $pessoa = $this->_getParam("pessoa",FALSE);
            if (!empty($pessoa)) { $this->view->dados = $tbPes->listaDadosPessoa($pessoa); }
            $this->view->unidade = $tbUni->fetchAll();
            $this->view->estadoCivil = $tbEsC->fetchAll();
            $this->view->pais = $tbPais->fetchAll();
            $this->view->estado = $tbEst->fetchAll();
            $this->view->cidade = $tbCid->listaCidadePorEstado($dadosEstCid["ufSigla"]);
            $this->view->raca = $tbRac->fetchAll();
            $this->view->ocupacao = $tbOcu->fetchAll();
            $this->view->escolaridade = $tbEsco->fetchAll();
            $this->view->situacaoFamiliar = $tbSitF->fetchAll();
            return $this->render("form-paciente");
	}
        
        // Método responsavél o cadastro de pessoa no aise, paciente, rua, domicilio no social
        public function salvarAction(){
            $this->_helper->layout->disableLayout();
            $this->view->headScript()->appendFile($this->view->baseUrl().'/public/js/default/paciente/form-paciente.js');
            $this->view->title = "Cadastro de Pessoa";
            if($this->_request->isPost()){
                // Array de Dados Pessoa Aise
                $pessoa = array(
                    "tipopessoa" => "F",
                    "nome" => ($this->_request->getPost("nome", "") ? $this->_request->getPost("nome", ""): NULL) ,
                    "nomefantasia" => ($this->_request->getPost("nome","") ? $this->_request->getPost("nome","") : NULL),
                    "datanascimento" => ($this->_request->getPost("datanascimento", "") ? $this->_request->getPost("datanascimento", "") : NULL),
                    "datainclusao" => date("Y-m-d"),
                    "rg" => ($this->_request->getPost("rg", "") ? $this->_request->getPost("rg", "") : NULL),
                    "orgaoemissor" => ($this->_request->getPost("orgaoemissor", "") ? $this->_request->getPost("orgaoemissor", "") : NULL),
                    "dataemissao" => ($this->_request->getPost("dataemissao", "") ? $this->_request->getPost("dataemissao", "") : NULL),
                    "estadoemissor" => ($this->_request->getPost("estadoemissor", "") ? $this->_request->getPost("estadoemissor", "") : NULL),
                    "pispasep" => ($this->_request->getPost("pispasep", "") ? $this->_request->getPost("pispasep", "") : NULL),
                    "cnpj_cpf" => ($this->_request->getPost("cnpj_cpf", "") ? $this->_request->getPost("cnpj_cpf", "") : NULL)
                );
                // Array de Dados Pessoa Paciente Social
                $pessoa_paciente = array(
                    "cid_codigo" => ($this->_request->getPost("cid_codigo", "") ? $this->_request->getPost("cid_codigo", "") : NULL),
                    "pep_bloqueado"  => ($this->_request->getPost("pep_bloqueado", "") ? $this->_request->getPost("pep_bloqueado", "") : NULL),
                    "pep_sexo"  => ($this->_request->getPost("pep_sexo", "") ? $this->_request->getPost("pep_sexo", "") : NULL),
                    "pep_mae"   => ($this->_request->getPost("pep_mae", "") ? $this->_request->getPost("pep_mae", "") : NULL),
                    "pep_pai"  => ($this->_request->getPost("pep_pai", "") ? $this->_request->getPost("pep_pai", "") : NULL),
                    "pep_email"  => ($this->_request->getPost("pep_email", "") ? $this->_request->getPost("pep_email", "") : NULL),
                    "pep_celular"  => ($this->_request->getPost("pep_celular", "") ? $this->_request->getPost("pep_celular", "") : NULL),
                    "pep_telefone"  => ($this->_request->getPost("pep_telefone", "") ? $this->_request->getPost("pep_telefone", "") : NULL),
                    "pep_responsavel"  => ($this->_request->getPost("pep_responsavel", "") ? $this->_request->getPost("pep_responsavel", "") : NULL),
                    "estc_codigo"  => ($this->_request->getPost("estc_codigo", "") ? $this->_request->getPost("estc_codigo", "") : NULL),
                    "pep_conjuge" => ($this->_request->getPost("pep_conjuge", "") ? $this->_request->getPost("pep_conjuge", "") : NULL),
                    "pep_obito"  => ($this->_request->getPost("pep_obito", "") ? $this->_request->getPost("pep_obito", "") : NULL),
                    "pep_data_obito"  => ($this->_request->getPost("pep_data_obito", "") ? $this->_request->getPost("pep_data_obito", "") : NULL),
                    "pais_codigo"  => ($this->_request->getPost("pais_codigo", "") ? $this->_request->getPost("pais_codigo", "") : NULL),
                    "pep_cartao_sus"  => ($this->_request->getPost("pep_cartao_sus", "") ? $this->_request->getPost("pep_cartao_sus", "") : NULL),
                    "pep_cartorio_nasc"  => ($this->_request->getPost("pep_cartorio_nasc", "") ? $this->_request->getPost("pep_cartorio_nasc", "") : NULL),
                    "pep_livro_nasc"  => ($this->_request->getPost("pep_livro_nasc", "") ? $this->_request->getPost("pep_livro_nasc", "") : NULL),
                    "pep_folha_nasc"  => ($this->_request->getPost("pep_folha_nasc", "") ? $this->_request->getPost("pep_folha_nasc", "") : NULL),
                    "pep_termo_nasc"  => ($this->_request->getPost("pep_termo_nasc", "") ? $this->_request->getPost("pep_termo_nasc", "") : NULL),
                    "uni_codigo"  => ($this->_request->getPost("uni_codigo", "") ? $this->_request->getPost("uni_codigo", "") : NULL),
                    "rac_codigo"  => ($this->_request->getPost("rac_codigo", "") ? $this->_request->getPost("rac_codigo", "") : NULL),
                    "co_ocupacao"  => ($this->_request->getPost("co_ocupacao", "") ? $this->_request->getPost("co_ocupacao", "") : NULL),
                    "pep_cnh"  => ($this->_request->getPost("pep_cnh", "") ? $this->_request->getPost("pep_cnh", "") : NULL),
                    "pep_categoria_cnh" => ($this->_request->getPost("pep_categoria_cnh", "") ? $this->_request->getPost("pep_categoria_cnh", "") : NULL),
                    "pep_carteira_trabalho"  => ($this->_request->getPost("pep_carteira_trabalho", "") ? $this->_request->getPost("pep_carteira_trabalho", "") : NULL),
                    "pep_carteira_trabalho_serie"  => ($this->_request->getPost("pep_carteira_trabalho_serie", "") ? $this->_request->getPost("pep_carteira_trabalho_serie", "") : NULL),
                    "pep_carteira_trabalho_data"  => ($this->_request->getPost("pep_carteira_trabalho_data", "") ? $this->_request->getPost("pep_carteira_trabalho_data", "") : NULL),
                    "pep_titulo_eleitor"  => ($this->_request->getPost("pep_titulo_eleitor", "") ? $this->_request->getPost("pep_titulo_eleitor", "") : NULL),
                    "pep_titulo_zona"  => ($this->_request->getPost("pep_titulo_zona", "") ? $this->_request->getPost("pep_titulo_zona", "") : NULL),
                    "pep_titulo_secao"  => ($this->_request->getPost("pep_titulo_secao", "") ? $this->_request->getPost("pep_titulo_secao", "") : NULL),
                    "pep_transporte_publico"  => ($this->_request->getPost("pep_transporte_publico", "") ? $this->_request->getPost("pep_transporte_publico", "") : NULL),
                    "pep_frenquencia_escolar"  => ($this->_request->getPost("pep_frenquencia_escolar", "") ? $this->_request->getPost("pep_frenquencia_escolar", "") : NULL),
                    "pep_portaria_naturalizacao"  => ($this->_request->getPost("pep_portaria_naturalizacao", "") ? $this->_request->getPost("pep_portaria_naturalizacao", "") : NULL),
                    "pep_data_naturalizacao"  => ($this->_request->getPost("pep_data_naturalizacao", "") ? $this->_request->getPost("pep_data_naturalizacao", "") : NULL),
                    "pep_data_entrada_pais"  => ($this->_request->getPost("pep_data_entrada_pais", "") ? $this->_request->getPost("pep_data_entrada_pais", "") : NULL),
                    "pep_bolsa_alimentacao"  => ($this->_request->getPost("pep_bolsa_alimentacao", "") ? $this->_request->getPost("pep_bolsa_alimentacao", "") : NULL),
                    "pep_bolsa_familia"  => ($this->_request->getPost("pep_bolsa_familia", "") ? $this->_request->getPost("pep_bolsa_familia", "") : NULL),
                    "pep_plano_saude"  => ($this->_request->getPost("pep_plano_saude", "") ? $this->_request->getPost("pep_plano_saude", "") : NULL),
                    "pep_renda"  => ($this->_request->getPost("pep_renda", "") ? $this->_request->getPost("pep_renda", "") : NULL),
                    "pep_observacao"  => ($this->_request->getPost("pep_observacao", "") ? $this->_request->getPost("pep_observacao", "") : NULL),
                    "pep_ecd_codigo"  => ($this->_request->getPost("pep_ecd_codigo", "") ? $this->_request->getPost("pep_ecd_codigo", "") : NULL),
                    "pep_situacao_familiar"  => ($this->_request->getPost("pep_situacao_familiar", "") ? $this->_request->getPost("pep_situacao_familiar", "") : NULL),
                    "usr_cadastro_codigo" => $_SESSION['usr_codigo'],
                    "uni_cadastro_codigo" => $_SESSION['logon']['usr']->uni_codigo
                );
                // Array de dados de rua
                $dadosRua = array(
                    "rua_nome" => ($this->_request->getPost("rua_nome", "") ? $this->_request->getPost("rua_nome", "") : NULL),
                    "cid_codigo" => ($this->_request->getPost("cid_codigo", "") ? $this->_request->getPost("cid_codigo", "") : NULL),
                    "co_tipo_logradouro" => "081",
                    "rua_cep" => ($this->_request->getPost("rua_cep", "") ? $this->_request->getPost("rua_cep", "") : NULL),
                    "rua_bairro" => ($this->_request->getPost("rua_bairro", "") ? $this->_request->getPost("rua_bairro", "") : NULL),
                );
                // Array de dados de domicilio
                $dadosDomicilio = array(
                    "dom_data_cadastro" => date("Y-m-d"),
                    "dom_numero" => ($this->_request->getPost("dom_numero", "") ? $this->_request->getPost("dom_numero", "") : NULL),
                    "dom_complemento" => ($this->_request->getPost("dom_complemento", "") ? $this->_request->getPost("dom_complemento", "") : NULL),
                    "co_tipo_domicilio" => "6",
                    "dom_telefone" => ($this->_request->getPost("dom_telefone", "") ? $this->_request->getPost("dom_telefone", "") : NULL),
                    "usu_codigo_responsavel" => ($this->_request->getPost("usu_codigo_responsavel", "") ? $this->_request->getPost("usu_codigo_responsavel", "") : NULL)
                );
                if ($this->_request->getPost("pep_prontuario")) {
                    $pessoa_paciente["pep_prontuario"] = $this->_request->getPost("pep_prontuario");
                } 
                if ($this->_getParam("pessoa",FALSE)) {
                    $pessoa["pessoa"] = $this->_getParam("pessoa",FALSE);
                }
                // Inicio da transação
                Zend_Db_Table::getDefaultAdapter()->beginTransaction();
                try{
                    // Validação de Inserção do cadastro de domicilio
                    $rua = $this->_request->getPost("rua_nome");
                    // Só começa a realizar as validações e inserçoes se a rua foi informada
                    if (!empty($rua)){
                        // Verifica se já existe rua cadastrada, se já existe retorna o código se nao insere
                        $tbRua = new Application_Model_Rua();
                        if ($tbRua->getQtdCodRuaDuplicada($dadosRua)->rua_codigo != ""){
                            $codRua = $tbRua->getQtdCodRuaDuplicada($dadosRua)->rua_codigo;
                        } else {
                            $codRua = $tbRua->salvarRua($dadosRua);
                        }
                        // Inserindo código de rua no array de domicilio
                        $dadosDomicilio["rua_codigo"] = $codRua;
                        // Verifica se já existe um domicilio cadastrado, se já existe nao faz nada, apenas atualiza o responsável se existir
                        $tbDom = new Application_Model_Domicilio();
                        if ($tbDom->getQtdCodDomicilioDuplicado($dadosDomicilio)->dom_codigo != "") {
                            $codDom = $tbDom->getQtdCodDomicilioDuplicado($dadosDomicilio)->dom_codigo;
                        } else {
                            $codDom = $tbDom->salvarDomicilio($dadosDomicilio);
                        }
                    }
                    // Inserção de Pessoa
                    $tbPes = new Application_Model_Pessoa();
                    $codPes = $tbPes->salvar($pessoa);
                    $confCodPes = $tbPes->confereInsPessoa($codPes);
                    // Inserindo código no array de pessoa paciente
                    $pessoa_paciente["pessoa"] = $codPes;
                    // Se o cadastro de domicilio foi preenchido vincula o paciente ao donicilio
                    if (!empty($rua)) {
                        $pessoa_paciente["dom_codigo"] = $codDom; 
                    }
                    // Inserção de Pessoa Paciente
                    $tbPesPac = new Application_Model_PessoaPaciente();
                    if ($tbPesPac->confereInsPesPaciente($codPes)->pep_codigo != "") {
                        $pessoa_paciente["pep_codigo"] = $tbPesPac->confereInsPesPaciente($codPes)->pep_codigo;
                    } 
                    $codPesPac = $tbPesPac->salvar($pessoa_paciente);
                    // Realizando a inserção dos de dados, se não deu nenhum problema
                    Zend_Db_Table::getDefaultAdapter()->commit();
                }catch(Exception $exc){
                    Zend_Db_Table::getDefaultAdapter()->rollBack();
                    $this->view->dados = $exc->getMessage();
                    //$this->view->dados = (object) array_merge($pessoa,$pessoa_paciente);
                    //$this->view->dados = array("success"=>FALSE, "titulo"=>"Erro", "mensagem"=>$exc->getMessage(), "code"=>$exc->getCode());
                    return $this->render("dados",NULL,TRUE);
                    
                }
                $this->view->dados = "Dados cadastrado com sucesso";
                return $this->render("dados",NULL,TRUE);
                //return $this->render("form-paciente");
                //$this->_helper->redirector("form-paciente", "default", "paciente", $this->view->erro);
                //return $this->_redirect("/default/paciente/form-paciente",$this->view->erro,$this->view->dados);
            } else {
                return $this->_redirect("/default/paciente/form-paciente");
            }
        }
        
        public function getQtdDeCadastroDuplicadoAction(){
            $tbPes = new Application_Model_Pessoa();
            $dadosPessoa = array(
                    "nome" => ($this->_request->getPost("nome", "") ? $this->_request->getPost("nome", ""): NULL) ,
                    "datanascimento" => ($this->_request->getPost("datanascimento", "") ? $this->_request->getPost("datanascimento", "") : NULL),
                    "pep_mae" => ($this->_request->getPost("pep_mae", "") ? $this->_request->getPost("pep_mae", "") : NULL)
            );
            $qtdCadDup = $tbPes->getQtdDeCadastroDuplicado($dadosPessoa)->qtdCadDup;
            $this->view->dados = $qtdCadDup;
            return $this->render("dados",NULL,TRUE);
        }
        
        public function listaCadastrosDuplicadosAction(){
            $this->_helper->layout->disableLayout();
            $dadosPessoa = $this->_getParam("dadosPessoa",FALSE);
            $tbPes = new Application_Model_Pessoa();
            $dadosCadDup = $tbPes->listaCadastroDuplicado($dadosPessoa);
            $this->view->dados = $dadosCadDup;
        }
        
        /*
        public function salvarAction() {
            if ($this->_request->isPost()){
                
                $pessoa = array(
                    "nome" => $this->_request->getPost("nome", ""),
                    "datanascimento" => ($this->_request->getPost("datanascimento", "") ? $this->_request->getPost("datanascimento", "") : "NULL"),
                    "orgaoemissor" => $this->_request->getPost("orgaoemissor", ""),
                    "estadoemissor" => $this->_request->getPost("estadoemissor", ""),
                    "pispasep" => $this->_request->getPost("pispasep", ""),
                    "cnpj_cpf" => $this->_request->getPost("cnpj_cpf", ""),
                    "rg" => $this->_request->getPost("rg", "")
                );
                
                if($this->_request->getPost("dataemissao", ""))
                    $pessoa["dataemissao"] = $this->_request->getPost("dataemissao", "");
                
                
                $pessoa_paciente = array("pep_bloqueado"  => ($this->_request->getPost("pep_bloqueado", "") ? $this->_request->getPost("pep_bloqueado", "") : "NULL"),
                                         "pep_prontuario"  => ($this->_request->getPost("pep_prontuario", "") ? $this->_request->getPost("pep_prontuario", "") : "NULL"),
                                         "pep_sexo"  => ($this->_request->getPost("pep_sexo", "") ? $this->_request->getPost("pep_sexo", "") : "NULL"),
                                         "pep_mae"   => ($this->_request->getPost("pep_mae", "") ? $this->_request->getPost("pep_mae", "") : "NULL"),
                                         "pep_pai"  => ($this->_request->getPost("pep_pai", "") ? $this->_request->getPost("pep_pai", "") : "NULL"),
                                         "pep_responsavel"  => ($this->_request->getPost("pep_responsavel", "") ? $this->_request->getPost(" ", "") : "NULL"),
                                         "pep_conjuge" => ($this->_request->getPost("pep_conjuge", "") ? $this->_request->getPost("pep_conjuge", "") : "NULL"),
                                         "pep_obito"  => ($this->_request->getPost("pep_obito", "") ? $this->_request->getPost("pep_obito", "") : "NULL"),
                                         "pep_data_obito"  => ($this->_request->getPost("pep_data_obito", "") ? $this->_request->getPost("pep_data_obito", "") : "NULL"),
                                         "pais_codigo"  => ($this->_request->getPost("pais_codigo", "") ? $this->_request->getPost("pais_codigo", "") : "NULL"),
                                         "pep_email"  => ($this->_request->getPost("pep_email", "") ? $this->_request->getPost("pep_email", "") : "NULL"),
                                         "pep_celular"  => ($this->_request->getPost("pep_celular", "") ? $this->_request->getPost("pep_celular", "") : "NULL"),
                                         "pep_telefone"  => ($this->_request->getPost("pep_telefone", "") ? $this->_request->getPost("pep_telefone", "") : "NULL"),
                                         "pep_cartao_sus"  => ($this->_request->getPost("pep_cartao_sus", "") ? $this->_request->getPost("pep_cartao_sus", "") : "NULL"),
                                         "pep_cartorio_nasc"  => ($this->_request->getPost("pep_cartorio_nasc", "") ? $this->_request->getPost("pep_cartorio_nasc", "") : "NULL"),
                                         "pep_livro_nasc"  => ($this->_request->getPost("pep_livro_nasc", "") ? $this->_request->getPost("pep_livro_nasc", "") : "NULL"),
                                         "pep_folha_nasc"  => ($this->_request->getPost("pep_folha_nasc", "") ? $this->_request->getPost("pep_folha_nasc", "") : "NULL"),
                                         "uni_codigo"  => ($this->_request->getPost("uni_codigo", "") ? $this->_request->getPost("uni_codigo", "") : "NULL"),
                                         "rac_codigo"  => ($this->_request->getPost("rac_codigo", "") ? $this->_request->getPost("rac_codigo", "") : "NULL"),
                                         "co_ocupacao"  => ($this->_request->getPost("co_ocupacao", "") ? $this->_request->getPost("co_ocupacao", "") : "NULL"),
                                         "pep_cnh"  => ($this->_request->getPost("pep_cnh", "") ? $this->_request->getPost("pep_cnh", "") : "NULL"),
                                         "pep_categoria_cnh" => ($this->_request->getPost("pep_categoria_cnh", "") ? $this->_request->getPost("pep_categoria_cnh", "") : "NULL"),
                                         "pep_carteira_trabalho"  => ($this->_request->getPost("pep_carteira_trabalho", "") ? $this->_request->getPost("pep_carteira_trabalho", "") : "NULL"),
                                         "pep_carteira_trabalho_serie"  => ($this->_request->getPost("pep_carteira_trabalho_serie", "") ? $this->_request->getPost("pep_carteira_trabalho_serie", "") : "NULL"),
                                         "pep_carteira_trabalho_data"  => ($this->_request->getPost("pep_carteira_trabalho_data", "") ? $this->_request->getPost("pep_carteira_trabalho_data", "") : "NULL"),
                                         "pispasep"  => ($this->_request->getPost("pispasep", "") ? $this->_request->getPost("pispasep", "") : "NULL"),
                                         "pep_titulo_eleitor"  => ($this->_request->getPost("pep_titulo_eleitor", "") ? $this->_request->getPost("pep_titulo_eleitor", "") : "NULL"),
                                         "pep_titulo_zona"  => ($this->_request->getPost("pep_titulo_zona", "") ? $this->_request->getPost("pep_titulo_zona", "") : "NULL"),
                                         "pep_titulo_secao"  => ($this->_request->getPost("pep_titulo_secao", "") ? $this->_request->getPost("pep_titulo_secao", "") : "NULL"),
                                         "pep_portaria_naturalizacao"  => ($this->_request->getPost("pep_portaria_naturalizacao", "") ? $this->_request->getPost("pep_portaria_naturalizacao", "") : "NULL"),
                                         "pep_data_naturalizacao"  => ($this->_request->getPost("pep_data_naturalizacao", "") ? $this->_request->getPost("pep_data_naturalizacao", "") : "NULL"),
                                         "pep_data_entrada_pais"  => ($this->_request->getPost("pep_data_entrada_pais", "") ? $this->_request->getPost("pep_data_entrada_pais", "") : "NULL"),
                                         "pep_renda"  => ($this->_request->getPost("pep_renda", "") ? $this->_request->getPost("pep_renda", "") : "NULL"),
                                         "pep_observacao"  => ($this->_request->getPost("pep_observacao", "") ? $this->_request->getPost("pep_observacao", "") : "NULL")
                                    );
                
                $rua = array("rua_cep" => ($this->_request->getPost("rua_cep", "") ? $this->_request->getPost("rua_cep", "") : "NULL"),
                             "rua_nome" => ($this->_request->getPost("rua_nome", "") ? $this->_request->getPost("rua_nome", "") : "NULL"),
                             "rua_bairro" => ($this->_request->getPost("rua_bairro", "") ? $this->_request->getPost("rua_bairro", "") : "NULL"),
                             "cid_codigo" => ($this->_request->getPost("cid_codigo", "") ? $this->_request->getPost("cid_codigo", "") : "NULL"));
                
                
                $domicilio = array("dom_data_cadastro" => "CURRENT_DATE",
                                   "rua_codigo" => $rua_codigo,
                                   "dom_numero" => ($this->_request->getPost("dom_numero", "") ? $this->_request->getPost("dom_numero", "") : "NULL"),
                                   "dom_telefone" => ($this->_request->getPost("dom_telefone", "") ? $this->_request->getPost("dom_telefone", "") : "NULL"),
                                   "co_tipo_domicilio" => "X");
                
                Zend_Db_Table::getDefaultAdapter()->beginTransaction();
                try{
                    $tbAge = new Application_Model_Pessoa();
                    $pessoa = $tbAge->salvar($pessoa);
                    $this->view->dados = array("success"=>TRUE,"pessoa"=>$pessoa);
                    echo $pessoa ."<br/>";
                    if(empty($pessoa))
                        throw new Exception('Problema ao cadastrar pessoa');

                    $pessoa_paciente['pessoa'] = $pessoa;
                    $tbPep = new Application_Model_PessoaPaciente();
                    $pep_codigo = $tbPep->salvar($pessoa_paciente);
                    $this->view->dados_pep = array("success"=>TRUE,"pep_codigo"=>$pep_codigo);

                    /*Se o domicilio for buscado com pela busca generica não salva*/
                    /*if(empty($this->_request->getPost("dom_codigo",""))){

                        $tbRua = new Application_Model_Rua();
                        $rua_codigo = $tbRua->salvar($rua);
                        $this->view->dados_rua = array("success"=>TRUE,"rua_codigo"=>$rua_codigo);

                        if($rua_codigo){
                            $tbDom = new Application_Model_Domicilio();
                            $dom_codigo = $tbDom->salvar($domicilio);
                            $this->view->dados_dom = array("success"=>TRUE,"dom_codigo"=>$dom_codigo);
                        }
                    }
                    Zend_Db_Table::getDefaultAdapter()->commit();

                }catch (Zend_Validate_Exception $exc){ // Exceção de validação
                    Zend_Db_Table::getDefaultAdapter()->rollBack();
                    die($exc);
                        $this->view->dados = array("success"=>FALSE, "titulo"=>"Erro", "mensagem"=>$exc->getMessage(), "code"=>$exc->getCode());

                } 
            }else{
                $this->_redirect("/default/paciente/form-ptaciente");
            }
            //return $this->render("dados", NULL, TRUE);
            return $this->_redirect("/default/paciente/form-paciente");
	}
        */
	public function indexAction() {
		// action body
	}
	
	public function dadosAction(){
		$usu_codigo = $this->_getParam("cod",FALSE);
		if(!$usu_codigo)
			return $this->_redirect("/");
		
		$tbUsu = new Application_Model_Usuario();		
		$this->view->dados = $tbUsu->getDados($usu_codigo);
		$this->view->obs = $this->_getParam("obs",FALSE);
	}
	
	public function historicoDeMedicamentosAction(){
		$usu_codigo = $this->_getParam("cod",FALSE);
		if(!$usu_codigo)
			return $this->_redirect("/");
		
                $tbRecIt = new Application_Model_ReceitaItens();
                $this->view->itens = $tbRecIt->receitasPorUsuario($usu_codigo);
	}
        
        public function historicoDeMedicamentosRetiradosAction(){
		$usu_codigo = $this->_getParam("cod",FALSE);
		if(!$usu_codigo)
			return $this->_redirect("/");
		
		$tbMov = new Application_Model_Movimento();
		$this->view->itens = $tbMov->getMedicamentosDispensados($usu_codigo);
	}
        /**
         *
         *Retorna os ultimos exames que foram solicitados para determinado paciente
         */
        public function historicoDeExamesAction(){
            $usu_codigo = $this->_getParam("cod",FALSE);
            if(!$usu_codigo)
                    return $this->_redirect("/");

            $tbRes = new Application_Model_ResultadoExame();
            $dados = $tbRes->getSolicitados($usu_codigo);
            
            $tbUsr = new Application_Model_Usuarios();
            $id_login = $tbUsr->getUsrAtual();
            
            $tbAge = new Application_Model_Agendamento();
            $age_codigo = $tbAge->usuEmAberto()->age_codigo;
            
            $this->view->age_codigo = $age_codigo;
            $this->view->usr_codigo = $id_login;
            $this->view->itens = $dados;   
	}
        
        public function historicoDeExamesRealizadosAction(){
             $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/default/paciente/historico-de-exames-realizados.js');
                     $this->view->headScript()->appendFile($this->view->baseUrl() . '/public/js/jquery.elevateZoom-2.5.5.min.js');
            $usu_codigo = $this->_getParam("cod",FALSE);
            if(!$usu_codigo)
                    return $this->_redirect("/");

            $tbRes = new Application_Model_ResultadoExame();
            $dados = $tbRes->getColetados($usu_codigo);
            $this->view->itens = $dados;
            
            $tbUpl = new Application_Model_UploadArquivo();
            $dadosImg = $tbUpl->getArquivosPorUsuario($usu_codigo);
            
            $this->view->itensImg = $dadosImg;
            
        }
        
	/**
	 * Retorna os USU's em JSON
	 * O retorno é usado pelo plugin de busca
	 */
	public function buscarAction(){
            $tbUsu = new Application_Model_Usuario();
            $term = $this->_getParam("term",FALSE);
            $this->view->dados = $tbUsu->buscar($term);
            return $this->render("dados", NULL, TRUE);
	}
        
        public function buscarOcupacaoAction(){
            $term = $this->_getParam("term",FALSE);
            $tbOcu = new Application_Model_Ocupacao();
           // echo "<pre>".  print_r($tbEst->fetchAll("pais_codigo = '$pais_codigo'"),1);die();
            $this->view->dados = $tbOcu->buscar($term);
            //die($this->view->estados);
            return $this->render("dados", NULL, TRUE);
        }
        
        public function buscarPessoaAction(){
            $term = $this->_getParam("term",FALSE);
            $tbPes = new Application_Model_Pessoa();
           // echo "<pre>".  print_r($tbEst->fetchAll("pais_codigo = '$pais_codigo'"),1);die();
            $this->view->dados = $tbPes->buscar($term);
            //die($this->view->estados);
            return $this->render("dados", NULL, TRUE);
        }
}

