<?php

class ProcedimentoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->allow(NULL,array("buscar"));
		$this->view->title = "Procedimento";
	}

	public function indexAction() {
		$tbProc = new Application_Model_Procedimento();
		$this->view->itens = $tbProc->getItensCadastrados();
		//$tbAte = new Application_Model_Atendimento();
		//$ate = $tbAte->temAtendimento();
	}

	public function salvarAction() {
		Zend_Registry::get("logger")->log("teste", Zend_Log::INFO);

		if ($this->_request->isPost()) {

			$dados = array(
				"proc_nome" => $this->_request->getPost("proc_nome"),
				"proc_vlsa" => $this->_request->getPost("proc_vlsa", NULL),
				"proc_idade_maxima" => $this->_request->getPost("proc_idade_maxima", null),
				"proc_idade_minima" => $this->_request->getPost("proc_idade_minima", NULL),
				"proc_sexo_novo" => $this->_request->getPost("proc_sexo_novo", NULL),
				"proc_cadastrado_manualmente" => $this->_request->getPost("proc_cadastrado_manualmente", NULL),
				"proc_codigo" => $this->_request->getPost("proc_codigo", NULL)
			);

			try {
				$tbProc = new Application_Model_Procedimento();
				$tbProc->salvar($dados);

				if ($this->_request->getPost("fechaPopUp", 0)) {
					return;
				}
				$this->_redirect("/agenda/procedimento/");
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object) $dados;
				$this->render("novo");
			}
		} else {
			$this->_redirect("agenda/procedimento");
		}
	}

	public function excluirAction() {
		$id = (int) $this->_getParam("id", 0);
		if (!$id)
			return $this->_redirect("/agenda/procedimento");

		$tbProc = new Application_Model_Procedimento();
		$tbProc->excluir($id);

		if ($this->_getParam("json", FALSE)) {
			$this->view->dados = array("success" => TRUE);
			return $this->render("dados", NULL, TRUE);
		}

		return $this->_redirect("/agenda/procedimento");
	}

	public function novoAction() {
		$this->view->fechaPopUp = $this->_getParam("pop", 0);
	}

	public function editarAction() {
		$id = (int) $this->_getParam("id", 0);
		if (!$id)
			return $this->_redirect("/agenda/procedimento");
		$tbProc = new Application_Model_Procedimento();

		$this->view->dados = $tbProc->find($id)->current();
		return $this->render("novo");
	}

	public function pesquisaAction() {
		if ($this->_request->isPost()) {
			$dados = $this->_request->getPost("busca");
			$tbProc = new Application_Model_Procedimento();
			$ouch = $tbProc->pesquisar($dados);
			$this->view->itens = $ouch;
			$this->render("index");
		} else {
			$this->_redirect("agenda/procedimento");
		}
	}

	/**
	 * Retorna os procedimentos em JSON
	 * O retorno é usado pelo plugin de busca
	 */
	public function buscarAction(){
		$tbProc = new Application_Model_Procedimento();
		
		$term = $this->_getParam("term",FALSE);
		$esp_codigo = $this->_getParam("esp",FALSE);
		$this->view->dados = $tbProc->buscar($term,$esp_codigo);
		return $this->render("dados", NULL, TRUE);
	}
}

