<?php

class ProdutoController extends Zend_Controller_Action {

	public function init() {
		$this->_helper->acl->allow(NULL);
	}

	public function indexAction() {
		// action body
	}
	
	/**
	 * Busca os todos produtos (medicamento ou não)
	 * Retorna um json, para ser usado com o plugin jquery.buscar.js
	 */
	public function buscarAction(){
		$term = $this->_getParam("term",FALSE);
                $horus = $this->_getParam("horus",FALSE);
                
		if(!$term)
			return false;
		
		$tbPro = new Application_Model_Produto();
		$limite = $this->_getParam("limite",FALSE);
		if($horus){
                    $this->view->dados = $tbPro->buscarMedicamentosHorus($term, $limite);
                }else{
                    $this->view->dados = $tbPro->buscarMedicamentos($term, $limite);
                }
		
		return $this->render("dados", NULL, TRUE);		
	}
	
	/**
	 * Busca os todos Medicamentos (controlados ou não)
	 * Retorna um json, para ser usado com o plugin jquery.buscar.js
	 */
	public function medicamentoAction(){		
		$term = $this->_getParam("term",FALSE);
		if(!$term)
			return false;
		
		$tbPro = new Application_Model_Produto();
		$limite = $this->_getParam("limite",FALSE);
		
		$this->view->dados = $tbPro->buscarMedicamentos($term, NULL, $limite);
		
		return $this->render("dados", NULL, TRUE);
	}
	
	/**
	 * Busca os Medicamentos do Posto (não-controlados)
	 * Retorna um json, para ser usado com o plugin jquery.buscar.js
	 */
	public function medicamentoPostoAction(){		
		$term = $this->_getParam("term",FALSE);
		if(!$term)
			return false;
		
		$tbPro = new Application_Model_Produto();
		$this->view->dados = $tbPro->buscarMedicamentosPosto($term);
		
		return $this->render("dados", NULL, TRUE);
	}
	
	/**
	 * Busca os Medicamentos Controlados
	 * Retorna um json, para ser usado com o plugin jquery.buscar.js
	 */
	public function medicamentoControladosAction(){		
		$term = $this->_getParam("term",FALSE);
		if(!$term)
			return false;
		
		$tbPro = new Application_Model_Produto();
		$this->view->dados = $tbPro->buscarMedicamentosControlado($term);
		
		return $this->render("dados", NULL, TRUE);
	}
	
	public function reservarAction(){
		$tipo = $this->_request->getPost("tipo", FALSE);
		$codigo = $this->_request->getPost("codigo", FALSE);
		$usr_codigo = $this->_request->getPost("usr_codigo", FALSE);
		$saldo = $this->_request->getPost("saldo", array());
		$cont = $this->_request->getPost("cont", array());
		
		$tbPro = new Application_Model_Produto();
		$tbCFR = new Application_Model_ControleFracionadoReserva();

		try {
			$novos = $tbPro->fracionarVarios($saldo);			
			
			// PHP Bug: array_merge não preserva a chave se ela for int
			// http://br2.php.net/manual/pt_BR/function.array-merge.php#107590
			if($novos){
				foreach($novos as $k => $v)
					$cont[$k] = $v;
			}
			$tbCFR->addParaReserva($tipo, $codigo, $cont,$usr_codigo);
			$this->view->dados = array("success"=>true);
		} catch (Exception $exc) {
			$this->view->dados = array("error"=>true,"mensagem"=>$exc->getMessage());
		}
		
		return $this->render("dados", NULL, TRUE);
	}

	/**
	 * Usado para cancelar a reserva
	 */
	public function retirarReservaAction(){
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		
		$tipo = $this->_request->getPost("tipo", FALSE);
		$codigo = $this->_request->getPost("codigo", FALSE);
		
		if(!$tipo || !$codigo)
			return FALSE;
		
		$tbCFR = new Application_Model_ControleFracionadoReserva();
		$tbCFR->devolver($tipo,$codigo);		
	}
}

