<?php
require_once COMUM_PATH."/reportApi/GeradorRelatorio.php";

class ReunioesController extends Zend_Controller_Action
{
    public function init() {
        /* Initialize action controller here */
    }
    public function indexAction() {
        $tbReu = new Application_Model_AsReunioes();
        $this->_helper->Layout->setLayout("simples");
        $this->view->dados = $tbReu->getReunioes();
    }

    public function formCadastroReunioesAction(){
        $this->_helper->Layout->setLayout("simples");
        $asreu_codigo = $this->_getParam("asreu_codigo", FALSE);
        if($asreu_codigo){
            $tbReu = new Application_Model_AsReunioes();
            $this->view->dados = $tbReu->getReuniao($asreu_codigo);
            $tbReuPart = new Application_Model_AsReunioesParticipantes();
            $this->view->participantes = $tbReuPart->getParticipantes($asreu_codigo);

        }

    }

   public function imprimirAtaAction(){

       $tp_rel = $this->_getParam("tp_rel", NULL);
       $asreu_codigo = $this->_getParam("asreu_codigo", NULL);

       $gerador = new GeradorRelatorio();
       $this->view->dados = $gerador->gerar(
           "SOCIAL",
           "ataReuniao",
           array(
               "asreu_codigo" => $asreu_codigo,
               "tp_rel"=> $tp_rel
           )
       );
       $this->render("dados", NULL, TRUE);
   }

    public function salvarAction(){
    $tbReu = new Application_Model_AsReunioes();
    $dados = array(
        "asreu_codigo" => $this->_request->getPost("asreu_codigo", NULL),
        "asreu_desc" => trim($this->_request->getPost("asreu_desc", NULL)),
        "asreu_titulo" => trim($this->_request->getPost("asreu_titulo", NULL)),
        "asreu_data" => $this->_request->getPost("asreu_data", NULL),
        "asreu_hora_inicio" => $this->_request->getPost("asreu_hora_inicio", NULL),
        "asreu_hora_fim" => $this->_request->getPost("asreu_hora_fim", NULL),
        "uni_codigo" => $this->_request->getPost("uni_codigo", NULL),
        "asreu_numero" => $this->_request->getPost("asreu_numero", NULL),
    );
        try{
            //salvando reunião
            $retorno = $tbReu->salvar($dados);
            $this->view->dados = array("success" => TRUE, "asreu_codigo" => $retorno);
        }catch (Exception $exp){
            $this->view->dados = array("success" => FALSE, "mensagem" => $exp->getMessage());
        }
        return $this->render("dados", NULL, TRUE);

    }
    public function salvaParticipantesReuniaoAction(){
        $tbReuPart = new Application_Model_AsReunioesParticipantes();
        $asreu_codigo = $this->_getParam('asreu_codigo');
        $participantes = $this->_request->getPost("part");

        foreach ($participantes as $key => $part) {
            $participantes[$key]['asreu_codigo'] = $asreu_codigo;
            $tbReuPart->salvar($participantes[$key]);
        }
        $this->view->dados = array("success" => TRUE, "titulo" => "Sucesso", "mensagem" => "Reunião salva com Sucesso!", "asreu_codigo" => "$asreu_codigo");
        return $this->render("dados", NULL, TRUE);

    }

    public function excluirAction(){
        $tbReu = new Application_Model_AsReunioes();
        $asreu_codigo = $this->_getParam("asreu_codigo");
        try{
            $tbReu->excluir($asreu_codigo);
            $this->view->dados = array("success" => TRUE);
        }catch (Exception $exp){
            $this->view->dados = array("success" => FALSE, "mensagem" => $exp->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction(){
        $tbAsReu = new Application_Model_AsReunioes();
        $term = $this->_request->getPost("busca");
        $this->view->dados = $tbAsReu->getReuniaoPesquisa($term)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function grupoUsuariosAction()
    {

        $this->_helper->layout->setLayout("simples");
        $tbGru = new Application_Model_AsGrupoUsuarios();
        $this->view->dados = $tbGru->getGrupos();

    }
    public function grupoParticipantesAction()
    {
        $asgpu_codigo = $this->_request->getParam("asgpu_codigo");
        $this->_helper->layout->setLayout("simples");
        $tbGru = new Application_Model_AsGrupoUsuariosParticipante();
        $this->view->dados = $tbGru->getParticipantes($asgpu_codigo);

    }

    public function excluirParticipanteAction(){
        $tbReuPart = new Application_Model_AsReunioesParticipantes();
        $asreupar_codigo = $this->_getParam("asreupar_codigo");
        try{
            $tbReuPart->excluir($asreupar_codigo);
            $this->view->dados = array("success" => TRUE);
        }catch (Exception $exp){
            $this->view->dados = array("success" => FALSE, "mensagem" => $exp->getMessage());
        }
        return $this->render("dados", NULL, TRUE);
    }
}
