<?php

class RuaController extends Zend_Controller_Action {

	public function init(){
            //$this->_helper->acl->allow(NULL,array("buscar"));
	}
        
        /* ------------------------------------------------------
        * MÉTODOS AÇÃO SOCIAL
        * ------------------------------------------------------*/
        
        public function buscaDadosEnderecoAction(){
            $tbRua = new Application_Model_Rua();
            $term = $this->_request->getParam("term");
            $all = $tbRua->buscaDadosEndereco($term);
        
            $out = array();
            foreach ($all as $rua) {
                $data = $rua->toArray();

                $out [] = array(
                    "id" => $rua->rua_codigo,
                    "label" => $rua->rua_nome,
                    "data" => $data
                );
            }

            if (!count($out)) {
                $out [] = array(
                    "id" => 0,
                    "label" => "Nenhum item encontrado",
                    "data" => ""
                );
            }
            $this->view->dados = $out;
            return $this->render("dados",NULL,TRUE);
        }
        
        function validaRuaExisteAction(){
            $rua = $this->_request->getParam("rua");
            $tbRua = new Application_Model_Rua();
            $this->view->dados = $tbRua->buscaRuaDuplicada($rua)->qtd_rua;
            return $this->render("dados",NULL,TRUE);
        }

        /* ------------------------------------------------------
        * FIM MÉTODOS AÇÃO SOCIAL
        * ------------------------------------------------------*/

	/**
	 * Retorna as ruas em JSON
	 * O retorno é usado pelo plugin de busca
	 */
	public function buscarAction(){
		$tbEsp = new Application_Model_Rua();
		
		$term = $this->_getParam("term",FALSE);
		$this->view->dados = $tbEsp->buscar($term);
		return $this->render("dados", NULL, TRUE);
	}
}

