<?php

class UnidadeController extends Zend_Controller_Action {

    public function init() {
        //$this->_helper->acl->allow(NULL,array("buscar"));
    }

    /* ------------------------------------------------------
     * MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------ */
    
    public function indexAction() {
        $this->view->title = "UNIDADES";
        $this->_helper->layout->setLayout("simples");
        $tbUni = new Application_Model_Unidade();
        $this->view->dados = $tbUni->listaUnidadesAs();
    }
    
    public function formAction(){
        $this->_helper->layout->disableLayout();
        $uniCodigo = $this->_request->getParam("uni_codigo");
        $tbUni = new Application_Model_Unidade();
        if ($uniCodigo)
            $this->view->dados = $tbUni->getUnidade($uniCodigo);
    }
    
    public function formSalvarAction() {
        $this->_helper->layout->disableLayout();
        try {
            $tbUni = new Application_Model_Unidade();
            $dados = array_map("strtoupper", $_POST);
            $dados['uni_cnpj'] = str_replace(array(".", "/", "-"),"",$dados['uni_cnpj']);

            // Valida Edição
            if ($this->_request->getPost("uni_codigo")=="") { unset($dados["uni_codigo"]); }

            $uniCodigo = $tbUni->salvar($dados);
            $this->view->dados = $uniCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function formCadastroResumidoAction() {
        $this->_helper->layout->disableLayout();
        $uniCodigo = $this->_getParam("uni_codigo",FALSE);
        // Edição
        if ($uniCodigo){
            $tbUni = new Application_Model_Unidade();
            $this->view->dados = $tbUni->getUnidade($uniCodigo);
        }
    }
    
    public function formCadastroResumidoSalvarAction() {
        $tbUni = new Application_Model_Unidade();
        $dados = array(
            "uni_desc" => $this->trataValor($this->_request->getPost("uni_desc")),
            "uni_asnumero" => $this->trataValor($this->_request->getPost("uni_asnumero",FALSE)),
            "uni_astipo" => $this->trataValor($this->_request->getPost("uni_astipo",FALSE)),
            "uni_as" => "t"
        );
        // Edição
        if ($this->_request->getPost("uni_codigo")) {
            $dados["uni_codigo"] = $this->_request->getPost("uni_codigo"); 
        }
        try{
            $this->view->dados = $tbUni->salvar($dados);
        } catch (Exception $ex) {
            $this->view->dados = $ex->getMessage();
        }
        return $this->render("dados",NULL,TRUE);
    }

    public function buscaUnidadeAction() {
        $tbUni = new Application_Model_Unidade();
        $term = $this->_request->getParam("term",FALSE);
        $all = $tbUni->buscaUnidade($term);

        $out = array();
        foreach ($all as $uni) {
            $out [] = array(
                "id" => $uni->uni_codigo,
                "label" => $uni->uni_desc,
                "data" => $uni->toArray()
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => ""
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
    
    // Valida se cadastro está completo ou não
    public function validaCadastroAction(){
        $tbUni = new Application_Model_Unidade();
        $uniCodigo = $this->_request->getPost("uni_codigo",FALSE);
        $this->view->dados = $tbUni->validaCadastro($uniCodigo);
        return $this->render("dados",NULL,TRUE);
    }
    
    public function validaNomeAction(){
        $tbUni = new Application_Model_Unidade();
        $uniDesc = $this->_request->getPost("uni_desc",FALSE);
        $uni_codigo = $this->_request->getPost("uni_codigo",FALSE);
        $this->view->dados = $tbUni->validaNomeUnidade($uniDesc, $uni_codigo);
        return $this->render("dados",NULL,TRUE);
    }
    
    public function validaNomeGeralAction(){
        $tbUni = new Application_Model_Unidade();
        $uniDesc = $this->_request->getPost("uni_desc",FALSE);
        $this->view->dados = $tbUni->validaNomeUnidadeGeral($uniDesc)->uni_codigo;
        return $this->render("dados",NULL,TRUE);
    }
    
    public function trataValor($valor){
        $valorFinal = ($valor != "" ? $valor : NULL); 
        return mb_strtoupper($valorFinal,"UTF-8");
    }
    
    public function formExcluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbUni = new Application_Model_Unidade();
            $uniCodigoPost = $this->_request->getPost("uni_codigo");
            $uniCodigo = $tbUni->excluir($uniCodigoPost);
            $this->view->dados = $uniCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }
    
    /* ------------------------------------------------------
     * FIM MÉTODOS AÇÃO SOCIAL
     * ------------------------------------------------------ */

    /**
     * Retorna as especilidades em JSON
     * O retorno é usado pelo plugin de busca
     */
    public function buscarAction() {
        $tbUni = new Application_Model_Unidade();

        $term = $this->_getParam("term", FALSE);
        $this->view->dados = $tbUni->buscar($term);
        return $this->render("dados", NULL, TRUE);
    }
    
    public function alteraUnidadeSuasAction(){
        $tbUni = new Application_Model_AsProntuarioSuasUnidade();
        
        $data = array(
            "aspsuni_codigo" => $tbUni->getCodigoPeloSuas($this->_request->getPost("asps_codigo"))['aspsuni_codigo'],
            "uni_codigo" => $this->_request->getPost("uni_codigo"),
            "asps_codigo" => $this->_request->getPost("asps_codigo")
        );
        
        $tbUni->salvar($data);
        
    }

    public function pesquisaDadosAction() {
        $this->_helper->layout->disableLayout();
        $tbUni = new Application_Model_Unidade();
        $busca = $this->_request->getPost("busca");
        $this->view->dados = $tbUni->pesquisa($busca)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function buscaUnidadeRmaAction() {
        $tbUni = new Application_Model_Unidade();
        $term = $this->_request->getParam("term",FALSE);
        $tipo = $this->_request->getParam("tipo",FALSE);
        $all = $tbUni->buscaUnidadeRma($term,$tipo);

        $out = array();
        foreach ($all as $uni) {
            $out [] = array(
                "id" => $uni->uni_codigo,
                "label" => $uni->uni_desc,
                "data" => $uni->toArray()
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => ""
            );
        }

        $this->view->dados = $out;
        return $this->render("dados",NULL,TRUE);
    }
}
