<?php

class UsuariosController extends Zend_Controller_Action
{

    public function init()
    {
        $this->_helper->acl->allow(NULL, array("buscar", "buscar-usuarios-saude"));
    }

    public function indexAction()
    {
        // action body
    }

    /**
     * Retorna os usuários (usr) em JSON
     * O retorno é usado pelo plugin de busca
     */
    public function buscarAction()
    {
        $tbUsr = new Application_Model_Usuarios();

        $term = $this->_getParam("term", FALSE);
        $externo = $this->_getParam("externo", FALSE); // incluir médico externo (med)?
        $conveniado = $this->_getParam("conveniado", FALSE); // incluir médico externo (med)?

        $this->view->dados = $tbUsr->buscar($term, $externo, $conveniado);
        return $this->render("dados", NULL, TRUE);
    }

    /**
     * Retorna os usuários (usr) em JSON
     * O retorno é usado pelo plugin de busca
     */
    public function buscarProfissionaisAction()
    {
        $tbUsr = new Application_Model_Usuarios();

        $term = $this->_getParam("term", FALSE);
        $conv_codigo = $this->_getParam("conv_codigo", FALSE);

        $this->view->dados = $tbUsr->buscarProfissionais($term, $conv_codigo);
        return $this->render("dados", NULL, TRUE);
    }

    /**
     * Retorna os usuários (usr) em JSON
     * O retorno é usado pelo plugin de busca
     */
    public function buscarUsuariosSaudeAction()
    {
        $tbUsr = new Application_Model_Usuarios();

        $term = $this->_getParam("term", FALSE);

        $this->view->dados = $tbUsr->buscarUsuariosSaude($term);
        return $this->render("dados", NULL, TRUE);
    }

    public function loginAction()
    {
        $tbUsr = new Application_Model_Usuarios();

        $term = $this->_getParam("term", FALSE);

        $this->view->dados = $tbUsr->verificaLoginExistente($term)->logins;
        return $this->render("dados", NULL, TRUE);
    }

    public function jqgridAction()
    {

        $page = $this->_getParam("page", 1);
        $limit = $this->_getParam("rows");
        $sidx = $this->_getParam("sidx", "id");
        $sord = $this->_getParam("sord", "ASC");
        $modelo = $this->_getParam("modelo", FALSE);

        $tbGrau = new Application_Model_GrupoAcessoUsuarios();
        $tbGrau->setFields(array("usr_codigo", "usr_nome"));
        $array_join = array("tabelas" => array("usr" => "usuarios"), "condicoes" => array("usr.usr_codigo=grau.usr_codigo"));
        $this->view->dados = $tbGrau->getGridResource($page, $limit, $sidx, $sord, $modelo);
        //echo "<pre>".print_r( $this->view->dados,1);die();

        return $this->render("dados", NULL, TRUE);
    }
    
    public function atualizaVinculosAction()
    {
        $tbUsr = new Application_Model_Usuarios();
        $tbMed = new Application_Model_MedicoEspecialidade();
        $usuarios = $tbUsr->getDadosParaVinculo();
        $print = array();
        foreach ($usuarios as $usu) {
            $unidade = [
                "mes_codigo" => $usu['mes_codigo'],
                "med_codigo" => $usu['med_codigo'],
                "esp_codigo" => $usu['esp_codigo'],
                "uni_codigo" => $usu['uni_usuario'],
            ];
                $print[] = $tbMed->salvar($unidade);
        }
        foreach ($print as $cod){
            $vinculos[] = $tbUsr->getDadosVinculados($cod);
        }
        $this->view->vinculos = $vinculos;


    }
}

