<?php
class Domicilio_BairroController extends Zend_Controller_Action{

    public function init() {

    }

    public function indexAction() {
        $this->view->title = "MÓDULO BAIRROS";
        $this->_helper->layout->setLayout("simples");
        $tbBai = new Application_Model_Bairro();
        $this->view->dados = $tbBai->getBairros();
    }

    public function formAction() {
        $this->_helper->layout->disableLayout();

        $tbDist = new Application_Model_Distrito();
        $tbConf = new Application_Model_Configuracao();
        $tbCid = new Application_Model_Cidade();
        $tbBai = new Application_Model_Bairro();
        $cid_codigo_ibge = $tbConf->getConfig("CID_CODIGO_IBGE");
        $this->view->cidade = $tbCid->getCidadePeloCodigoIbge($cid_codigo_ibge);
        $this->view->distritos = $tbDist->fetchAll();

        $baiCodigo = $this->_request->getParam("bai_codigo");
        if ($baiCodigo)
            $this->view->dados = $tbBai->getBairro($baiCodigo);
    }

    public function formSalvarAction() {
        $tbBairro = new Application_Model_Bairro();
        $this->_helper->layout->disableLayout();

        $dados = array_map("strtoupper", $_POST);

        if($dados["possui_distrito"] == "N"){
            $dados["dis_codigo"] = null;
        }

        unset($dados["cid_distrito"]);
        unset($dados["cid_codigo_distrito"]);
        unset($dados["possui_distrito"]);
        unset($dados["dis_nome"]);
        unset($dados["cid_nome"]);

        if($this->_request->getPost("bai_codigo", FALSE))
            $dados["bai_codigo"] = $this->_request->getPost("bai_codigo",false);

        try{
            $bai_codigo =  $tbBairro->salvar($dados);
            $this->view->dados = $bai_codigo;
        } catch (Exception $ex) {
            die($ex->getMessage());
        }

        return $this->render("dados",null,true);
    }

    public function formExcluirAction(){
        $this->_helper->layout->disableLayout();
        try {
            $tbBai = new Application_Model_Bairro();
            $baiCodigo = $this->_request->getPost("bai_codigo");
            $baiCodigo = $tbBai->excluir($baiCodigo);
            $this->view->dados = $baiCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction() {
        $this->_helper->layout->disableLayout();
        $tbBai = new Application_Model_Bairro();
        $busca = $this->_request->getPost("busca");
        $this->view->dados = $tbBai->buscaDados($busca)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function formCadastroGeralAction(){
        $this->_helper->layout->disableLayout();
        // Utilizado para setar em qual campo jogará os valores depois de salvo
        $tbDist = new Application_Model_Distrito();
        $tbConf = new Application_Model_Configuracao();
        $tbCid = new Application_Model_Cidade();
        $tbBai = new Application_Model_Bairro();
        $cid_codigo_ibge = $tbConf->getConfig("CID_CODIGO_IBGE");
        $this->view->cidade = $tbCid->getCidadePeloCodigoIbge($cid_codigo_ibge);
        $this->view->distritos = $tbDist->fetchAll();

        $this->view->idCodigo = $this->_request->getParam("idCodigo");
        $this->view->idDesc = $this->_request->getParam("idDesc");
        $this->view->idAlert = $this->_request->getParam("idAlert");
    }

    public function formCadastroGeralSalvarAction(){
        $tbBairro = new Application_Model_Bairro();
        $this->_helper->layout->disableLayout();

        $dados = array(
            "cid_codigo"=>$this->_request->getPost("cid_codigo",FALSE),
            "bai_nome"=>mb_strtoupper($this->_request->getPost("bai_nome",FALSE), "UTF-8"),
            "dis_codigo"=>$this->_request->getPost("dis_codigo",FALSE)
        );

        if($this->_request->getPost("possui_distrito",FALSE) == "S"){
            unset($dados["cid_codigo"]);
        }else{
            unset($dados["dis_codigo"]);
        }
        if($this->_request->getPost("bai_codigo", FALSE))
            $dados["bai_codigo"] = $this->_request->getPost("bai_codigo",false);

        try{
            $bai_codigo =  $tbBairro->salvar($dados);
            $this->view->dados = $tbBairro->getBairroGeral($bai_codigo);

        } catch (Exception $ex) {
            die($ex->getMessage());
        }

        return $this->render("dados",null,true);
    }
}