<?php
class Domicilio_DomicilioController extends Zend_Controller_Action{

    public function indexAction() {
        $this->_helper->layout->disableLayout();

        $dados = array(
            "rua_codigo"  => $this->emptyOrNull($this->_request->getParam("rua_codigo")),
            "rua_cep"     => $this->emptyOrNull($this->_request->getParam("rua_cep")),
            "rua_bairro"  => $this->emptyOrNull($this->_request->getParam("rua_bairro")),
            "dom_numero"  => $this->emptyOrNull($this->_request->getParam("dom_numero")),
            "rua_nome"    => $this->emptyOrNull($this->_request->getParam("rua_nome")),
            "dom_complemento" => $this->emptyOrNull($this->_request->getParam("dom_compl")),
        );

        $tbDom = new Application_Model_Domicilio();
        $this->view->dados = $tbDom->buscarDomicilioPorEndereco($dados);
    }

    public function pesquisaDomicilioPorCodigoAction(){
        $dom_codigo = $this->_request->getParam("dom_codigo");

        $tbDom = new Application_Model_Domicilio();
        $this->view->dados = $tbDom->pesquisaDomicilioPorCodigo($dom_codigo)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    public function verificaDomicilioDuplicadoAction(){
        $dados = array(
            "rua_codigo"  => $this->emptyOrNull($this->_request->getParam("rua_codigo")),
            "dom_numero"  => $this->emptyOrNull($this->_request->getParam("dom_numero")),
            "dom_complemento" => $this->emptyOrNull($this->_request->getParam("dom_compl")),
        );
        $tbDom = new Application_Model_Domicilio();
        $this->view->dados = $tbDom->getQtdCodDomicilioDuplicadoCompl($dados)->toArray();
        return $this->render("dados",NULL,TRUE);
    }

    private function emptyOrNull($campo) {
        return $campo != 'null' ? $campo : null;
    }
}