<?php

class Domicilio_LogradouroController extends Zend_Controller_Action
{

    public function init()
    {

    }

    public function indexAction()
    {
        $this->view->title = "MÓDULO LOGRADOUROS";
        $this->_helper->layout->setLayout("simples");
        $tbLog = new Application_Model_Logradouro();
        $this->view->dados = $tbLog->getRuas();
    }

    public function formAction()
    {
        $this->_helper->layout->disableLayout();

        $this->view->popup = $term = $this->_getParam("popup", 0);
        $tbTpLogr = new Application_Model_TbMsTipoLogradouro();
        $this->view->tp_lograd = $tbTpLogr->getTiposLogradouro();

        $tbLog = new Application_Model_Logradouro();
        $logCodigo = $this->_request->getParam("log_codigo");
        if ($logCodigo) {
            $this->view->dados = $tbLog->getRua($logCodigo);
        }
    }

    public function formSalvarAction()
    {
        $tbRua = new Application_Model_Logradouro();
        $tbBai = new Application_Model_Bairro();
        $this->_helper->layout->disableLayout();

        $dados = array(
            "rua_nome" => mb_strtoupper($this->_request->getPost("rua_nome", FALSE), "UTF-8"),
            "rua_cep" => $this->_request->getPost("rua_cep", FALSE),
            "co_tipo_logradouro" => $this->_request->getPost("co_tipo_logradouro", FALSE),
            "bai_codigo" => $this->_request->getPost("bai_codigo", FALSE)
        );

        if ($this->_getParam("rua_codigo", FALSE))
            $dados[rua_codigo] = $this->_getParam("rua_codigo", FALSE);

        if ($this->_request->getPost("bai_codigo", FALSE))
            $dados["bai_codigo"] = $this->_request->getPost("bai_codigo", false);

        try {
            $id = $tbRua->salvar($dados);
            $dados_bairro = $tbBai->getBairro($this->_request->getPost("bai_codigo", FALSE));
            if ($dados_bairro->cid_nome != "") {
                $cidade = $dados_bairro->cid_nome;
            } else {
                $cidade = $dados_bairro->cid_distrito;
            }
            $this->view->dados = array("id" => $id,
                "nome" => mb_strtoupper($this->_request->getPost("rua_nome", FALSE), "UTF-8"),
                "rua_cep" => $this->_request->getPost("rua_cep", FALSE),
                "bai_codigo" => $this->_request->getPost("bai_codigo", FALSE),
                "bai_nome" => $dados_bairro->cid_nome,
                "cid" => $cidade,
                "dist" => ($dados_bairro->dis_nome ? $dados_bairro->dis_nome : "Não possui "));

            $this->view->dados = $id;
        } catch (Exception $ex) {
            die($ex->getMessage());
        }

        return $this->render("dados", null, true);
    }

    public function formExcluirAction()
    {
        $this->_helper->layout->disableLayout();
        try {
            $tbLog = new Application_Model_Logradouro();
            $logCodigo = $this->_request->getPost("log_codigo");
            $logCodigo = $tbLog->excluir($logCodigo);
            $this->view->dados = $logCodigo;
        } catch (Exception $exc) {
            $this->view->dados = $exc->getMessage();
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function pesquisaDadosAction()
    {
        $this->_helper->layout->disableLayout();
        $tbLog = new Application_Model_Logradouro();
        $busca = $this->_request->getPost("busca");
        $this->view->dados = $tbLog->pesquisaRua($busca)->toArray();
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaDadosEnderecoAction()
    {
        $this->_helper->layout->disableLayout();
        $term = $this->_getParam("term", FALSE);
        $tbLog = new Application_Model_Logradouro();
        $all = $tbLog->buscaLogradouro($term);

        $out = array();
        foreach ($all as $rua) {
            $data = $rua->toArray();

            $out [] = array(
                "id" => $rua->rua_codigo,
                "label" => $rua->rua_nome,
                "data" => $data
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => ""
            );
        }
        $this->view->dados = $out;
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaTipoLogradouroAction()
    {
        $term = $this->_getParam("term", FALSE);
        $tbTpLogr = new Application_Model_TbMsTipoLogradouro();
        $this->view->dados = $tbTpLogr->buscar($term);
        return $this->render("dados", NULL, TRUE);
    }

    public function buscaBairroAction()
    {
        $tbBai = new Application_Model_Bairro();
        $rua_codigo = $this->_getParam("rua_codigo", false);
        $this->view->dados = $tbBai->buscar($this->_request->getParam("term"), $rua_codigo);
        return $this->render("dados", NULL, TRUE);
    }

    /*************************************************/
    public function formCadastroGeralAction()
    {
        $this->_helper->layout->disableLayout();
        $this->view->idCodigo = $this->_request->getParam("idCodigo");
        $this->view->idDesc   = $this->_request->getParam("idDesc");
        $this->view->idAlert  = $this->_request->getParam("idAlert");
    }

    public function formCadastroGeralSalvarAction()
    {
        $tbRua = new Application_Model_Logradouro();
        $tbBai = new Application_Model_Bairro();
        $this->_helper->layout->disableLayout();

        $dados = array(
            "rua_nome" => mb_strtoupper($this->_request->getPost("rua_nome", FALSE), "UTF-8"),
            "rua_cep" => $this->_request->getPost("rua_cep", FALSE),
            "co_tipo_logradouro" => $this->_request->getPost("co_tipo_logradouro", FALSE),
            "bai_codigo" => $this->_request->getPost("bai_codigo", FALSE)
        );

        if ($this->_getParam("rua_codigo", FALSE))
            $dados[rua_codigo] = $this->_getParam("rua_codigo", FALSE);

        if ($this->_request->getPost("bai_codigo", FALSE))
            $dados["bai_codigo"] = $this->_request->getPost("bai_codigo", false);

        try {
            $id = $tbRua->salvar($dados);
            $this->view->dados = $tbRua->getRuaGeral($id);
        } catch (Exception $ex) {
            die($ex->getMessage());
        }

        return $this->render("dados", null, true);
    }
}